/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.action;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.event.FlowEventListener;
import com.jd.easyflow.flow.engine.event.impl.EventFlowListener;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.parser.param.ActionParseParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNodeAction
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(EventNodeAction.class);
    private boolean autoAddEventFlowListener = true;

    public EventNodeAction() {
    }

    public EventNodeAction(boolean autoAddEventFlowListener) {
        this.autoAddEventFlowListener = autoAddEventFlowListener;
    }

    @Override
    public void init(InitContext initContext, Object flowNode) {
        this.initEventActionMap(initContext, (FlowNode)flowNode);
        if (this.autoAddEventFlowListener) {
            List<FlowEventListener> listeners = initContext.getFlow().getEventTrigger().getListenerList();
            boolean exists = false;
            if (listeners != null) {
                for (FlowEventListener listener : listeners) {
                    if (!(listener instanceof EventFlowListener)) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                logger.info("Auto add EventFlowListener");
                initContext.getFlow().getEventTrigger().addListener(new EventFlowListener());
            }
        }
    }

    public Object execute(NodeContext nodeContext, FlowContext context) {
        NodeAction nodeAction;
        Map eventActionMap;
        String event = (String)nodeContext.get("_EVENT");
        if (context.isLogOn() && logger.isInfoEnabled()) {
            logger.info("Event is:" + event);
        }
        if (event == null) {
            event = "NONE";
        }
        if ((eventActionMap = (Map)context.getFlow().getNode(nodeContext.getNodeId()).getProperty("_$eventNodeActionMap")) == null) {
            InitContext initContext = new InitContext();
            initContext.setFlowParser(context.getFlowEngine().getFlowParser());
            initContext.setParseEl(true);
            initContext.setFlow(context.getFlow());
            this.initEventActionMap(initContext, context.getFlow().getNode(nodeContext.getNodeId()));
            eventActionMap = (Map)context.getFlow().getNode(nodeContext.getNodeId()).getProperty("_$eventNodeActionMap");
        }
        if ((nodeAction = (NodeAction)eventActionMap.get(event)) == null) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Event node action is null");
            }
            return null;
        }
        return nodeAction.execute(nodeContext, context);
    }

    private void initEventActionMap(InitContext initContext, FlowNode flowNode) {
        ConcurrentHashMap<String, NodeAction> eventActionMap = (ConcurrentHashMap<String, NodeAction>)flowNode.getProperty("_$eventNodeActionMap");
        if (eventActionMap != null) {
            return;
        }
        eventActionMap = new ConcurrentHashMap<String, NodeAction>();
        Map map = (Map)flowNode.getProperty("events");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                NodeAction nodeAction;
                String event = (String)entry.getKey();
                Object eventConf = entry.getValue();
                Map<String, String> eventActionConfMap = null;
                if (eventConf instanceof String) {
                    eventActionConfMap = new HashMap<String, String>();
                    eventActionConfMap.put("exp", (String)eventConf);
                } else {
                    Map eventConfMap = (Map)eventConf;
                    eventActionConfMap = (Map)eventConfMap.get("action");
                }
                if (eventActionConfMap == null || (nodeAction = initContext.getFlowParser().parseNodeAction(new ActionParseParam(eventActionConfMap, initContext.getFlowList(), initContext.isParseEl(), initContext.getFlow(), flowNode))) == null) continue;
                nodeAction.init(initContext, flowNode);
                eventActionMap.put(event, nodeAction);
            }
        }
        flowNode.setProperty("_$eventNodeActionMap", eventActionMap);
    }

    public boolean isAutoAddEventFlowListener() {
        return this.autoAddEventFlowListener;
    }

    public void setAutoAddEventFlowListener(boolean autoAddEventFlowListener) {
        this.autoAddEventFlowListener = autoAddEventFlowListener;
    }
}

