/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.action;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowEngine;
import com.jd.easyflow.flow.engine.FlowParam;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.engine.impl.FlowContextImpl;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.parser.param.FlowParseParam;
import java.util.List;
import java.util.Map;

public class FlowNodeAction
implements NodeAction {
    protected String flowId;
    protected String[] startNodeIds;
    protected Boolean inherit;
    protected Flow flow;

    public FlowNodeAction() {
    }

    public FlowNodeAction(String flowId, String[] startNodeIds, boolean inherit) {
        this.flowId = flowId;
        this.startNodeIds = startNodeIds;
        this.inherit = inherit;
    }

    @Override
    public <T> T execute(NodeContext nodeContext, FlowContext context) {
        FlowEngine engine = context.getFlowEngine();
        FlowParam param = this.buildFlowParam(nodeContext, context);
        FlowResult subResult = engine.execute(param);
        this.processFlowResult(subResult, nodeContext, context);
        return (T)subResult;
    }

    protected FlowParam buildFlowParam(NodeContext nodeContext, FlowContext context) {
        FlowParam param = new FlowParam();
        param.setFlowId(this.flow == null ? this.flowId : this.flow.getId());
        param.setNodeIds(this.startNodeIds);
        if (this.inherit.booleanValue()) {
            param.setParam(context.getParam().getParam());
            param.setDataMapFrom(context.getParam());
            param.setLogFlag(context.getParam().getLogFlag());
        }
        FlowContextImpl subContext = new FlowContextImpl();
        if (this.inherit.booleanValue()) {
            subContext.setDataFrom(context);
            subContext.setContext(context.getContext());
            subContext.setLogFlag(context.getLogFlag());
            subContext.setElEvaluator(context.getElEvaluator());
        } else {
            subContext.put("_parentContext", context);
            subContext.put("_parentNodeContext", nodeContext);
        }
        subContext.setParentContext(context);
        subContext.setParentNodeContext(nodeContext);
        FlowResult result = new FlowResult();
        if (this.inherit.booleanValue()) {
            result.setResult(context.getResult().getResult());
            result.setDataMapFrom(context.getResult());
        }
        subContext.setFlow(this.flow);
        param.setContext(subContext);
        subContext.setResult(result);
        return param;
    }

    protected void processFlowResult(FlowResult subResult, NodeContext nodeContext, FlowContext context) {
        if (this.inherit.booleanValue() && subResult != null && subResult.getContext() != null && subResult.getContext().isInterrupted()) {
            context.setInterrupted();
        }
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public String[] getStartNodeIds() {
        return this.startNodeIds;
    }

    public void setStartNodeIds(String[] startNodeIds) {
        this.startNodeIds = startNodeIds;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    @Override
    public void init(InitContext initContext, Object parent) {
        Object startNodeId;
        FlowNode node = (FlowNode)parent;
        if (this.flowId == null) {
            Map flowDef;
            this.flowId = (String)node.getProperty("flowId");
            if (this.flowId == null && (flowDef = (Map)node.getProperty("flow")) != null) {
                FlowParseParam param = new FlowParseParam();
                param.setObjectDefinition(flowDef);
                param.setParseEl(initContext.isParseEl());
                List<Flow> flowList = initContext.getFlowParser().parse(param);
                initContext.getFlowList().addAll(flowList);
                Flow subFlow = flowList.get(0);
                this.flowId = subFlow.getId();
                this.flow = subFlow;
            }
        }
        if (this.startNodeIds == null && (startNodeId = node.getProperty("startNodeId")) != null) {
            this.startNodeIds = startNodeId instanceof String ? new String[]{(String)startNodeId} : ((List)startNodeId).toArray(new String[0]);
        }
        if (this.inherit == null) {
            this.inherit = (Boolean)node.getProperty("inherit");
        }
        if (this.inherit == null) {
            this.inherit = true;
        }
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public Flow getFlow() {
        return this.flow;
    }
}

