/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.action.compensate;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.filter.FilterChain;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.action.compensate.CompensateHelper;
import com.jd.easyflow.flow.model.filter.impl.BaseFlowFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompensateFlowFilter
extends BaseFlowFilter {
    private static final String CTX_KEY_ORIGINAL_START_NODES = "_original_start_nodes";

    public CompensateFlowFilter() {
    }

    public CompensateFlowFilter(int order) {
        this.order = order;
    }

    @Override
    public FlowResult doFilter(FlowContext request, FilterChain<FlowContext, FlowResult> chain) {
        if (CompensateHelper.isCompensating(request)) {
            List<NodeContext> originalStartNodes = (List<NodeContext>)request.get(CTX_KEY_ORIGINAL_START_NODES);
            if (originalStartNodes == null) {
                originalStartNodes = request.getStartNodes();
                request.put(CTX_KEY_ORIGINAL_START_NODES, originalStartNodes);
            }
            HashSet<NodeContext> unCompensatedNodes = new HashSet<NodeContext>();
            this.getUnCompensatedEndNodes(unCompensatedNodes, originalStartNodes);
            ArrayList<NodeContext> startNodes = new ArrayList<NodeContext>();
            for (NodeContext endNode : unCompensatedNodes) {
                NodeContext startNode = CompensateHelper.createCompensateNode(endNode);
                startNodes.add(startNode);
            }
            request.setStartNodes(startNodes);
        }
        FlowResult result = chain.doFilter(request);
        return result;
    }

    private void getUnCompensatedEndNodes(Set<NodeContext> nodes, List<NodeContext> flowStartNodes) {
        if (flowStartNodes == null || flowStartNodes.size() == 0) {
            return;
        }
        for (NodeContext nodeContext : flowStartNodes) {
            if (Boolean.TRUE.equals(nodeContext.get("_compensateNodeFlag"))) continue;
            if (nodeContext.getNextNodes() == null || nodeContext.getNextNodes().length == 0) {
                nodes.add(nodeContext);
                continue;
            }
            boolean hasNext = false;
            for (NodeContext next : nodeContext.getNextNodes()) {
                if (Boolean.TRUE.equals(nodeContext.get("_compensateNodeFlag"))) continue;
                hasNext = true;
                break;
            }
            if (!hasNext) {
                nodes.add(nodeContext);
                continue;
            }
            this.getUnCompensatedEndNodes(nodes, Arrays.asList(nodeContext.getNextNodes()));
        }
    }
}

