/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.parser;

import com.jd.easyflow.flow.el.ElEvaluator;
import com.jd.easyflow.flow.el.ElFactory;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.engine.FlowRunner;
import com.jd.easyflow.flow.engine.event.ExpFlowEventListener;
import com.jd.easyflow.flow.engine.event.FlowEventListener;
import com.jd.easyflow.flow.engine.impl.ExpFlowRunner;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.filter.ExpFilter;
import com.jd.easyflow.flow.filter.Filter;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.FlowPostHandler;
import com.jd.easyflow.flow.model.FlowPreHandler;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodePostHandler;
import com.jd.easyflow.flow.model.NodePreHandler;
import com.jd.easyflow.flow.model.action.CompensateNodeAction;
import com.jd.easyflow.flow.model.action.EventNodeAction;
import com.jd.easyflow.flow.model.action.ExpNodeAction;
import com.jd.easyflow.flow.model.action.FlowNodeAction;
import com.jd.easyflow.flow.model.action.InterruptNodeAction;
import com.jd.easyflow.flow.model.action.LoopNodeAction;
import com.jd.easyflow.flow.model.action.ParamExecutorNodeAction;
import com.jd.easyflow.flow.model.flow.post.ExpFlowPostHandler;
import com.jd.easyflow.flow.model.flow.pre.ExpFlowPreHandler;
import com.jd.easyflow.flow.model.node.NodeImpl;
import com.jd.easyflow.flow.model.parser.FlowParser;
import com.jd.easyflow.flow.model.parser.event.ExpFlowParseEventListener;
import com.jd.easyflow.flow.model.parser.event.FlowParseEvent;
import com.jd.easyflow.flow.model.parser.event.FlowParseEventListener;
import com.jd.easyflow.flow.model.parser.param.ActionParseParam;
import com.jd.easyflow.flow.model.parser.param.FlowParseParam;
import com.jd.easyflow.flow.model.parser.param.PostParseParam;
import com.jd.easyflow.flow.model.parser.param.PreParseParam;
import com.jd.easyflow.flow.model.post.ConditionalNodePostHandler;
import com.jd.easyflow.flow.model.post.EventPostHandler;
import com.jd.easyflow.flow.model.post.ExpNodePostHandler;
import com.jd.easyflow.flow.model.post.FixedNodePostHandler;
import com.jd.easyflow.flow.model.pre.ExpNodePreHandler;
import com.jd.easyflow.flow.model.pre.InclusiveCheckPreHandler;
import com.jd.easyflow.flow.model.pre.MultiCheckPreHandler;
import com.jd.easyflow.flow.util.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowParserImpl
implements FlowParser {
    private static final Logger logger = LoggerFactory.getLogger(FlowParser.class);
    private static final String FLOW_STRING_KEY = "_flow_string";
    private static final String PARENT_FLOW_ID_KEY = "_parent_flow_id";
    private static final String MAIN_FLOW_ID_KEY = "_main_flow_id";
    private ElEvaluator elEvaluator;
    private List<FlowParseEventListener> preListeners;
    private List<FlowParseEventListener> postListeners;

    @Override
    public List<Flow> parse(String data) {
        return this.parse(new FlowParseParam(data));
    }

    @Override
    public List<Flow> parse(Map<String, Object> map) {
        return this.parse(new FlowParseParam(map));
    }

    @Override
    public List<Flow> parse(String data, boolean parseEl) {
        return this.parse(new FlowParseParam(data, parseEl));
    }

    @Override
    public List<Flow> parse(Map<String, Object> map, boolean parseEl) {
        return this.parse(new FlowParseParam(map, parseEl));
    }

    @Override
    public List<Flow> parse(FlowParseParam param) {
        int i;
        Object stringDefObj;
        String stringDef = param.getStringDefinition();
        Object defObj = param.getObjectDefinition();
        if (stringDef == null && defObj == null) {
            throw new FlowException("definition is empty");
        }
        Object object = stringDefObj = stringDef == null ? null : JsonUtil.parseObject(stringDef, Object.class);
        if (defObj == null) {
            defObj = stringDefObj;
        }
        if (stringDef == null) {
            stringDef = JsonUtil.toJsonString(defObj);
        }
        List<Object> allFlowList = null;
        if (defObj instanceof Map) {
            allFlowList = this.parseMapDef((Map)defObj, param.isParseEl());
        } else {
            allFlowList = new ArrayList();
            for (i = 0; i < ((List)defObj).size(); ++i) {
                Map defMap = (Map)((List)defObj).get(i);
                List<Flow> flowList = this.parseMapDef(defMap, param.isParseEl());
                allFlowList.addAll(flowList);
                if (i <= 0) continue;
                flowList.get(0).setProperty(FLOW_STRING_KEY, JsonUtil.toJsonString(defMap));
            }
        }
        for (i = 1; i < allFlowList.size(); ++i) {
            ((Flow)allFlowList.get(i)).setProperty(MAIN_FLOW_ID_KEY, ((Flow)allFlowList.get(0)).getId());
        }
        ((Flow)allFlowList.get(0)).setProperty(FLOW_STRING_KEY, stringDef);
        return allFlowList;
    }

    private List<Flow> parseMapDef(Map<String, Object> mapDef, boolean parseEl) {
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        this.parse(mapDef, flowList, parseEl);
        return flowList;
    }

    private Flow parse(Map<String, Object> map, List<Flow> flowList, boolean parseEl) {
        Flow flow = new Flow();
        flow.setFlowParser(this);
        flowList.add(flow);
        int subFlowStartIndex = flowList.size();
        List<FlowParseEventListener> parseListeners = this.parseParseListeners(map, flow, parseEl);
        if (this.preListeners != null && this.preListeners.size() > 0) {
            if (parseListeners == null) {
                parseListeners = new ArrayList<FlowParseEventListener>();
            }
            parseListeners.addAll(0, this.preListeners);
        }
        if (this.postListeners != null && this.postListeners.size() > 0) {
            if (parseListeners == null) {
                parseListeners = new ArrayList<FlowParseEventListener>();
            }
            parseListeners.addAll(this.postListeners);
        }
        this.triggerParseEvent(parseListeners, "PARSE_FLOW_START", map, flow, null, parseEl);
        flow.setId((String)map.get("id"));
        flow.setName((String)map.get("name"));
        flow.setLogFlag((Boolean)map.get("logFlag"));
        Map properties = (Map)map.get("properties");
        flow.putProperties(properties);
        this.parseFlowPreHandler(map.get("pre"), flow, parseEl);
        List nodeListConf = (List)map.get("nodes");
        ArrayList<String> startNodeIdList = new ArrayList<String>();
        if (nodeListConf != null) {
            for (Map nodeConf : nodeListConf) {
                String type;
                boolean start;
                boolean bl = start = nodeConf.get("start") == null ? false : (Boolean)nodeConf.get("start");
                if (start) {
                    startNodeIdList.add((String)nodeConf.get("id"));
                }
                if ("create".equals(type = (String)nodeConf.get("type")) || nodeConf.containsKey("createExp")) {
                    if (!parseEl) continue;
                    String exp = (String)nodeConf.get("createExp");
                    Map<String, Object> elContext = this.createElContext(nodeConf, null, flow);
                    FlowNode node = (FlowNode)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                    if (node == null) continue;
                    node.postConstruct(nodeConf, null);
                    flow.addNode(node);
                    continue;
                }
                NodeImpl node = new NodeImpl();
                node.setId((String)nodeConf.get("id"));
                node.setName((String)nodeConf.get("name"));
                node.putProperties((Map)nodeConf.get("properties"));
                node.setPreHandler(this.parseNodePreHandler(new PreParseParam(nodeConf.get("pre"), flowList, parseEl, flow, node)));
                node.setAction(this.parseNodeAction(new ActionParseParam(nodeConf.get("action"), flowList, parseEl, flow, node)));
                node.setPostHandler(this.parseNodePostHandler(new PostParseParam(nodeConf.get("post"), flowList, parseEl, flow, node)));
                if (node.getProperty("compensateAction") != null) {
                    NodeAction compensateAction = this.parseNodeAction(new ActionParseParam(nodeConf.get("compensateAction"), flowList, parseEl, flow, node));
                    node.setProperty("_$compensateAction", compensateAction);
                }
                node.postConstruct(nodeConf, null);
                flow.addNode(node);
            }
        }
        if (startNodeIdList.size() > 0) {
            flow.setStartNodeIds(startNodeIdList.toArray(new String[0]));
        }
        this.parseFlowPostHandler(map.get("post"), flow, parseEl);
        this.parseListeners(map, flow, parseEl);
        this.parseFilters(map, flow, parseEl);
        this.parseNodeFilter(map, flow, parseEl);
        this.parseNodePreHandlerFilter(map, flow, parseEl);
        this.parseNodeActionFilter(map, flow, parseEl);
        this.parseNodePostHandlerFilter(map, flow, parseEl);
        this.parseFlowPreHandlerFilter(map, flow, parseEl);
        this.parseFlowPostHandlerFilter(map, flow, parseEl);
        this.parseRunner(map, flow, parseEl);
        flow.postConstruct(map, null);
        this.triggerParseEvent(parseListeners, "PARSE_FLOW_END", map, flow, null, parseEl);
        this.triggerParseEvent(parseListeners, "INIT_FLOW_START", map, flow, null, parseEl);
        InitContext initContext = new InitContext();
        initContext.setFlowParser(this);
        initContext.setParseEl(parseEl);
        initContext.setFlowList(flowList);
        initContext.setFlowDefinitionMap(map);
        initContext.setFlow(flow);
        flow.init(initContext, null);
        this.triggerParseEvent(parseListeners, "INIT_FLOW_END", map, flow, null, parseEl);
        for (int j = subFlowStartIndex; j < flowList.size(); ++j) {
            if (flowList.get(j).getProperty(PARENT_FLOW_ID_KEY) != null) continue;
            flowList.get(j).setProperty(PARENT_FLOW_ID_KEY, flowList.get(subFlowStartIndex - 1).getId());
        }
        return flow;
    }

    protected void parseFlowPreHandler(Object preDef, Flow flow, boolean parseEl) {
        if (preDef == null) {
            return;
        }
        if (preDef instanceof String) {
            ExpFlowPreHandler handler = new ExpFlowPreHandler();
            handler.setExp((String)preDef);
            flow.setPreHandler(handler);
            return;
        }
        Map pre = (Map)preDef;
        String type = (String)pre.get("type");
        if ("create".equals(type) || pre.containsKey("createExp")) {
            if (!parseEl) {
                return;
            }
            String exp = (String)pre.get("createExp");
            Map<String, Object> elContext = this.createElContext(pre, null, flow);
            FlowPreHandler preHandler = (FlowPreHandler)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
            if (preHandler != null) {
                preHandler.postConstruct(pre, null);
                flow.setPreHandler(preHandler);
            }
            return;
        }
        throw new IllegalArgumentException("Param illegal " + preDef);
    }

    protected void parseFlowPostHandler(Object postDef, Flow flow, boolean parseEl) {
        if (postDef == null) {
            return;
        }
        if (postDef instanceof String) {
            ExpFlowPostHandler handler = new ExpFlowPostHandler();
            handler.setExp((String)postDef);
            flow.setPostHandler(handler);
            return;
        }
        Map post = (Map)postDef;
        String type = (String)post.get("type");
        if ("create".equals(type) || post.containsKey("createExp")) {
            if (!parseEl) {
                return;
            }
            String exp = (String)post.get("createExp");
            Map<String, Object> elContext = this.createElContext(post, null, flow);
            FlowPostHandler postHandler = (FlowPostHandler)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
            if (postHandler != null) {
                postHandler.postConstruct(post, null);
                flow.setPostHandler(postHandler);
            }
            return;
        }
        throw new IllegalArgumentException("Param illegal " + postDef);
    }

    private void parseListeners(Map<String, Object> map, Flow flow, boolean parseEl) {
        List listeners = (List)map.get("listeners");
        if (listeners != null) {
            for (Object listenerObj : listeners) {
                if (listenerObj instanceof String) {
                    ExpFlowEventListener expListener = new ExpFlowEventListener((String)listenerObj);
                    flow.getEventTrigger().addListener(expListener);
                    continue;
                }
                Map listener = (Map)listenerObj;
                String type = (String)listener.get("type");
                if (!"create".equals(type) && !listener.containsKey("createExp") || !parseEl) continue;
                String exp = (String)listener.get("createExp");
                Map<String, Object> elContext = this.createElContext(listener, null, flow);
                FlowEventListener eventListener = (FlowEventListener)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (eventListener == null) continue;
                eventListener.postConstruct(listener, null);
                flow.getEventTrigger().addListener(eventListener);
            }
        }
    }

    private void parseFilters(Map<String, Object> map, Flow flow, boolean parseEl) {
        List filters = (List)map.get("filters");
        if (filters != null) {
            for (Object filterObj : filters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter flowFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (flowFilter == null) continue;
                flowFilter.postConstruct(filter, null);
                flow.getFilterManager().addFilter(flowFilter);
            }
        }
    }

    private void parseNodeFilter(Map<String, Object> map, Flow flow, boolean parseEl) {
        List nodeFilters = (List)map.get("nodeFilters");
        if (nodeFilters != null) {
            for (Object filterObj : nodeFilters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter nodeFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (nodeFilter == null) continue;
                nodeFilter.postConstruct(filter, null);
                flow.getFilterManager().addNodeFilter(nodeFilter);
            }
        }
    }

    private void parseNodePreHandlerFilter(Map<String, Object> map, Flow flow, boolean parseEl) {
        List nodePreHandlerFilters = (List)map.get("nodePreHandlerFilters");
        if (nodePreHandlerFilters != null) {
            for (Object filterObj : nodePreHandlerFilters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter nodePreHandlerFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (nodePreHandlerFilter == null) continue;
                nodePreHandlerFilter.postConstruct(filter, null);
                flow.getFilterManager().addNodePreHandlerFilter(nodePreHandlerFilter);
            }
        }
    }

    private void parseFlowPreHandlerFilter(Map<String, Object> map, Flow flow, boolean parseEl) {
        List flowPreHandlerFilters = (List)map.get("flowPreHandlerFilters");
        if (flowPreHandlerFilters != null) {
            for (Object filterObj : flowPreHandlerFilters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter flowPreHandlerFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (flowPreHandlerFilter == null) continue;
                flowPreHandlerFilter.postConstruct(filter, null);
                flow.getFilterManager().addFlowPreHandlerFilter(flowPreHandlerFilter);
            }
        }
    }

    private void parseFlowPostHandlerFilter(Map<String, Object> map, Flow flow, boolean parseEl) {
        List flowPostHandlerFilters = (List)map.get("flowPostHandlerFilters");
        if (flowPostHandlerFilters != null) {
            for (Object filterObj : flowPostHandlerFilters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter flowPostHandlerFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (flowPostHandlerFilter == null) continue;
                flowPostHandlerFilter.postConstruct(filter, null);
                flow.getFilterManager().addFlowPostHandlerFilter(flowPostHandlerFilter);
            }
        }
    }

    private void parseNodeActionFilter(Map<String, Object> map, Flow flow, boolean parseEl) {
        List nodeActionFilters = (List)map.get("nodeActionFilters");
        if (nodeActionFilters != null) {
            for (Object filterObj : nodeActionFilters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter nodeActionFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (nodeActionFilter == null) continue;
                nodeActionFilter.postConstruct(filter, null);
                flow.getFilterManager().addNodeActionFilter(nodeActionFilter);
            }
        }
    }

    private void parseNodePostHandlerFilter(Map<String, Object> map, Flow flow, boolean parseEl) {
        List nodePostHandlerFilters = (List)map.get("nodePostHandlerFilters");
        if (nodePostHandlerFilters != null) {
            for (Object filterObj : nodePostHandlerFilters) {
                if (filterObj instanceof String) {
                    ExpFilter<FlowContext, FlowResult> expFilter = new ExpFilter<FlowContext, FlowResult>((String)filterObj);
                    flow.getFilterManager().addFilter(expFilter);
                    continue;
                }
                Map filter = (Map)filterObj;
                String type = (String)filter.get("type");
                if (!"create".equals(type) && !filter.containsKey("createExp") || !parseEl) continue;
                String exp = (String)filter.get("createExp");
                Map<String, Object> elContext = this.createElContext(filter, null, flow);
                Filter nodePostHandlerFilter = (Filter)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                if (nodePostHandlerFilter == null) continue;
                nodePostHandlerFilter.postConstruct(filter, null);
                flow.getFilterManager().addNodePostHandlerFilter(nodePostHandlerFilter);
            }
        }
    }

    private void parseRunner(Map<String, Object> map, Flow flow, boolean parseEl) {
        Map runnerObj = (Map)map.get("runner");
        if (runnerObj != null) {
            if (runnerObj instanceof String) {
                ExpFlowRunner expFlowRunner = new ExpFlowRunner((String)((Object)runnerObj));
                flow.setRunner(expFlowRunner);
            } else {
                Map runner = runnerObj;
                String type = (String)runner.get("type");
                if (("create".equals(type) || runner.containsKey("createExp")) && parseEl) {
                    String exp = (String)runner.get("createExp");
                    Map<String, Object> elContext = this.createElContext(runner, null, flow);
                    FlowRunner flowRunner = (FlowRunner)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
                    if (flowRunner != null) {
                        flowRunner.postConstruct(runner, null);
                        flow.setRunner(flowRunner);
                    }
                }
            }
        }
    }

    @Override
    public NodePreHandler parseNodePreHandler(PreParseParam param) {
        Object preDef = param.getPreDef();
        if (preDef == null) {
            return null;
        }
        if (preDef instanceof String) {
            ExpNodePreHandler handler = new ExpNodePreHandler();
            handler.setExp((String)preDef);
            return handler;
        }
        Map pre = (Map)preDef;
        String type = (String)pre.get("type");
        if ("create".equals(type) || pre.containsKey("createExp")) {
            if (!param.isParseEl()) {
                return null;
            }
            String exp = (String)pre.get("createExp");
            Map<String, Object> elContext = this.createElContext(pre, param.getNode(), param.getFlow());
            NodePreHandler preHandler = (NodePreHandler)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
            if (preHandler != null) {
                preHandler.postConstruct(pre, null);
            }
            return preHandler;
        }
        if ("exp".equals(type) || pre.containsKey("exp")) {
            String exp = (String)pre.get("exp");
            ExpNodePreHandler preHandler = new ExpNodePreHandler();
            preHandler.setExp(exp);
            preHandler.postConstruct(pre, null);
            return preHandler;
        }
        if ("inclusiveCheck".equals(type)) {
            List preNodes = (List)pre.get("preNodes");
            InclusiveCheckPreHandler preHandler = new InclusiveCheckPreHandler();
            preHandler.setPreNodes(preNodes);
            preHandler.postConstruct(pre, null);
            return preHandler;
        }
        if ("multiCheck".equals(type) || pre.containsKey("preNodes")) {
            List preNodes = (List)pre.get("preNodes");
            MultiCheckPreHandler preHandler = new MultiCheckPreHandler();
            preHandler.setPreNodes(preNodes);
            preHandler.postConstruct(pre, null);
            return preHandler;
        }
        throw new IllegalArgumentException("Param illegal " + pre);
    }

    @Override
    public NodeAction parseNodeAction(ActionParseParam param) {
        Object actionDef = param.getActionDef();
        if (actionDef == null) {
            return null;
        }
        if (actionDef instanceof String) {
            ExpNodeAction nodeAction = new ExpNodeAction();
            nodeAction.setExp((String)actionDef);
            return nodeAction;
        }
        Map action = (Map)actionDef;
        String type = (String)action.get("type");
        if ("create".equals(type) || action.containsKey("createExp")) {
            if (!param.isParseEl()) {
                return null;
            }
            String exp = (String)action.get("createExp");
            Map<String, Object> elContext = this.createElContext(action, param.getNode(), param.getFlow());
            NodeAction nodeAction = (NodeAction)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
            if (nodeAction != null) {
                nodeAction.postConstruct(action, null);
            }
            return nodeAction;
        }
        if ("exp".equals(type) || action.containsKey("exp")) {
            ExpNodeAction nodeAction = new ExpNodeAction();
            String exp = (String)action.get("exp");
            nodeAction.setExp(exp);
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        if ("flow".equals(type) || type == null && action.containsKey("flow") || type == null && action.containsKey("flowId")) {
            Boolean inherit;
            FlowNodeAction nodeAction = new FlowNodeAction();
            if (action.containsKey("flow")) {
                Flow flow = this.parse((Map)action.get("flow"), param.getFlowList(), param.isParseEl());
                flow.setProperty(FLOW_STRING_KEY, JsonUtil.toJsonString(action.get("flow")));
                nodeAction.setFlowId(flow.getId());
                nodeAction.setFlow(flow);
            } else if (action.containsKey("flowId")) {
                nodeAction.setFlowId((String)action.get("flowId"));
            }
            Object startNodeId = action.get("startNodeId");
            if (startNodeId != null) {
                if (startNodeId instanceof String) {
                    nodeAction.setStartNodeIds(new String[]{(String)startNodeId});
                } else {
                    nodeAction.setStartNodeIds(((List)startNodeId).toArray(new String[0]));
                }
            }
            if ((inherit = (Boolean)action.get("inherit")) != null) {
                nodeAction.setInherit(inherit);
            }
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        if ("event".equals(type)) {
            EventNodeAction nodeAction = new EventNodeAction();
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        if ("loop".equals(type)) {
            LoopNodeAction nodeAction = new LoopNodeAction();
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        if ("interrupt".equals(type)) {
            InterruptNodeAction nodeAction = new InterruptNodeAction();
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        if ("compensate".equals(type)) {
            CompensateNodeAction nodeAction = new CompensateNodeAction();
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        if ("paramExecutor".equals(type)) {
            ParamExecutorNodeAction nodeAction = new ParamExecutorNodeAction();
            nodeAction.postConstruct(action, null);
            return nodeAction;
        }
        throw new IllegalArgumentException("Param illegal " + action);
    }

    @Override
    public NodePostHandler parseNodePostHandler(PostParseParam param) {
        Object postDef = param.getPostDef();
        if (postDef == null) {
            return null;
        }
        if (postDef instanceof String) {
            ExpNodePostHandler postHandler = new ExpNodePostHandler();
            String exp = (String)postDef;
            postHandler.setExp(exp);
            return postHandler;
        }
        Map post = (Map)postDef;
        String type = (String)post.get("type");
        if ("create".equals(type) || post.containsKey("createExp")) {
            if (!param.isParseEl()) {
                return null;
            }
            String exp = (String)post.get("createExp");
            Map<String, Object> elContext = this.createElContext(post, param.getNode(), param.getFlow());
            NodePostHandler postHandler = (NodePostHandler)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
            if (postHandler != null) {
                postHandler.postConstruct(post, null);
            }
            return postHandler;
        }
        if ("exp".equals(type) || post.containsKey("exp")) {
            ExpNodePostHandler postHandler = new ExpNodePostHandler();
            String exp = (String)post.get("exp");
            postHandler.setExp(exp);
            postHandler.postConstruct(post, null);
            return postHandler;
        }
        if ("condition".equals(type) || type == null && post.containsKey("conditions") || type == null && post.containsKey("when")) {
            List<Map<String, Object>> conditionList = null;
            conditionList = post.containsKey("conditions") ? (List<Map<String, Object>>)post.get("conditions") : Arrays.asList(post);
            String conditionType = (String)post.get("conditionType");
            Object defaultBranch = post.get("defaultTo");
            ConditionalNodePostHandler postHandler = new ConditionalNodePostHandler(conditionType, conditionList, defaultBranch);
            postHandler.postConstruct(post, null);
            return postHandler;
        }
        if ("fixed".equals(type) || type == null && post.containsKey("to")) {
            Object nextStartId = post.get("to");
            FixedNodePostHandler postHandler = new FixedNodePostHandler(nextStartId);
            postHandler.postConstruct(post, null);
            return postHandler;
        }
        if ("event".equals(type)) {
            EventPostHandler postHandler = new EventPostHandler();
            postHandler.postConstruct(post, null);
            return postHandler;
        }
        throw new IllegalArgumentException("Param illegal " + post);
    }

    protected List<FlowParseEventListener> parseParseListeners(Map<String, Object> map, Flow flow, boolean parseEl) {
        List parseListenerConfList = (List)map.get("parseListeners");
        if (parseListenerConfList == null) {
            return null;
        }
        ArrayList<FlowParseEventListener> parseListeners = new ArrayList<FlowParseEventListener>();
        for (Object listenerObj : parseListenerConfList) {
            if (listenerObj instanceof String) {
                ExpFlowParseEventListener parseListener = new ExpFlowParseEventListener((String)listenerObj);
                parseListeners.add(parseListener);
                continue;
            }
            Map listener = (Map)listenerObj;
            String type = (String)listener.get("type");
            if (!"create".equals(type) && !listener.containsKey("createExp") || !parseEl) continue;
            String exp = (String)listener.get("createExp");
            Map<String, Object> elContext = this.createElContext(listener, null, flow);
            FlowParseEventListener parseListener = (FlowParseEventListener)this.getElEvaluator().evalWithDefaultContext(exp, elContext, false);
            if (parseListener == null) continue;
            parseListener.postConstruct(listener, null);
            parseListeners.add(parseListener);
        }
        return parseListeners;
    }

    private void triggerParseEvent(List<FlowParseEventListener> listeners, String eventType, Map<String, Object> flowDef, Flow flow, Object data, boolean parseEl) {
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        FlowParseEvent event = new FlowParseEvent();
        event.setType(eventType);
        event.setFlow(flow);
        event.setFlowDef(flowDef);
        event.setData(data);
        event.setFlowParser(this);
        event.setParseEl(parseEl);
        for (FlowParseEventListener listener : listeners) {
            listener.on(event);
        }
    }

    @Override
    public String stringify(Flow flow) {
        if (flow.getProperty(FLOW_STRING_KEY) != null) {
            return (String)flow.getProperty(FLOW_STRING_KEY);
        }
        logger.warn("No original string definition, unsupported now. flowId: " + flow.getId());
        return null;
    }

    private Map<String, Object> createElContext(Map<String, Object> currentDef, FlowNode node, Flow flow) {
        HashMap<String, Object> context = new HashMap<String, Object>(3);
        context.put("definition", currentDef);
        if (node != null) {
            context.put("node", node);
        }
        if (flow != null) {
            context.put("flow", flow);
        }
        context.put("flowParser", this);
        return context;
    }

    @Override
    public ElEvaluator getElEvaluator() {
        if (this.elEvaluator == null) {
            this.elEvaluator = ElFactory.get();
        }
        return this.elEvaluator;
    }

    public void setElEvaluator(ElEvaluator elEvaluator) {
        this.elEvaluator = elEvaluator;
    }

    public List<FlowParseEventListener> getPreListeners() {
        return this.preListeners;
    }

    public void setPreListeners(List<FlowParseEventListener> preListeners) {
        this.preListeners = preListeners;
    }

    public List<FlowParseEventListener> getPostListeners() {
        return this.postListeners;
    }

    public void setPostListeners(List<FlowParseEventListener> postListeners) {
        this.postListeners = postListeners;
    }
}

