/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.post;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeExecutor;
import com.jd.easyflow.flow.model.post.AbstractNodePostHandler;
import com.jd.easyflow.flow.util.FlowUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalNodePostHandler
extends AbstractNodePostHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalNodePostHandler.class);
    public static final String EXCLUSIVE_TYPE = "exclusive";
    public static final String INCLUSIVE_TYPE = "inclusive";
    private String type;
    private List<Map<String, Object>> branchList;
    private List<Branch> branchInfoList;
    private Object defaultBranch;

    public ConditionalNodePostHandler() {
    }

    public ConditionalNodePostHandler(Map<String, Object> branch) {
        this.branchList = Arrays.asList(branch);
    }

    public ConditionalNodePostHandler(List<Map<String, Object>> branchList) {
        this.branchList = branchList;
    }

    public ConditionalNodePostHandler(String type, List<Map<String, Object>> branchList, Object defaultBranch) {
        this.type = type;
        this.branchList = branchList;
        this.defaultBranch = defaultBranch;
    }

    @Override
    public NodeContext[] postHandle(NodeContext nodeContext, FlowContext context) {
        if (this.branchInfoList == null) {
            this.init(nodeContext, context);
        }
        if (this.type == null || this.type.equals(EXCLUSIVE_TYPE)) {
            for (Branch branch : this.branchInfoList) {
                boolean result = branch.when == null ? true : branch.when.execute(nodeContext, context);
                if (!result) continue;
                return this.parseToNodes(branch.to, nodeContext, context);
            }
            if (this.defaultBranch != null) {
                return this.parseToNodes(this.defaultBranch, nodeContext, context);
            }
        } else {
            ArrayList<NodeContext> nextList = new ArrayList<NodeContext>();
            for (Branch branch : this.branchInfoList) {
                boolean result = branch.when == null ? true : branch.when.execute(nodeContext, context);
                if (!result) continue;
                this.addArray2List(this.parseToNodes(branch.to, nodeContext, context), nextList);
            }
            if (nextList.isEmpty() && this.defaultBranch != null) {
                this.addArray2List(this.parseToNodes(this.defaultBranch, nodeContext, context), nextList);
            }
            if (!nextList.isEmpty()) {
                return this.list2Array(nextList);
            }
        }
        return null;
    }

    private void init(NodeContext nodeContext, FlowContext context) {
        InitContext initContext = new InitContext();
        initContext.setFlowParser(context.getFlowEngine().getFlowParser());
        initContext.setParseEl(true);
        FlowNode node = FlowUtil.node(nodeContext, context);
        this.init(initContext, node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(InitContext initContext, Object parent) {
        ArrayList<Branch> branchInfoList = new ArrayList<Branch>();
        for (Map<String, Object> branch : this.branchList) {
            Branch branchInfo = new Branch();
            Object whenObj = branch.get("when");
            if (whenObj == null) {
                branchInfo.when = null;
            } else if (whenObj instanceof String) {
                branchInfo.when = new ExpWhen((String)whenObj);
            } else if (whenObj instanceof Map) {
                Map map = (Map)whenObj;
                String type = (String)map.get("type");
                String createExp = (String)map.get("createExp");
                if (!"create".equals(type) && createExp == null) throw new IllegalArgumentException("illegal param " + branch);
                if (initContext.isParseEl()) {
                    HashMap<String, Object> context = new HashMap<String, Object>(3);
                    context.put("definition", map);
                    context.put("node", (FlowNode)parent);
                    context.put("flow", initContext.getFlow());
                    context.put("flowParser", initContext.getFlowParser());
                    NodeExecutor executor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, context, false);
                    branchInfo.when = new ExecutorWhen(executor);
                }
            } else {
                if (!(whenObj instanceof NodeExecutor)) throw new IllegalArgumentException("illegal param " + branch);
                branchInfo.when = new ExecutorWhen((NodeExecutor)whenObj);
            }
            branchInfo.to = this.parseToDefinition(branch.get("to"), (FlowNode)parent, initContext);
            branchInfoList.add(branchInfo);
        }
        this.branchInfoList = branchInfoList;
        if (this.defaultBranch == null) return;
        this.defaultBranch = this.parseToDefinition(this.defaultBranch, (FlowNode)parent, initContext);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(Object defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public List<Map<String, Object>> getBranchList() {
        return this.branchList;
    }

    public void setBranchList(List<Map<String, Object>> branchList) {
        this.branchList = branchList;
    }

    private static class ExecutorWhen
    implements When {
        NodeExecutor<Boolean> executor;

        ExecutorWhen(NodeExecutor<Boolean> executor) {
            this.executor = executor;
        }

        @Override
        public boolean execute(NodeContext nodeContext, FlowContext context) {
            return this.executor.execute(nodeContext, context);
        }
    }

    private static class ExpWhen
    implements When {
        String exp;

        ExpWhen(String exp) {
            this.exp = exp;
        }

        @Override
        public boolean execute(NodeContext nodeContext, FlowContext context) {
            return (Boolean)context.getElEvaluator().eval(this.exp, nodeContext, context, null);
        }
    }

    private static interface When {
        public boolean execute(NodeContext var1, FlowContext var2);
    }

    private static class Branch {
        private When when;
        private Object to;

        private Branch() {
        }
    }
}

