/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.post;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.event.FlowEventListener;
import com.jd.easyflow.flow.engine.event.impl.EventFlowListener;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodePostHandler;
import com.jd.easyflow.flow.model.parser.param.PostParseParam;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPostHandler
implements NodePostHandler {
    private static final Logger logger = LoggerFactory.getLogger(EventPostHandler.class);
    private boolean autoAddEventFlowListener = true;

    public EventPostHandler() {
    }

    public EventPostHandler(boolean autoAddEventFlowListener) {
        this.autoAddEventFlowListener = autoAddEventFlowListener;
    }

    @Override
    public void init(InitContext initContext, Object flowNode) {
        this.initEventPostHandlerMap(initContext, (FlowNode)flowNode);
        if (this.autoAddEventFlowListener) {
            List<FlowEventListener> listeners = initContext.getFlow().getEventTrigger().getListenerList();
            boolean exists = false;
            if (listeners != null) {
                for (FlowEventListener listener : listeners) {
                    if (!(listener instanceof EventFlowListener)) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                logger.info("Auto add EventFlowListener");
                initContext.getFlow().getEventTrigger().addListener(new EventFlowListener());
            }
        }
    }

    @Override
    public NodeContext[] postHandle(NodeContext nodeContext, FlowContext context) {
        Map eventPostHandlerMap;
        NodePostHandler postHandler;
        String event = (String)nodeContext.get("_EVENT");
        if (context.isLogOn() && logger.isInfoEnabled()) {
            logger.info("Event:" + event);
        }
        if (event == null) {
            event = "NONE";
        }
        if ((postHandler = (NodePostHandler)(eventPostHandlerMap = (Map)context.getFlow().getNode(nodeContext.getNodeId()).getProperty("_$eventPostHandlerMap")).get(event)) == null) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Event post handler is null");
            }
            return null;
        }
        return postHandler.postHandle(nodeContext, context);
    }

    private void initEventPostHandlerMap(InitContext initContext, FlowNode flowNode) {
        ConcurrentHashMap<String, NodePostHandler> eventPostHandlerMap = (ConcurrentHashMap<String, NodePostHandler>)flowNode.getProperty("_$eventPostHandlerMap");
        if (eventPostHandlerMap != null) {
            return;
        }
        eventPostHandlerMap = new ConcurrentHashMap<String, NodePostHandler>();
        flowNode.setProperty("_$eventPostHandlerMap", eventPostHandlerMap);
        Map map = (Map)flowNode.getProperty("events");
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            NodePostHandler nodePostHandler;
            String event = (String)entry.getKey();
            Object eventConf = entry.getValue();
            Map eventPostHandlerConfMap = null;
            if (eventConf instanceof Map) {
                Map eventConfMap = (Map)eventConf;
                eventPostHandlerConfMap = (Map)eventConfMap.get("post");
            }
            if (eventPostHandlerConfMap == null || (nodePostHandler = initContext.getFlowParser().parseNodePostHandler(new PostParseParam(eventPostHandlerConfMap, initContext.getFlowList(), initContext.isParseEl(), initContext.getFlow(), flowNode))) == null) continue;
            nodePostHandler.init(initContext, flowNode);
            eventPostHandlerMap.put(event, nodePostHandler);
        }
    }

    public boolean isAutoAddEventFlowListener() {
        return this.autoAddEventFlowListener;
    }

    public void setAutoAddEventFlowListener(boolean autoAddEventFlowListener) {
        this.autoAddEventFlowListener = autoAddEventFlowListener;
    }
}

