/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.pre;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.filter.Filter;
import com.jd.easyflow.flow.filter.FilterChain;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeContextAccessor;
import com.jd.easyflow.flow.model.NodePreHandler;
import com.jd.easyflow.flow.model.filter.impl.BaseNodeFilter;
import com.jd.easyflow.flow.model.pre.NodePreHandlerHelper;
import com.jd.easyflow.flow.model.pre.NodePrePropertyGetter;
import com.jd.easyflow.flow.util.FlowNodeLinkUtil;
import com.jd.easyflow.flow.util.LockUtil;
import com.jd.easyflow.flow.util.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InclusiveCheckPreHandler
implements NodePreHandler,
NodePrePropertyGetter {
    private static final Logger logger = LoggerFactory.getLogger(InclusiveCheckPreHandler.class);
    private static final String CTX_INCLUSIVE_LOCK = "_inclusive_lock";
    private List<String> preNodes;

    public InclusiveCheckPreHandler() {
    }

    public InclusiveCheckPreHandler(List<String> preNodes) {
        this.preNodes = preNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean preHandle(NodeContext nodeContext, FlowContext context) {
        Object lockObj;
        Boolean checkResult = (Boolean)nodeContext.get("_preResult");
        if (checkResult != null) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Pre result checked:" + checkResult);
            }
            return checkResult;
        }
        NodeContext previousNode = nodeContext.getPreviousNode();
        if (previousNode == null) {
            return false;
        }
        String previousNodeId = previousNode.getNodeId();
        boolean result = false;
        HashMap<String, WaitingNodeInfo> map = null;
        WaitingNodeInfo waitingNodeInfo = null;
        Object object = lockObj = LockUtil.getFlowContextLock(CTX_INCLUSIVE_LOCK, context);
        synchronized (object) {
            map = (HashMap<String, WaitingNodeInfo>)context.get("_WAITING_NODE_MAP");
            if (map == null) {
                map = new HashMap<String, WaitingNodeInfo>();
                context.put("_WAITING_NODE_MAP", map);
            }
            if ((waitingNodeInfo = (WaitingNodeInfo)map.get(nodeContext.getNodeId())) == null) {
                List configPreNodes;
                waitingNodeInfo = new WaitingNodeInfo();
                waitingNodeInfo.waitNodeId = nodeContext.getNodeId();
                waitingNodeInfo.unknownPreNodes = new HashSet<String>();
                waitingNodeInfo.finishedPreNodes = new HashSet<String>();
                waitingNodeInfo.unreachablePreNodes = new HashSet<String>();
                waitingNodeInfo.previousNodes = new ArrayList<NodeContext>();
                FlowNode currentNode = context.getFlow().getNode(nodeContext.getNodeId());
                List preNodeList = this.getPreNodes(nodeContext, context);
                List list = configPreNodes = preNodeList != null ? preNodeList : (List)currentNode.getProperty("preNodes");
                if (!configPreNodes.contains(previousNodeId)) {
                    if (context.isLogOn() && logger.isDebugEnabled()) {
                        logger.info("Node:" + previousNodeId + " not in check list");
                    }
                    return false;
                }
                for (String preNode : configPreNodes) {
                    if (FlowNodeLinkUtil.isReachable(preNode, nodeContext.getNodeId(), context.getFlow())) {
                        waitingNodeInfo.unknownPreNodes.add(preNode);
                        continue;
                    }
                    waitingNodeInfo.unreachablePreNodes.add(preNode);
                }
                map.put(nodeContext.getNodeId(), waitingNodeInfo);
            }
            waitingNodeInfo.previousNodes.add(previousNode);
            waitingNodeInfo.finishedPreNodes.add(previousNodeId);
            waitingNodeInfo.unknownPreNodes.remove(previousNodeId);
            if (waitingNodeInfo.unknownPreNodes.size() == 0) {
                result = true;
            } else {
                InclusiveCheckHelper.judgeOneWaitingNode(waitingNodeInfo, context);
                if (waitingNodeInfo.unknownPreNodes.size() == 0) {
                    result = true;
                } else {
                    if (context.isLogOn() && logger.isDebugEnabled()) {
                        logger.debug("Finish nodes:" + waitingNodeInfo.finishedPreNodes + " Unreachable nodes:" + waitingNodeInfo.unreachablePreNodes + " Unknown nodes:" + waitingNodeInfo.unknownPreNodes);
                    }
                    return false;
                }
            }
        }
        if (result) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Node:" + nodeContext.getNodeId() + " is activated");
            }
            map.remove(nodeContext.getNodeId());
            nodeContext.put("_previousNodes", waitingNodeInfo.previousNodes);
            NodePreHandlerHelper.setNextNodesOfPreviousNode(waitingNodeInfo.previousNodes, nodeContext);
        }
        return result;
    }

    @Override
    public List<String> getPreNodes() {
        return this.preNodes;
    }

    public void setPreNodes(List<String> preNodes) {
        this.preNodes = preNodes;
    }

    @Override
    public String getCheckType() {
        return "inclusiveCheck";
    }

    @Override
    public List<String> getPreNodes(NodeContext nodeContext, FlowContext flowContext) {
        return this.preNodes;
    }

    @Override
    public void init(InitContext initContext, Object parent) {
        boolean recordHistory;
        boolean bl = recordHistory = !Boolean.FALSE.equals(initContext.getFlow().getProperty("flow.recordHistory"));
        if (!recordHistory) {
            throw new FlowException("InclusiveCheck must record history");
        }
        Flow flow = initContext.getFlow();
        List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> filters = flow.getFilterManager().getNodeFilters();
        boolean contains = false;
        if (filters == null) {
            filters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
            initContext.getFlow().getFilterManager().setNodeFilters(filters);
        }
        for (Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> filter : filters) {
            if (!(filter instanceof InclusiveCheckWaitNodeProcessFilter)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            filters.add(0, new InclusiveCheckWaitNodeProcessFilter(0x7FFFFFFE));
            initContext.getFlow().getFilterManager().setNodeFilters(filters);
        }
    }

    private static class WaitingNodeInfo {
        String waitNodeId;
        Set<String> finishedPreNodes;
        Set<String> unreachablePreNodes;
        Set<String> unknownPreNodes;
        List<NodeContext> previousNodes;

        private WaitingNodeInfo() {
        }
    }

    private static class InclusiveCheckHelper {
        static final String CTX_WAITING_NODE_MAP = "_WAITING_NODE_MAP";
        static final String CTX_RUNNING_NODES = "_RUNNING_NODES";
        private static final List<String> EMPTY_LIST = new ArrayList<String>();

        private InclusiveCheckHelper() {
        }

        static void judgeOneWaitingNode(WaitingNodeInfo info, FlowContext context) {
            Set<NodeContext> runningNodes = InclusiveCheckHelper.refreshRunningNodes(context);
            Map map = (Map)context.get(CTX_WAITING_NODE_MAP);
            Iterator<String> iterator = info.unknownPreNodes.iterator();
            while (iterator.hasNext()) {
                String unknownPreNode = iterator.next();
                boolean reachable = false;
                for (NodeContext nodeContext : runningNodes) {
                    if (nodeContext.getNodeId().equals(unknownPreNode)) {
                        reachable = true;
                        break;
                    }
                    if (nodeContext.getNodeId().equals(info.waitNodeId)) {
                        if (nodeContext.getPreviousNode() == null || !nodeContext.getPreviousNode().getNodeId().equals(unknownPreNode)) continue;
                        reachable = true;
                        break;
                    }
                    if (!FlowNodeLinkUtil.isReachable(nodeContext.getNodeId(), unknownPreNode, context.getFlow())) continue;
                    reachable = true;
                    break;
                }
                if (!reachable) {
                    for (String key : map.keySet()) {
                        if (key.equals(info.waitNodeId)) continue;
                        if (key.equals(unknownPreNode)) {
                            reachable = true;
                            break;
                        }
                        if (!FlowNodeLinkUtil.isReachable(key, unknownPreNode, context.getFlow())) continue;
                        reachable = true;
                        break;
                    }
                }
                if (reachable) continue;
                info.unreachablePreNodes.add(unknownPreNode);
                iterator.remove();
            }
        }

        private static Set<NodeContext> refreshRunningNodes(FlowContext context) {
            HashSet<NodeContext> runningNodes = (HashSet<NodeContext>)context.get(CTX_RUNNING_NODES);
            if (runningNodes == null) {
                runningNodes = new HashSet<NodeContext>();
                runningNodes.addAll(context.getStartNodes());
                context.put(CTX_RUNNING_NODES, runningNodes);
            }
            ArrayList<NodeContext> addList = null;
            ArrayList<NodeContext> removeList = null;
            for (NodeContext node : runningNodes) {
                if (!Boolean.TRUE.equals(node.get(InclusiveCheckWaitNodeProcessFilter.class.getName()))) continue;
                if (node.getNextNodes() != null) {
                    for (NodeContext nctx : node.getNextNodes()) {
                        if (addList == null) {
                            addList = new ArrayList<NodeContext>();
                        }
                        addList.add(nctx);
                    }
                }
                if (removeList == null) {
                    removeList = new ArrayList<NodeContext>();
                }
                removeList.add(node);
            }
            if (removeList != null) {
                runningNodes.removeAll(removeList);
            }
            if (addList != null) {
                runningNodes.addAll(addList);
            }
            if (addList != null && !addList.isEmpty()) {
                InclusiveCheckHelper.refreshRunningNodes(context);
            }
            return runningNodes;
        }
    }

    public static class InclusiveCheckWaitNodeProcessFilter
    extends BaseNodeFilter {
        private static final Logger logger = LoggerFactory.getLogger(InclusiveCheckWaitNodeProcessFilter.class);

        public InclusiveCheckWaitNodeProcessFilter(int order) {
            this.order = order;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NodeContext doFilter(Triple<FlowNode, NodeContext, FlowContext> request, FilterChain<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> chain) {
            Object lockObj;
            chain.doFilter(request);
            NodeContext nodeContext = request.getMiddle();
            FlowContext flowContext = request.getRight();
            Object object = lockObj = LockUtil.getFlowContextLock(InclusiveCheckPreHandler.CTX_INCLUSIVE_LOCK, flowContext);
            synchronized (object) {
                nodeContext.put(InclusiveCheckWaitNodeProcessFilter.class.getName(), true);
                Map map = (Map)flowContext.get("_WAITING_NODE_MAP");
                if (map != null && !map.isEmpty()) {
                    ArrayList<NodeContext> additionalNextNodes = null;
                    for (WaitingNodeInfo info : map.values()) {
                        if (info.waitNodeId.equals(nodeContext.getNodeId())) continue;
                        InclusiveCheckHelper.judgeOneWaitingNode(info, flowContext);
                        if (!info.unknownPreNodes.isEmpty()) continue;
                        if (flowContext.isLogOn() && logger.isInfoEnabled()) {
                            logger.info("Node:" + info.waitNodeId + " is activated in filter");
                        }
                        if (additionalNextNodes == null) {
                            additionalNextNodes = new ArrayList<NodeContext>();
                            if (nodeContext.getNextNodes() != null) {
                                for (NodeContext nc : nodeContext.getNextNodes()) {
                                    additionalNextNodes.add(nc);
                                }
                            }
                        }
                        NodeContext additionNode = new NodeContext(info.waitNodeId);
                        additionalNextNodes.add(additionNode);
                    }
                    if (additionalNextNodes != null) {
                        NodeContextAccessor.setNextNodes(nodeContext, additionalNextNodes.toArray(new NodeContext[additionalNextNodes.size()]));
                    }
                }
            }
            return nodeContext;
        }
    }
}

