/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.pre;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodePreHandler;
import com.jd.easyflow.flow.model.pre.NodePreHandlerHelper;
import com.jd.easyflow.flow.model.pre.NodePrePropertyGetter;
import com.jd.easyflow.flow.util.LockUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiCheckPreHandler
implements NodePreHandler,
NodePrePropertyGetter {
    private static final Logger logger = LoggerFactory.getLogger(MultiCheckPreHandler.class);
    private List<String> preNodes;

    public MultiCheckPreHandler() {
    }

    public MultiCheckPreHandler(List<String> preNodes) {
        this.preNodes = preNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean preHandle(NodeContext nodeContext, FlowContext context) {
        Object lockObj;
        Boolean checkResult = (Boolean)nodeContext.get("_preResult");
        if (checkResult != null) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Pre result checked:" + checkResult);
            }
            return checkResult;
        }
        boolean result = false;
        ArrayList<NodeContext> previousNodes = null;
        Object object = lockObj = LockUtil.getFlowContextLock("_node_lock_" + nodeContext.getNodeId(), context);
        synchronized (object) {
            List configPreNodes;
            ArrayList<String> preNodes = (ArrayList<String>)context.get("_pre_nodes_" + nodeContext.getNodeId());
            previousNodes = (ArrayList<NodeContext>)context.get("_previousNodes_" + nodeContext.getNodeId());
            if (preNodes == null) {
                preNodes = new ArrayList<String>();
                context.put("_pre_nodes_" + nodeContext.getNodeId(), preNodes);
                previousNodes = new ArrayList<NodeContext>();
                context.put("_previousNodes_" + nodeContext.getNodeId(), previousNodes);
            }
            preNodes.add(nodeContext.getPreviousNode().getNodeId());
            previousNodes.add(nodeContext.getPreviousNode());
            FlowNode currentNode = context.getFlow().getNode(nodeContext.getNodeId());
            List preNodeList = this.getPreNodes(nodeContext, context);
            List list = configPreNodes = preNodeList != null ? preNodeList : (List)currentNode.getProperty("preNodes");
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Pre nodes executed:" + preNodes);
            }
            if (preNodes.size() < configPreNodes.size()) {
                return false;
            }
            for (String s : configPreNodes) {
                if (preNodes.contains(s)) continue;
                return false;
            }
            result = true;
        }
        if (result) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("All pre nodes finished");
            }
            context.remove("_pre_nodes_" + nodeContext.getNodeId());
            context.remove("_previousNodes_" + nodeContext.getNodeId());
            nodeContext.put("_previousNodes", previousNodes);
            NodePreHandlerHelper.setNextNodesOfPreviousNode(previousNodes, nodeContext);
        }
        return result;
    }

    @Override
    public List<String> getPreNodes() {
        return this.preNodes;
    }

    public void setPreNodes(List<String> preNodes) {
        this.preNodes = preNodes;
    }

    @Override
    public String getCheckType() {
        return "multiCheck";
    }

    @Override
    public List<String> getPreNodes(NodeContext nodeContext, FlowContext flowContext) {
        return this.preNodes;
    }
}

