/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.util;

import com.jd.easyflow.flow.util.FlowStringUtil;
import com.jd.easyflow.flow.util.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPrettyHelper {
    public static final Logger logger = LoggerFactory.getLogger(JsonPrettyHelper.class);
    private static final int INDENT = 2;
    private static final String KEY_TYPE = "keyType";

    public static String pretty(String valueStr, String prettyConfStr) {
        Object value = JsonUtil.parseObject(valueStr, Object.class);
        Map prettyConf = JsonUtil.parseObject(prettyConfStr, Map.class);
        StringBuilder builder = new StringBuilder();
        JsonPrettyHelper.pretty(value, prettyConf, (Map)prettyConf.get("default"), builder, 0);
        return builder.toString();
    }

    public static String pretty(Object value, Map<String, Object> prettyConf) {
        StringBuilder builder = new StringBuilder();
        JsonPrettyHelper.pretty(value, prettyConf, (Map)prettyConf.get("default"), builder, 0);
        return builder.toString();
    }

    private static void pretty(Object value, Map<String, Object> prettyConf, Map<String, Object> defaultConf, StringBuilder builder, int indent) {
        if (value == null) {
            builder.append("null");
        } else if (value instanceof String) {
            builder.append(JsonPrettyHelper.quote((String)value));
        } else if (value instanceof Number || value instanceof Boolean) {
            builder.append(value);
        } else if (value instanceof Map) {
            JsonPrettyHelper.prettyMap((Map)value, prettyConf, defaultConf, builder, indent);
        } else if (value instanceof List) {
            JsonPrettyHelper.prettyList((List)value, prettyConf, defaultConf, builder, indent);
        } else {
            throw new UnsupportedOperationException("Unsupported type:" + value.getClass());
        }
    }

    public static void prettyMap(Map<String, Object> value, Map<String, Object> prettyConf, Map<String, Object> defaultConf, StringBuilder builder, int indent) {
        if (prettyConf == null) {
            prettyConf = new HashMap<String, Object>();
        }
        builder.append("{");
        indent += 2;
        ArrayList<String> processedKey = new ArrayList<String>();
        ArrayList subList = (ArrayList)prettyConf.get("subList");
        if (subList == null) {
            subList = new ArrayList();
        }
        if (!subList.stream().anyMatch(map -> "OTHER".equals(map.get(KEY_TYPE)))) {
            HashMap<String, String> otherConf = new HashMap<String, String>();
            otherConf.put(KEY_TYPE, "OTHER");
            subList.add(otherConf);
        }
        boolean hasElements = false;
        for (Map map2 : subList) {
            Map subDefaultConf = (Map)map2.get("default");
            subDefaultConf = subDefaultConf == null ? defaultConf : subDefaultConf;
            List<String> keys = null;
            String confKey = (String)map2.get("key");
            String keyType = (String)map2.get(KEY_TYPE);
            if (FlowStringUtil.isNotEmpty(confKey)) {
                keys = Arrays.asList(confKey);
            } else if ("OTHER".equals(keyType)) {
                keys = JsonPrettyHelper.subtract(new ArrayList<String>(value.keySet()), processedKey);
            } else {
                if (map2.containsKey("subList")) continue;
                throw new IllegalArgumentException("Config error," + map2);
            }
            if (keys.size() <= 0) continue;
            for (String key : keys) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Start pretty element:" + key);
                }
                if (!value.containsKey(key)) continue;
                boolean subNewLine = Boolean.TRUE.equals(JsonPrettyHelper.getConf(map2, subDefaultConf, "newLine"));
                if (subNewLine) {
                    builder.append(JsonPrettyHelper.newLine(indent));
                }
                processedKey.add(key);
                builder.append(JsonPrettyHelper.quoteColon(key));
                JsonPrettyHelper.pretty(value.get(key), map2, subDefaultConf, builder, indent);
                builder.append(",");
                hasElements = true;
            }
        }
        if (hasElements) {
            builder.deleteCharAt(builder.length() - 1);
        }
        indent -= 2;
        boolean endNewLine = Boolean.TRUE.equals(JsonPrettyHelper.getConf(prettyConf, defaultConf, "endNewLine"));
        if (endNewLine) {
            builder.append(JsonPrettyHelper.newLine(indent));
        }
        builder.append("}");
    }

    private static List<String> subtract(List<String> list1, List<String> list2) {
        ArrayList<String> result = new ArrayList<String>();
        if (list1 == null) {
            return result;
        }
        for (String s : list1) {
            if (list2.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static void prettyList(List<Object> value, Map<String, Object> prettyConf, Map<String, Object> defaultConf, StringBuilder builder, int indent) {
        ArrayList subConfList;
        if (prettyConf == null) {
            prettyConf = new HashMap<String, Object>();
        }
        if ((subConfList = (ArrayList)prettyConf.get("subList")) == null) {
            subConfList = new ArrayList();
            HashMap arrayConf = new HashMap();
            subConfList.add(arrayConf);
        }
        builder.append("[");
        indent += 2;
        Map subConf = (Map)subConfList.get(0);
        Map subDefaultConf = (Map)subConf.get("default");
        Map map = subDefaultConf = subDefaultConf == null ? defaultConf : subDefaultConf;
        if (value.size() > 0) {
            for (Object o : value) {
                boolean subNewLine = Boolean.TRUE.equals(JsonPrettyHelper.getConf(subConf, subDefaultConf, "newLine"));
                if (subNewLine) {
                    builder.append(JsonPrettyHelper.newLine(indent));
                }
                JsonPrettyHelper.pretty(o, subConf, subDefaultConf, builder, indent);
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        indent -= 2;
        boolean endNewLine = Boolean.TRUE.equals(JsonPrettyHelper.getConf(prettyConf, defaultConf, "endNewLine"));
        if (endNewLine) {
            builder.append(JsonPrettyHelper.newLine(indent));
        }
        builder.append("]");
    }

    private static <T> T getConf(Map<String, Object> confMap, Map<String, Object> defaultConf, String key) {
        Object value = confMap.get(key);
        if (value != null) {
            return (T)value;
        }
        if (defaultConf != null) {
            value = defaultConf.get(key);
        }
        return (T)value;
    }

    private static String newLine(int indent) {
        return "\n" + FlowStringUtil.repeat(' ', indent);
    }

    private static String blank(int num) {
        return FlowStringUtil.repeat(' ', num);
    }

    private static String quote(String str) {
        return JsonUtil.toJsonString(str);
    }

    private static String quoteColon(String s) {
        return JsonPrettyHelper.quote(s) + ":";
    }

    private static String indent(String s, int indent) {
        String[] lines = s.split("\n");
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(FlowStringUtil.repeat(' ', indent) + line);
        }
        return builder.toString();
    }

    private static String indent(String[] lines, int indent) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(FlowStringUtil.repeat(' ', indent) + line);
        }
        return builder.toString();
    }
}

