/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webapi.sdk;

import com.kingdee.bos.webapi.sdk.AppCfg;
import com.kingdee.bos.webapi.sdk.CfgUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;

public class HttpUtils {
    static int proxyRunning = -1;

    static Proxy getProxy() {
        AppCfg cfg = CfgUtil.getAppDefaultCfg();
        if (cfg != null && cfg.getProxy() != null) {
            try {
                URL url = new URL(cfg.getProxy());
                if (HttpUtils.isHostConnectable(url.getHost(), url.getPort())) {
                    System.out.println(String.format("Used proxy,Host:%s,port:%s", url.getHost(), url.getPort()));
                    return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), url.getPort()));
                }
                System.out.println(String.format("is not host %s", url.toString()));
                return null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    static boolean proxyIsRunning() {
        if (proxyRunning > -1) {
            return proxyRunning != 0;
        }
        if (HttpUtils.isHostConnectable("127.0.0.1", 8888)) {
            proxyRunning = 1;
            return true;
        }
        proxyRunning = 0;
        return false;
    }

    static boolean isHostConnectable(String host, int port) {
        Socket socket = new Socket();
        try {
            try {
                socket.connect(new InetSocketAddress(host, port));
            }
            catch (IOException e) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

