/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webapi.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.webapi.sdk.ApiQueryRequester;
import com.kingdee.bos.webapi.sdk.ApiRequester;
import com.kingdee.bos.webapi.sdk.AppCfg;
import com.kingdee.bos.webapi.sdk.CfgUtil;
import com.kingdee.bos.webapi.sdk.IdentifyInfo;
import com.kingdee.bos.webapi.sdk.InvokeMode;
import com.kingdee.bos.webapi.sdk.K3CloudCookieStore;
import com.kingdee.bos.webapi.sdk.KDException;
import com.kingdee.bos.webapi.sdk.QueryRequestBodyObject;
import com.kingdee.bos.webapi.sdk.QueryResultInfo;
import com.kingdee.bos.webapi.sdk.QueryTaskParam;
import com.kingdee.bos.webapi.sdk.RepoRet;
import com.kingdee.bos.webapi.sdk.RequestBodyObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WebApiClient {
    protected IdentifyInfo identify;
    K3CloudCookieStore cookier;
    int connectTimeout = 120;
    int requestTimeout = 120;
    int stockTimeout = 180;

    public WebApiClient() {
        this("");
    }

    public WebApiClient(String serverUrl) {
        this(new IdentifyInfo().setServerUrl(serverUrl));
    }

    public WebApiClient(String serverUrl, int timeout) {
        this(new IdentifyInfo().setServerUrl(serverUrl));
        this.requestTimeout = timeout;
    }

    public WebApiClient(IdentifyInfo identify) {
        if (identify.appId != null && identify.appId.length() > 0 && identify.appSecret != null && identify.appSecret.length() > 0) {
            this.identify = identify;
        } else {
            this.identify = new IdentifyInfo();
            AppCfg cfg = CfgUtil.getAppDefaultCfg();
            if (cfg != null) {
                this.identify.setAppId(cfg.getAppId());
                this.identify.setAppSecret(cfg.getAppSecret());
                this.identify.setdCID(cfg.getdCID());
                this.identify.setLcid(cfg.getlCID());
                this.identify.setOrgNum(cfg.getOrgNum());
                this.identify.setUserName(cfg.getUserName());
                if (this.identify.getServerUrl() == null || this.identify.getServerUrl().length() == 0) {
                    this.identify.setServerUrl(cfg.getServerUrl());
                    if (this.identify.getServerUrl() == null || this.identify.getServerUrl().length() == 0) {
                        this.identify.setServerUrl("https://api.kingdee.com/galaxyapi/");
                    }
                }
                if (cfg.getConnectTimeout() > 0) {
                    this.connectTimeout = cfg.getConnectTimeout();
                }
                if (cfg.getRequestTimeout() > 0) {
                    this.requestTimeout = cfg.getRequestTimeout();
                }
                if (cfg.getStockTimeout() > 0) {
                    this.stockTimeout = cfg.getStockTimeout();
                }
            }
        }
    }

    protected void onPreExecute(String serviceMethod) {
    }

    protected void preExecute() {
        if (this.cookier == null) {
            this.cookier = new K3CloudCookieStore();
        }
    }

    protected void afterExecute(String json, K3CloudCookieStore cookier) {
        if (cookier != null) {
            this.cookier = cookier;
        }
    }

    Gson builderGson() {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
        return builder.create();
    }

    RequestBodyObject genrateBody(Object[] parameters, InvokeMode type) {
        RequestBodyObject json = null;
        json = type == InvokeMode.Query ? new QueryRequestBodyObject(parameters) : new RequestBodyObject(parameters);
        return json;
    }

    public String execute(String serviceName, Object[] parameters) {
        try {
            String json = this.executeJson(serviceName, parameters, InvokeMode.Syn);
            if (json.startsWith("response_error:")) {
                KDException ex = KDException.parse(json);
                if (ex == null) {
                    throw new Exception(json);
                }
                throw new Exception(ex.getMessage());
            }
            return json;
        }
        catch (Exception e) {
            e.getStackTrace();
            return "User authentication information is wrong, please check again!";
        }
    }

    public <T> List<T> execute(String serviceName, Object[] parameters, Type type) {
        try {
            String json = this.executeJson(serviceName, parameters, InvokeMode.Syn);
            Gson gson = this.builderGson();
            return (List)gson.fromJson(json, type);
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public <T> T execute(String serviceName, Object[] parameters, Class<T> cls) {
        try {
            String json = this.executeJson(serviceName, parameters, InvokeMode.Syn);
            if (json.startsWith("response_error:")) {
                KDException ex = KDException.parse(json);
                if (ex == null) {
                    throw new Exception(json);
                }
                throw new Exception(ex.getMessage());
            }
            Gson gson = new Gson();
            return (T)gson.fromJson(json, cls);
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    String executeByQuery(String serviceName, Object[] parameters) throws Exception {
        try {
            String json = this.doExecuteJson(serviceName, parameters, InvokeMode.Query);
            if (json.startsWith("response_error:")) {
                KDException ex = KDException.parse(json);
                if (ex == null) {
                    throw new Exception(json);
                }
                throw new Exception(ex.getMessage());
            }
            Gson gson = new Gson();
            QueryResultInfo taskInfo = (QueryResultInfo)gson.fromJson(json, QueryResultInfo.class);
            if (taskInfo.getStatus() == 2) {
                return gson.toJson(taskInfo.getResult());
            }
            return gson.toJson(this.queryTaskResult(serviceName, new QueryTaskParam(taskInfo.getTaskId(), false), 5));
        }
        catch (Exception e) {
            e.getStackTrace();
            throw e;
        }
    }

    Object queryTaskResult(String serviceName, QueryTaskParam param, int failTime) throws Exception {
        try {
            Thread.sleep(1000L);
            int index = serviceName.lastIndexOf(".");
            String qService = String.valueOf(serviceName.substring(0, index)) + "." + "QueryAsyncResult";
            String json = this.doExecuteJson(qService, new Object[]{param}, InvokeMode.Syn);
            if (json.startsWith("response_error:")) {
                if (failTime > 0) {
                    return this.queryTaskResult(serviceName, param, failTime - 1);
                }
                KDException ex = KDException.parse(json);
                if (ex == null) {
                    throw new Exception(json);
                }
                throw new Exception(ex.getMessage());
            }
            Gson gson = new Gson();
            QueryResultInfo taskInfo = (QueryResultInfo)gson.fromJson(json, QueryResultInfo.class);
            if (taskInfo.getStatus() == 2) {
                return taskInfo.getResult();
            }
            return this.queryTaskResult(serviceName, param, 5);
        }
        catch (Exception e) {
            if (failTime > 0) {
                return this.queryTaskResult(serviceName, param, failTime - 1);
            }
            throw e;
        }
    }

    String executeJson(String serviceName, Object[] parameters, InvokeMode type) throws Exception {
        if (type == InvokeMode.Query) {
            return this.executeByQuery(serviceName, parameters);
        }
        if (type == InvokeMode.Syn) {
            return this.doExecuteJson(serviceName, parameters, type);
        }
        throw new Exception("Not suppoer yet,for InvokeMode:" + type.toString());
    }

    String doExecuteJson(String serviceName, Object[] parameters, InvokeMode type) throws Exception {
        this.preExecute();
        this.onPreExecute(serviceName);
        String url = this.identify.getServerUrl();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + serviceName + ".common.kdsvc";
        ApiRequester req = null;
        req = type == InvokeMode.Query ? new ApiQueryRequester(url) : new ApiRequester(url);
        req.setConnectTimeout(this.connectTimeout);
        req.setConnectionRequrestTimeout(this.requestTimeout);
        req.setSocketTimeout(this.stockTimeout);
        req.setIdentify(this.identify);
        req.setCookieStore(this.cookier);
        try {
            String json = req.postJson(this.genrateBody(parameters, type));
            this.afterExecute(json, req.getCookieStore());
            return json;
        }
        catch (Exception e) {
            this.afterExecute(null, req.getCookieStore());
            e.getStackTrace();
            throw e;
        }
    }

    protected <T> List<T> loadDataList(String fieldKeys, Class type, String json) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList rets = new ArrayList();
        Gson gson = new Gson();
        List rows = (List)gson.fromJson(json, rets.getClass());
        Method[] pes = type.getMethods();
        String[] fields = fieldKeys.split(",");
        Method[] setPes = this.getMethodsByFields(pes, "set", fields);
        Method[] getPes = this.getMethodsByFields(pes, "get", fields);
        for (List darray : rows) {
            Object ret = type.newInstance();
            int i = 0;
            while (i < fields.length) {
                Object v;
                if (setPes[i] != null && getPes[i] != null && (v = this.convertToDest(getPes[i].getReturnType(), darray.get(i))) != null) {
                    setPes[i].invoke(ret, v);
                }
                ++i;
            }
            rets.add(ret);
        }
        return rets;
    }

    String loadErrorMsg(String json) {
        if (json.startsWith("[[") && json.endsWith("]]")) {
            Gson gson = new Gson();
            return ((RepoRet)gson.fromJson(json.substring(2, json.length() - 2), RepoRet.class)).getResult().getResponseStatus().getErrors().get(0).getMessage();
        }
        return String.format("fail for ExecuteBillQuery:%s", json);
    }

    Method[] getMethodsByFields(Method[] pes, String pre, String[] fields) {
        Method[] rets = new Method[fields.length];
        int i = 0;
        while (i < fields.length) {
            int j = 0;
            while (j < pes.length) {
                if (pes[j].getName().toLowerCase().equals(String.valueOf(pre) + fields[i].toLowerCase())) {
                    rets[i] = pes[j];
                }
                ++j;
            }
            ++i;
        }
        return rets;
    }

    Method getMethodFromT(Method[] pes, String pname) {
        int i = 0;
        while (i < pes.length) {
            if (pes[i].getName().toLowerCase().equals(pname.toLowerCase())) {
                return pes[i];
            }
            ++i;
        }
        return null;
    }

    Object convertToDest(Type type, Object val) {
        if (val == null) {
            return null;
        }
        if (type.getTypeName().equals(String.class.getTypeName())) {
            return val.toString();
        }
        if (type.getTypeName().equals(Integer.TYPE.getTypeName()) || type.getTypeName().equals(Short.TYPE.getTypeName()) || type.getTypeName().equals(Long.TYPE.getTypeName())) {
            String v = val.toString();
            if (v.toString().indexOf(".") > -1) {
                v = v.substring(0, v.toString().indexOf("."));
            }
            return new Integer(v.toString());
        }
        if (type.getTypeName().equals(BigDecimal.class.getTypeName())) {
            return new BigDecimal(val.toString());
        }
        if (type.getTypeName().equals(Date.class.getTypeName())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            try {
                return sdf.parse(val.toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return val;
    }
}

