/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.app.common.utils;

import com.lmaye.app.common.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class IDCardUtils {
    public static final String BIRTH_DATE_FORMAT = "yyyyMMdd";
    public static final Date MINIMAL_BIRTH_DATE = new Date(-2209017600000L);
    public static final int NEW_CARD_NUMBER_LENGTH = 18;
    public static final int OLD_CARD_NUMBER_LENGTH = 15;
    public static final char[] VERIFY_CODE = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    public static final int[] VERIFY_CODE_WEIGHT = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static boolean validate(String cardNumber) {
        boolean result = null != cardNumber;
        result = result && 18 == cardNumber.length();
        for (int i = 0; result && i < 17; ++i) {
            char ch = cardNumber.charAt(i);
            result = ch >= '0' && ch <= '9';
        }
        result = result && IDCardUtils.calculateVerifyCode(cardNumber) == cardNumber.charAt(17);
        try {
            Date birthDate = IDCardUtils.getBirthDate(cardNumber);
            result = result && null != birthDate;
            result = result && birthDate.before(new Date());
            boolean bl = result = result && birthDate.after(MINIMAL_BIRTH_DATE);
            assert (cardNumber != null);
            String birthdayPart = IDCardUtils.getBirthDayPart(cardNumber);
            String realBirthdayPart = IDCardUtils.createBirthDateParser().format(birthDate);
            result = result && birthdayPart.equals(realBirthdayPart);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static String getAddressCode(String cardNumber) {
        if (!IDCardUtils.validate(cardNumber)) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u6b63\u786e\uff01");
        }
        return cardNumber.substring(0, 6);
    }

    public static Date getBirthDate(String cardNumber) {
        try {
            return IDCardUtils.createBirthDateParser().parse(IDCardUtils.getBirthDayPart(cardNumber));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u7684\u51fa\u751f\u65e5\u671f\u65e0\u6548");
        }
    }

    public static boolean isMale(String cardNumber) {
        return (IDCardUtils.getGenderCode(cardNumber) & 1) != 0;
    }

    public static boolean isFemale(String cardNumber) {
        return !IDCardUtils.isMale(cardNumber);
    }

    public static int getGenderCode(String cardNumber) {
        if (!IDCardUtils.validate(cardNumber)) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u6b63\u786e\uff01");
        }
        char genderCode = cardNumber.charAt(16);
        return genderCode - 48 & 1;
    }

    public static String getBirthDayPart(String cardNumber) {
        return cardNumber.substring(6, 14);
    }

    public static SimpleDateFormat createBirthDateParser() {
        return new SimpleDateFormat(BIRTH_DATE_FORMAT);
    }

    public static char calculateVerifyCode(CharSequence cardNumber) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            char ch = cardNumber.charAt(i);
            sum += (ch - 48) * VERIFY_CODE_WEIGHT[i];
        }
        return VERIFY_CODE[sum % 11];
    }

    public static String convertToNewCardNumber(String cardNumber) {
        StringBuilder buf = new StringBuilder(18);
        buf.append(cardNumber, 0, 6);
        buf.append("19");
        buf.append(cardNumber.substring(6));
        buf.append(IDCardUtils.calculateVerifyCode(buf));
        return buf.toString();
    }

    public static int getAgeFromBirthTime(Date birthDate) {
        String[] array = DateUtils.format(birthDate, "yyyy-MM-dd").trim().split("-");
        Calendar cal = Calendar.getInstance();
        int yearMinus = cal.get(1) - Integer.parseInt(array[0]);
        int monthMinus = cal.get(2) + 1 - Integer.parseInt(array[1]);
        int dayMinus = cal.get(5) - Integer.parseInt(array[2]);
        int age = yearMinus;
        if (yearMinus <= 0) {
            age = 0;
        } else if (monthMinus == 0) {
            if (dayMinus >= 0) {
                ++age;
            }
        } else if (monthMinus > 0) {
            ++age;
        }
        return age;
    }

    public static int getAgeFromBirthTime(long birthTimeLong) {
        return IDCardUtils.getAgeFromBirthTime(new Date(birthTimeLong * 1000L));
    }

    private IDCardUtils() {
    }
}

