/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.app.common.utils;

import cn.hutool.core.lang.Snowflake;
import com.lmaye.app.common.utils.CoreUtils;
import java.lang.management.ManagementFactory;
import org.apache.commons.lang3.StringUtils;

public class IdUtils {
    private static final Snowflake SNOW_FLAKE;

    public static long nextId() {
        return SNOW_FLAKE.nextId();
    }

    public static String nextStrId() {
        return String.valueOf(SNOW_FLAKE.nextId());
    }

    private static long getWorkerId(long dataCenterId) {
        StringBuilder id = new StringBuilder();
        id.append(dataCenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!StringUtils.isEmpty((CharSequence)name)) {
            id.append(name.split("@")[0]);
        }
        return (id.toString().hashCode() & 0xFFFF) % 32;
    }

    private IdUtils() {
    }

    static {
        long dataCenterId = CoreUtils.getDataCenterId();
        long workerId = IdUtils.getWorkerId(dataCenterId);
        SNOW_FLAKE = new Snowflake(dataCenterId, workerId, true);
    }
}

