/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.app.common.utils;

import cn.hutool.core.lang.Assert;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class StringCoreUtils {
    private static final int INDEX_NOT_FOUND = -1;
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile("[A-Z]");

    public static String generateUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateStr(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String toUnderline(String str) {
        Assert.notEmpty((CharSequence)str, (String)"The transform string cannot be empty", (Object[])new Object[0]);
        Matcher matcher = UPPERCASE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String substr(String str, int length) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length - 3) + "...";
    }

    public static String substr(String str, int start, int end) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.length() <= start + end) {
            return str;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = start; i < str.length() - end; ++i) {
            stringBuilder.append("*");
        }
        return str.substring(0, start) + stringBuilder.toString() + str.substring(str.length() - end);
    }

    public static byte[] bytes(CharSequence str) {
        return StringCoreUtils.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (Objects.isNull(str)) {
            return null;
        }
        if (Objects.isNull(charset)) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String str(byte[] data) {
        if (Objects.isNull(data)) {
            return null;
        }
        return new String(data, Charset.defaultCharset());
    }

    public static String str(byte[] data, Charset charset) {
        if (Objects.isNull(data)) {
            return null;
        }
        if (Objects.isNull(charset)) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringCoreUtils.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringCoreUtils.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (Objects.isNull(str) || Objects.isNull(searchStr)) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringCoreUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (Objects.isNull(str1) || Objects.isNull(str2)) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String repeat(String string, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String hideString(String param, int start, int end) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return param;
        }
        if (param.length() <= start + end) {
            return param;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = start; i < param.length() - end; ++i) {
            stringBuilder.append("*");
        }
        return param.substring(0, start) + stringBuilder.toString() + param.substring(param.length() - end);
    }
}

