/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.core;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.TreeBasedTable;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.common.matrix.CSRSparseMatrix;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.UseLines;
import com.mayabot.nlp.segment.lexer.core.BaseNlpResourceExternalizable;
import com.mayabot.nlp.segment.lexer.core.BiGram;
import com.mayabot.nlp.segment.lexer.core.BiGramTableDictionary;
import com.mayabot.nlp.segment.lexer.core.CoreDictPatch;
import com.mayabot.nlp.segment.lexer.core.CoreDictPathWrap;
import com.mayabot.nlp.segment.lexer.core.CoreDictionaryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

@Singleton
public class BiGramTableDictionaryImpl
extends BaseNlpResourceExternalizable
implements BiGramTableDictionary {
    private final MynlpEnv mynlp;
    private final CoreDictPatch coreDictPatch;
    private CSRSparseMatrix matrix;
    private final String path = "core-dict/CoreDict.bigram.txt";
    protected InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    @Nullable
    private final CoreDictionaryImpl coreDictionary;

    public BiGramTableDictionaryImpl(CoreDictionaryImpl coreDictionary, MynlpEnv mynlp, CoreDictPathWrap coreDictPathWrap) throws Exception {
        super(mynlp);
        this.coreDictionary = coreDictionary;
        this.mynlp = mynlp;
        this.coreDictPatch = coreDictPathWrap.getCoreDictPatch();
        this.restore();
    }

    @Override
    public void refresh() throws Exception {
        this.restore();
    }

    @Override
    public String sourceVersion() {
        Hasher hasher = Hashing.murmur3_32().newHasher().putString((CharSequence)this.mynlp.hashResource("core-dict/CoreDict.bigram.txt"), Charsets.UTF_8).putString((CharSequence)"v2", Charsets.UTF_8);
        if (this.coreDictPatch != null) {
            hasher.putString((CharSequence)this.coreDictPatch.biGramVersion(), Charsets.UTF_8);
        }
        return hasher.hash().toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void loadFromSource() throws Exception {
        source = this.mynlp.loadResource("core-dict/CoreDict.bigram.txt");
        Preconditions.checkNotNull((Object)source);
        table = TreeBasedTable.create();
        splitter = Splitter.on((String)" ").omitEmptyStrings().trimResults();
        firstWord = null;
        count = 0;
        UseLines.forEachLine((InputStream)source.inputStream(), (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$loadFromSource$0(java.lang.String ), (Ljava/lang/String;)V)());
        reader = UseLines.lineReader((InputStream)source.inputStream());
        var7_7 = null;
lbl11:
        // 2 sources

        try {
            while (reader.hasNext()) {
                block17: {
                    line = (String)reader.next();
                    if (!line.startsWith("\t")) break block17;
                    firstWh = line.indexOf(" ");
                    numString = line.substring(1, firstWh);
                    num = Ints.tryParse((String)numString);
                    words = splitter.splitToList((CharSequence)line.substring(firstWh + 1));
                    wordA = firstWord;
                    idA = this.coreDictionary.wordId(wordA);
                    if (idA == -1) continue;
                    for (String wordB : words) {
                        idB = this.coreDictionary.wordId(wordB);
                        if (idB < 0) continue;
                        table.put((Object)idA, (Object)idB, (Object)num);
                        ++count;
                    }
                    ** GOTO lbl11
                }
                firstWord = line;
            }
        }
        catch (Throwable line) {
            var7_7 = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (var7_7 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        var7_7.addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        if (this.coreDictPatch != null && (list = this.coreDictPatch.addBiGram()) != null) {
            for (BiGram item : list) {
                idA = this.coreDictionary.wordId(item.getWordA());
                idB = this.coreDictionary.wordId(item.getWordB());
                if (idA < 0 || idB < 0) continue;
                table.put((Object)idA, (Object)idB, (Object)item.getCount());
                ++count;
            }
        }
        this.logger.info("Core biGram pair size " + count);
        this.matrix = new CSRSparseMatrix(table, this.coreDictionary.size());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.matrix.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.matrix = new CSRSparseMatrix();
        this.matrix.readExternal(in);
    }

    public int getBiFrequency(String a, String b) {
        int idA = this.coreDictionary.getWordID(a);
        if (idA < 0) {
            return 0;
        }
        int idB = this.coreDictionary.getWordID(b);
        if (idB < 0) {
            return 0;
        }
        return this.matrix.get(idA, idB);
    }

    @Override
    public int getBiFrequency(int idA, int idB) {
        return this.matrix.get(idA, idB);
    }

    private static /* synthetic */ void lambda$loadFromSource$0(String line) {
    }
}

