/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.ner;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.common.PerceptronUtilsKt;
import com.mayabot.nlp.segment.common.PkuWord;
import com.mayabot.nlp.segment.plugins.ner.NERPerceptronFeature;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/mayabot/nlp/segment/plugins/ner/NerSamples;", "", "targetPos", "", "", "labelMap", "", "", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "(Ljava/util/Set;Ljava/util/Map;Lcom/mayabot/nlp/perceptron/FeatureSet;)V", "getFeatureSet", "()Lcom/mayabot/nlp/perceptron/FeatureSet;", "getLabelMap", "()Ljava/util/Map;", "getTargetPos", "()Ljava/util/Set;", "prepareSample", "Ljava/util/ArrayList;", "Lcom/mayabot/nlp/perceptron/TrainSample;", "Lkotlin/collections/ArrayList;", "files", "", "Ljava/io/File;", "sentenceToSample", "line", "Lcom/mayabot/nlp/segment/common/PkuWord;", "Companion", "mynlp-segment"})
public final class NerSamples {
    @NotNull
    private final Set<String> targetPos;
    @NotNull
    private final Map<String, Integer> labelMap;
    @NotNull
    private final FeatureSet featureSet;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ArrayList<TrainSample> prepareSample(@NotNull List<? extends File> files) {
        Object object;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        int sampleSize = 0;
        Object $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            File file = (File)element$iv;
            boolean bl = false;
            File $this$useLines$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object2 = $this$useLines$iv;
            int n = 8192;
            boolean bl2 = false;
            object = object2;
            boolean bl3 = false;
            Object object3 = object;
            boolean bl4 = false;
            object3 = new FileInputStream((File)object3);
            bl4 = false;
            object = new InputStreamReader((InputStream)object3, charset$iv);
            bl3 = false;
            object2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object2;
                boolean bl5 = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl6 = false;
                Sequence $this$forEach$iv2 = it;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String line = (String)element$iv2;
                    boolean bl7 = false;
                    CharSequence charSequence = line;
                    boolean bl8 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    int n2 = sampleSize;
                    sampleSize = n2 + 1;
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        $this$forEach$iv = "Sample Size " + sampleSize;
        $i$f$forEach = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Sample List Prepare ... ";
        $i$f$forEach = false;
        System.out.println($this$forEach$iv);
        ArrayList<TrainSample> sampleList = new ArrayList<TrainSample>(sampleSize + 10);
        Iterable $this$forEach$iv3 = files;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            File file = (File)element$iv;
            boolean bl = false;
            File $this$useLines$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object4 = $this$useLines$iv;
            int n = 8192;
            boolean bl9 = false;
            Object bl5 = object4;
            boolean bl10 = false;
            Object object5 = bl5;
            boolean bl11 = false;
            object5 = new FileInputStream((File)object5);
            bl11 = false;
            bl5 = new InputStreamReader((InputStream)object5, charset$iv);
            bl10 = false;
            object4 = bl5 instanceof BufferedReader ? (BufferedReader)bl5 : new BufferedReader((Reader)bl5, n);
            n = 0;
            object = null;
            try {
                BufferedReader it$iv = (BufferedReader)object4;
                boolean bl12 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl13 = false;
                Sequence $this$forEach$iv4 = lines;
                boolean $i$f$forEach4 = false;
                for (Object element$iv3 : $this$forEach$iv4) {
                    String line = (String)element$iv3;
                    boolean bl14 = false;
                    List<PkuWord> words = PerceptronUtilsKt.parseToWords(line);
                    Collection collection = sampleList;
                    TrainSample trainSample = this.sentenceToSample(words);
                    boolean bl15 = false;
                    collection.add(trainSample);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object4, (Throwable)object);
            }
        }
        return sampleList;
    }

    /*
     * WARNING - void declaration
     */
    private final TrainSample sentenceToSample(List<PkuWord> line) {
        void $this$mapTo$iv$iv;
        FastStringBuilder buffer = new FastStringBuilder(100);
        List<WordTerm> wordTermList = Companion.convert(line, this.targetPos);
        Iterable $this$map$iv = wordTermList;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WordTerm wordTerm = (WordTerm)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = this.labelMap.get(it.getCustomFlag());
            if (n == null) {
                Intrinsics.throwNpe();
            }
            Integer n2 = ((Number)n).intValue();
            collection.add(n2);
        }
        int[] poss = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        ArrayList featureMatrix = new ArrayList(wordTermList.size());
        $i$f$map = 0;
        int n = wordTermList.size();
        while ($i$f$map < n) {
            void i;
            Collection collection = featureMatrix;
            IntArrayList intArrayList = NERPerceptronFeature.INSTANCE.extractFeatureVector(wordTermList, (int)i, this.featureSet, buffer);
            boolean bl = false;
            collection.add(intArrayList);
            ++i;
        }
        return new TrainSample((List)featureMatrix, poss);
    }

    @NotNull
    public final Set<String> getTargetPos() {
        return this.targetPos;
    }

    @NotNull
    public final Map<String, Integer> getLabelMap() {
        return this.labelMap;
    }

    @NotNull
    public final FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public NerSamples(@NotNull Set<String> targetPos, @NotNull Map<String, Integer> labelMap, @NotNull FeatureSet featureSet) {
        Intrinsics.checkParameterIsNotNull(targetPos, (String)"targetPos");
        Intrinsics.checkParameterIsNotNull(labelMap, (String)"labelMap");
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        this.targetPos = targetPos;
        this.labelMap = labelMap;
        this.featureSet = featureSet;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/mayabot/nlp/segment/plugins/ner/NerSamples$Companion;", "", "()V", "convert", "", "Lcom/mayabot/nlp/segment/WordTerm;", "sentence", "Lcom/mayabot/nlp/segment/common/PkuWord;", "targetPOS", "", "", "word", "pos", "label", "mynlp-segment"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<WordTerm> convert(@NotNull List<PkuWord> sentence, @NotNull Set<String> targetPOS) {
            Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
            Intrinsics.checkParameterIsNotNull(targetPOS, (String)"targetPOS");
            ArrayList list = new ArrayList(sentence.size());
            for (PkuWord word : sentence) {
                WordTerm wordTerm;
                Collection collection;
                String pos = word.getPos();
                if (word.hasSub()) {
                    boolean bl;
                    WordTerm wordTerm2;
                    Object object;
                    ArrayList<PkuWord> wordList = word.getSubWord();
                    if (targetPOS.contains(word.getPos())) {
                        PkuWord first = (PkuWord)CollectionsKt.first((List)wordList);
                        Collection collection2 = list;
                        object = this.word(first.getWord(), first.getPos(), "B-" + pos);
                        boolean bl2 = false;
                        collection2.add(object);
                        int n = 1;
                        int n2 = wordList.size() - 1;
                        while (n < n2) {
                            PkuWord the;
                            void i;
                            Intrinsics.checkExpressionValueIsNotNull((Object)wordList.get((int)i), (String)"wordList[i]");
                            Collection collection3 = list;
                            WordTerm wordTerm3 = this.word(the.getWord(), the.getPos(), "M-" + pos);
                            boolean bl3 = false;
                            collection3.add(wordTerm3);
                            ++i;
                        }
                        PkuWord last = (PkuWord)CollectionsKt.last((List)wordList);
                        object = list;
                        wordTerm2 = this.word(last.getWord(), last.getPos(), "E-" + pos);
                        bl = false;
                        object.add(wordTerm2);
                        continue;
                    }
                    for (PkuWord sub : wordList) {
                        object = list;
                        wordTerm2 = this.word(sub.getWord(), sub.getPos(), "O");
                        bl = false;
                        object.add(wordTerm2);
                    }
                    continue;
                }
                if (targetPOS.contains(word.getPos())) {
                    collection = list;
                    wordTerm = this.word(word.getWord(), word.getPos(), "S");
                    boolean bl = false;
                    collection.add(wordTerm);
                    continue;
                }
                collection = list;
                wordTerm = this.word(word.getWord(), word.getPos(), "O");
                boolean bl = false;
                collection.add(wordTerm);
            }
            return list;
        }

        @NotNull
        public final WordTerm word(@NotNull String word, @NotNull String pos, @NotNull String label) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            WordTerm term = new WordTerm(word, Nature.parse(pos));
            term.setCustomFlag(label);
            return term;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

