/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.scala.collection.concurrent;

import com.metamx.common.scala.collection.concurrent.BlockingQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001f\t\u00012+\u001b>f\u0005>,h\u000eZ3e#V,W/\u001a\u0006\u0003\u0007\u0011\t!bY8oGV\u0014(/\u001a8u\u0015\t)a!\u0001\u0006d_2dWm\u0019;j_:T!a\u0002\u0005\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005%Q\u0011AB2p[6|gN\u0003\u0002\f\u0019\u00051Q.\u001a;b[bT\u0011!D\u0001\u0004G>l7\u0001A\u000b\u0003!]\u0019\"\u0001A\t\u0011\u0007I\u0019R#D\u0001\u0003\u0013\t!\"AA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0003-]a\u0001\u0001B\u0003\u0019\u0001\t\u0007\u0011DA\u0001F#\tQr\u0004\u0005\u0002\u001c;5\tADC\u0001\b\u0013\tqBDA\u0004O_RD\u0017N\\4\u0011\u0005m\u0001\u0013BA\u0011\u001d\u0005\r\te.\u001f\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005)1/\u001b>f\rB!1$J\u000b(\u0013\t1CDA\u0005Gk:\u001cG/[8ocA\u00111\u0004K\u0005\u0003Sq\u0011A\u0001T8oO\"A1\u0006\u0001B\u0001B\u0003%q%\u0001\u0003tSj,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u000bE,X-^3\u0011\u0007=\"T#D\u00011\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012Q!U;fk\u0016DQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD\u0003B\u001d;wq\u00022A\u0005\u0001\u0016\u0011\u0015\u0019c\u00071\u0001%\u0011\u0015Yc\u00071\u0001(\u0011\u0015ic\u00071\u0001/\u0011\u001dq\u0004A1A\u0005\n}\nQaX;tK\u0012,\u0012\u0001\u0011\t\u0003\u0003\u0016k\u0011A\u0011\u0006\u0003\u0007\u0012\u000ba!\u0019;p[&\u001c'BA\u00021\u0013\t1%I\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa\u0001\u0013\u0001!\u0002\u0013\u0001\u0015AB0vg\u0016$\u0007\u0005C\u0003K\u0001\u0011\u00051*\u0001\u0003vg\u0016$G#A\u0014\t\u000b5\u0003A\u0011\u0003(\u0002\u000f\u0015t\u0017/^3vKR\u0011qJ\u0015\t\u00037AK!!\u0015\u000f\u0003\u000f\t{w\u000e\\3b]\")1\u000b\u0014a\u0001+\u0005!Q\r\\3n\u0011\u0015)\u0006\u0001\"\u0005W\u0003\u001d!W-];fk\u0016$\u0012a\u0016\t\u00047a+\u0012BA-\u001d\u0005\u0019y\u0005\u000f^5p]\u0002")
public class SizeBoundedQueue<E>
extends BlockingQueue<E> {
    private final Function1<E, Object> sizeF;
    private final long size;
    private final Queue<E> queue;
    private final AtomicLong _used;

    private AtomicLong _used() {
        return this._used;
    }

    public long used() {
        return this._used().get();
    }

    @Override
    public boolean enqueue(E elem) {
        boolean bl;
        if (elem == null) {
            throw new NullPointerException("Can't put null element");
        }
        long elemTotalLength = BoxesRunTime.unboxToLong((Object)this.sizeF.apply(elem));
        if (this.size < elemTotalLength) {
            throw new IllegalStateException("Element too big to enqueue");
        }
        if (this.size - this._used().get() < elemTotalLength) {
            bl = false;
        } else {
            this.queue.add(elem);
            this._used().addAndGet(elemTotalLength);
            this._count().incrementAndGet();
            bl = true;
        }
        return bl;
    }

    @Override
    public Option<E> dequeue() {
        None$ none$;
        if (this._used().get() == 0L) {
            none$ = None$.MODULE$;
        } else {
            E elem = this.queue.remove();
            long elemTotalLength = BoxesRunTime.unboxToLong((Object)this.sizeF.apply(elem));
            this._used().addAndGet(-elemTotalLength);
            this._count().decrementAndGet();
            none$ = new Some(elem);
        }
        return none$;
    }

    public SizeBoundedQueue(Function1<E, Object> sizeF, long size2, Queue<E> queue) {
        this.sizeF = sizeF;
        this.size = size2;
        this.queue = queue;
        this._used = new AtomicLong();
    }
}

