/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.monitorjbl.json.JsonView;

public class JsonResult {
    private static final JsonResult instance = new JsonResult();
    private static final ThreadLocal<JsonView> current = new ThreadLocal();

    private JsonResult() {
    }

    public <E> ResultWrapper<E> use(JsonView<E> view) {
        current.set(view);
        return new ResultWrapper(view);
    }

    public static JsonResult instance() {
        return instance;
    }

    static JsonView get() {
        return current.get();
    }

    static void unset() {
        current.remove();
    }

    public static class ResultWrapper<T> {
        private JsonView<T> obj;

        private ResultWrapper(JsonView<T> obj) {
            this.obj = obj;
        }

        public T returnValue() {
            return (T)this.obj.getValue();
        }
    }
}

