/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis.binding;

import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.mybatis.binding.FlexMapperProxyFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.builder.annotation.MapperAnnotationBuilder;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class FlexMapperRegistry
extends MapperRegistry {
    private final FlexConfiguration config;
    private final Map<Class<?>, FlexMapperProxyFactory<?>> knownMappers = new ConcurrentHashMap();

    public FlexMapperRegistry(FlexConfiguration config) {
        super((Configuration)config);
        this.config = config;
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        FlexMapperProxyFactory<?> mapperProxyFactory = this.knownMappers.get(type);
        if (mapperProxyFactory == null) {
            throw new BindingException("Type " + type + " is not known to the MapperRegistry.");
        }
        try {
            return (T)mapperProxyFactory.newInstance(sqlSession, this.config);
        }
        catch (Exception e) {
            throw new BindingException("Error getting mapper instance. Cause: " + e, (Throwable)e);
        }
    }

    public <T> boolean hasMapper(Class<T> type) {
        return this.knownMappers.containsKey(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addMapper(Class<T> type) {
        if (type.isInterface()) {
            if (this.hasMapper(type)) {
                throw new BindingException("Type " + type + " is already known to the MapperRegistry.");
            }
            boolean loadCompleted = false;
            try {
                this.knownMappers.put(type, new FlexMapperProxyFactory<T>(type));
                MapperAnnotationBuilder parser = new MapperAnnotationBuilder((Configuration)this.config, type);
                parser.parse();
                loadCompleted = true;
            }
            finally {
                if (!loadCompleted) {
                    this.knownMappers.remove(type);
                }
            }
        }
    }

    public Collection<Class<?>> getMappers() {
        return Collections.unmodifiableCollection(this.knownMappers.keySet());
    }

    public void addMappers(String packageName, Class<?> superType) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(superType), packageName);
        Set mapperSet = resolverUtil.getClasses();
        for (Class mapperClass : mapperSet) {
            this.addMapper(mapperClass);
        }
    }

    public void addMappers(String packageName) {
        this.addMappers(packageName, Object.class);
    }
}

