/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CaseSearchQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private QueryColumn queryColumn;
    private List<When> whens;
    private Object elseValue;

    @Override
    protected String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.buildSql(queryTables, dialect);
        if (StringUtil.hasText(this.alias)) {
            return WrapperUtil.withAlias(sql, this.alias, dialect);
        }
        return sql;
    }

    private String buildSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder("CASE");
        sql.append(" ").append(this.queryColumn.toSelectSql(queryTables, dialect));
        for (When when : this.whens) {
            sql.append(" WHEN ").append(WrapperUtil.buildValue(queryTables, when.searchValue));
            sql.append(" THEN ").append(WrapperUtil.buildValue(queryTables, when.thenValue));
        }
        if (this.elseValue != null) {
            sql.append(" ELSE ").append(WrapperUtil.buildValue(queryTables, this.elseValue));
        }
        sql.append(" END");
        return sql.toString();
    }

    @Override
    public CaseSearchQueryColumn clone() {
        CaseSearchQueryColumn clone = (CaseSearchQueryColumn)super.clone();
        clone.queryColumn = ObjectUtil.clone(this.queryColumn);
        clone.whens = CollectionUtil.cloneArrayList(this.whens);
        clone.elseValue = ObjectUtil.cloneObject(this.elseValue);
        return clone;
    }

    @Override
    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        return WrapperUtil.withBracket(this.buildSql(queryTables, dialect));
    }

    void addWhen(When when) {
        if (this.whens == null) {
            this.whens = new ArrayList<When>();
        }
        this.whens.add(when);
    }

    @Override
    public Object[] getParamValues() {
        Object[] values = FlexConsts.EMPTY_ARRAY;
        if (this.elseValue instanceof HasParamsColumn) {
            values = ArrayUtil.concat(values, ((HasParamsColumn)this.elseValue).getParamValues());
        }
        return values;
    }

    public static class Builder {
        private CaseSearchQueryColumn caseQueryColumn = new CaseSearchQueryColumn();
        private When lastWhen;

        public Builder(QueryColumn queryColumn) {
            this.caseQueryColumn.queryColumn = queryColumn;
        }

        public Then when(Object searchValue) {
            this.lastWhen = new When(searchValue);
            return new Then(this);
        }

        public Builder else_(Object elseValue) {
            this.caseQueryColumn.elseValue = elseValue;
            return this;
        }

        public CaseSearchQueryColumn end() {
            return this.caseQueryColumn;
        }

        public static class Then {
            private Builder builder;

            public Then(Builder builder) {
                this.builder = builder;
            }

            public Builder then(Object thenValue) {
                this.builder.lastWhen.setThenValue(thenValue);
                this.builder.caseQueryColumn.addWhen(this.builder.lastWhen);
                return this.builder;
            }
        }
    }

    public static class When
    implements CloneSupport<When> {
        private Object searchValue;
        private Object thenValue;

        public When(Object searchValue) {
            this.searchValue = searchValue;
        }

        public void setThenValue(Object thenValue) {
            this.thenValue = thenValue;
        }

        @Override
        public When clone() {
            try {
                When clone = (When)super.clone();
                clone.searchValue = ObjectUtil.cloneObject(this.searchValue);
                clone.thenValue = ObjectUtil.cloneObject(this.thenValue);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw FlexExceptions.wrap(e);
            }
        }
    }
}

