/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.util.ObjectUtil;
import java.util.List;

public class QueryOrderBy
implements CloneSupport<QueryOrderBy> {
    QueryColumn queryColumn;
    private String orderType = " ASC";
    private boolean nullsFirst = false;
    private boolean nullsLast = false;

    protected QueryOrderBy() {
    }

    public QueryOrderBy(QueryColumn queryColumn, String orderType) {
        this.queryColumn = queryColumn;
        this.orderType = orderType;
    }

    public QueryOrderBy(QueryColumn queryColumn) {
        this.queryColumn = queryColumn;
    }

    public QueryOrderBy nullsFirst() {
        this.nullsFirst = true;
        this.nullsLast = false;
        return this;
    }

    public QueryOrderBy nullsLast() {
        this.nullsFirst = false;
        this.nullsLast = true;
        return this;
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.queryColumn.toConditionSql(queryTables, dialect) + this.orderType;
        if (this.nullsFirst) {
            sql = sql + " NULLS FIRST";
        } else if (this.nullsLast) {
            sql = sql + " NULLS LAST";
        }
        return sql;
    }

    @Override
    public QueryOrderBy clone() {
        try {
            QueryOrderBy clone = (QueryOrderBy)super.clone();
            clone.queryColumn = ObjectUtil.clone(this.queryColumn);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

