/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.update;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.update.ModifyAttrsRecordHandler;
import com.mybatisflex.core.update.PropertySetter;
import com.mybatisflex.core.update.RawValue;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.UpdateEntity;
import java.io.Serializable;
import java.util.Map;
import org.apache.ibatis.javassist.util.proxy.Proxy;
import org.apache.ibatis.javassist.util.proxy.ProxyFactory;
import org.apache.ibatis.javassist.util.proxy.ProxyObject;

public interface UpdateWrapper<T>
extends PropertySetter<UpdateWrapper<T>>,
Serializable {
    default public Map<String, Object> getUpdates() {
        ModifyAttrsRecordHandler handler = null;
        if (this instanceof ProxyObject) {
            handler = (ModifyAttrsRecordHandler)((ProxyObject)this).getHandler();
        } else if (this instanceof Proxy) {
            handler = (ModifyAttrsRecordHandler)ProxyFactory.getHandler((Proxy)((Proxy)this));
        } else {
            throw FlexExceptions.wrap("\u83b7\u53d6\u5b9e\u4f53\u7c7b\u4ee3\u7406\u5bf9\u8c61 %s \u7684\u5b57\u6bb5\u66f4\u65b0\u5904\u7406\u5668\u65f6\u51fa\u9519\uff0c\u8be5\u5bf9\u8c61\u65e2\u4e0d\u662f ProxyObject \u7684\u5b9e\u4f8b\uff0c\u4e5f\u4e0d\u662f Proxy \u7684\u5b9e\u4f8b", this.getClass().getName());
        }
        return handler.getUpdates();
    }

    @Override
    default public UpdateWrapper<T> set(String property, Object value, boolean isEffective) {
        if (isEffective) {
            if (value instanceof QueryWrapper || value instanceof QueryColumn || value instanceof QueryCondition) {
                this.getUpdates().put(property, new RawValue(value));
            } else {
                this.getUpdates().put(property, value);
            }
        }
        return this;
    }

    @Override
    default public UpdateWrapper<T> set(QueryColumn property, Object value, boolean isEffective) {
        if (isEffective) {
            if (value instanceof QueryWrapper || value instanceof QueryColumn || value instanceof QueryCondition) {
                this.getUpdates().put(property.getName(), new RawValue(value));
            } else {
                this.getUpdates().put(property.getName(), value);
            }
        }
        return this;
    }

    @Override
    default public <E> UpdateWrapper<T> set(LambdaGetter<E> property, Object value, boolean isEffective) {
        if (isEffective) {
            if (value instanceof QueryWrapper || value instanceof QueryColumn || value instanceof QueryCondition) {
                this.getUpdates().put(LambdaUtil.getFieldName(property), new RawValue(value));
            } else {
                this.getUpdates().put(LambdaUtil.getFieldName(property), value);
            }
        }
        return this;
    }

    @Override
    default public UpdateWrapper<T> setRaw(String property, Object value, boolean isEffective) {
        if (isEffective) {
            this.getUpdates().put(property, new RawValue(value));
        }
        return this;
    }

    @Override
    default public UpdateWrapper<T> setRaw(QueryColumn property, Object value, boolean isEffective) {
        if (isEffective) {
            this.getUpdates().put(property.getName(), new RawValue(value));
        }
        return this;
    }

    @Override
    default public <E> UpdateWrapper<T> setRaw(LambdaGetter<E> property, Object value, boolean isEffective) {
        if (isEffective) {
            this.getUpdates().put(LambdaUtil.getFieldName(property), new RawValue(value));
        }
        return this;
    }

    public static <T> UpdateWrapper<T> of(T entity) {
        if (entity instanceof UpdateWrapper) {
            return (UpdateWrapper)entity;
        }
        return (UpdateWrapper)UpdateEntity.ofNotNull(entity);
    }

    public static <T> UpdateWrapper<T> of(Class<T> tClass) {
        return (UpdateWrapper)UpdateEntity.of(tClass);
    }

    default public T toEntity() {
        return (T)this;
    }
}

