/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.BatchArgsSetter;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowMapper;
import com.mybatisflex.core.row.RowMapperInvoker;
import com.mybatisflex.core.transaction.Propagation;
import com.mybatisflex.core.transaction.TransactionalManager;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.util.MapUtil;

public class Db {
    private static final Map<String, RowMapperInvoker> INVOKER_MAP = new ConcurrentHashMap<String, RowMapperInvoker>();
    static RowMapperInvoker defaultRowMapperInvoker;

    private Db() {
    }

    public static RowMapperInvoker invoker() {
        if (defaultRowMapperInvoker == null) {
            FlexGlobalConfig defaultConfig = FlexGlobalConfig.getDefaultConfig();
            SqlSessionFactory sqlSessionFactory = defaultConfig.getSqlSessionFactory();
            defaultRowMapperInvoker = new RowMapperInvoker(sqlSessionFactory);
        }
        return defaultRowMapperInvoker;
    }

    public static RowMapperInvoker invoker(String environmentId) {
        return (RowMapperInvoker)MapUtil.computeIfAbsent(INVOKER_MAP, (Object)environmentId, key -> {
            SqlSessionFactory sqlSessionFactory = FlexGlobalConfig.getConfig(key).getSqlSessionFactory();
            return new RowMapperInvoker(sqlSessionFactory);
        });
    }

    public static int insert(String schema, String tableName, Row row) {
        return Db.invoker().insert(schema, tableName, row);
    }

    public static int insert(String tableName, Row row) {
        return Db.invoker().insert(null, tableName, row);
    }

    public static int insertBySql(String sql, Object ... args) {
        return Db.invoker().insertBySql(sql, args);
    }

    public static int[] insertBatch(String schema, String tableName, Collection<Row> rows) {
        return Db.insertBatch(schema, tableName, rows, rows.size());
    }

    public static int[] insertBatch(String tableName, Collection<Row> rows) {
        return Db.insertBatch(null, tableName, rows, rows.size());
    }

    public static int[] insertBatch(String schema, String tableName, Collection<Row> rows, int batchSize) {
        return Db.executeBatch(rows, batchSize, RowMapper.class, (M mapper, E row) -> mapper.insert(schema, tableName, (Row)row));
    }

    public static int[] insertBatch(String tableName, Collection<Row> rows, int batchSize) {
        return Db.executeBatch(rows, batchSize, RowMapper.class, (M mapper, E row) -> mapper.insert(null, tableName, (Row)row));
    }

    public static int insertBatchWithFirstRowColumns(String schema, String tableName, List<Row> rows) {
        return Db.invoker().insertBatchWithFirstRowColumns(schema, tableName, rows);
    }

    public static int insertBatchWithFirstRowColumns(String tableName, List<Row> rows) {
        return Db.invoker().insertBatchWithFirstRowColumns(null, tableName, rows);
    }

    public static int deleteBySql(String sql, Object ... args) {
        return Db.invoker().deleteBySql(sql, args);
    }

    public static int deleteById(String schema, String tableName, Row row) {
        return Db.invoker().deleteById(schema, tableName, row);
    }

    public static int deleteById(String tableName, Row row) {
        return Db.invoker().deleteById(null, tableName, row);
    }

    public static int deleteById(String schema, String tableName, String primaryKey, Object id) {
        return Db.invoker().deleteById(schema, tableName, primaryKey, id);
    }

    public static int deleteById(String tableName, String primaryKey, Object id) {
        return Db.invoker().deleteById(null, tableName, primaryKey, id);
    }

    public static int deleteBatchByIds(String schema, String tableName, String primaryKey, Collection<?> ids) {
        return Db.invoker().deleteBatchByIds(schema, tableName, primaryKey, ids);
    }

    public static int deleteBatchByIds(String tableName, String primaryKey, Collection<?> ids) {
        return Db.invoker().deleteBatchByIds(null, tableName, primaryKey, ids);
    }

    public static int deleteByMap(String schema, String tableName, Map<String, Object> whereColumns) {
        return Db.invoker().deleteByQuery(schema, tableName, new QueryWrapper().where(whereColumns));
    }

    public static int deleteByMap(String tableName, Map<String, Object> whereColumns) {
        return Db.invoker().deleteByQuery(null, tableName, new QueryWrapper().where(whereColumns));
    }

    public static int deleteByCondition(String schema, String tableName, QueryCondition condition) {
        return Db.invoker().deleteByQuery(schema, tableName, new QueryWrapper().where(condition));
    }

    public static int deleteByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().deleteByQuery(null, tableName, new QueryWrapper().where(condition));
    }

    public static int deleteByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().deleteByQuery(schema, tableName, queryWrapper);
    }

    public static int deleteByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().deleteByQuery(null, tableName, queryWrapper);
    }

    public static int updateBySql(String sql, Object ... args) {
        return Db.invoker().updateBySql(sql, args);
    }

    public static int[] updateBatch(String sql, BatchArgsSetter batchArgsSetter) {
        int batchSize = batchArgsSetter.getBatchSize();
        return Db.invoker().executeBatch(batchSize, batchSize, RowMapper.class, (mapper, index) -> mapper.updateBySql(sql, batchArgsSetter.getSqlArgs((int)index)));
    }

    public static int updateById(String schema, String tableName, Row row) {
        return Db.invoker().updateById(schema, tableName, row);
    }

    public static int updateById(String tableName, Row row) {
        return Db.invoker().updateById(null, tableName, row);
    }

    public static int updateByMap(String schema, String tableName, Row data, Map<String, Object> whereColumns) {
        return Db.invoker().updateByQuery(schema, tableName, data, new QueryWrapper().where(whereColumns));
    }

    public static int updateByMap(String tableName, Row data, Map<String, Object> whereColumns) {
        return Db.invoker().updateByQuery(null, tableName, data, new QueryWrapper().where(whereColumns));
    }

    public static int updateByCondition(String schema, String tableName, Row data, QueryCondition condition) {
        return Db.invoker().updateByQuery(schema, tableName, data, new QueryWrapper().where(condition));
    }

    public static int updateByCondition(String tableName, Row data, QueryCondition condition) {
        return Db.invoker().updateByQuery(null, tableName, data, new QueryWrapper().where(condition));
    }

    public static int updateByQuery(String schema, String tableName, Row data, QueryWrapper queryWrapper) {
        return Db.invoker().updateByQuery(schema, tableName, data, queryWrapper);
    }

    public static int updateByQuery(String tableName, Row data, QueryWrapper queryWrapper) {
        return Db.invoker().updateByQuery(null, tableName, data, queryWrapper);
    }

    public static int updateBatchById(String schema, String tableName, List<Row> rows) {
        return Db.invoker().updateBatchById(schema, tableName, rows);
    }

    public static int updateBatchById(String tableName, List<Row> rows) {
        return Db.invoker().updateBatchById(null, tableName, rows);
    }

    public static <T> int updateEntitiesBatch(Collection<T> entities, int batchSize) {
        List<T> list = CollectionUtil.toList(entities);
        return Arrays.stream(Db.executeBatch(list, batchSize, RowMapper.class, RowMapper::updateEntity)).sum();
    }

    public static <T> int updateEntitiesBatch(Collection<T> entities) {
        return Db.updateEntitiesBatch(entities, 1000);
    }

    public static <M> int[] executeBatch(int totalSize, int batchSize, Class<M> mapperClass, BiConsumer<M, Integer> consumer) {
        return Db.invoker().executeBatch(totalSize, batchSize, mapperClass, consumer);
    }

    public static <M, D> int[] executeBatch(Collection<D> datas, Class<M> mapperClass, BiConsumer<M, D> consumer) {
        return Db.executeBatch(datas, 1000, mapperClass, consumer);
    }

    public static <M, E> int[] executeBatch(Collection<E> datas, int batchSize, Class<M> mapperClass, BiConsumer<M, E> consumer) {
        return Db.invoker().executeBatch(datas, batchSize, mapperClass, consumer);
    }

    public static Row selectOneBySql(String sql, Object ... args) {
        return Db.invoker().selectOneBySql(sql, args);
    }

    public static Row selectOneById(String schema, String tableName, Row row) {
        return Db.invoker().selectOneById(schema, tableName, row);
    }

    public static Row selectOneById(String tableName, Row row) {
        return Db.invoker().selectOneById(null, tableName, row);
    }

    public static Row selectOneById(String schema, String tableName, String primaryKey, Object id) {
        return Db.invoker().selectOneById(schema, tableName, primaryKey, id);
    }

    public static Row selectOneById(String tableName, String primaryKey, Object id) {
        return Db.invoker().selectOneById(null, tableName, primaryKey, id);
    }

    public static Row selectOneByMap(String schema, String tableName, Map whereColumns) {
        return Db.invoker().selectOneByQuery(schema, tableName, new QueryWrapper().where(whereColumns).limit(1L));
    }

    public static Row selectOneByMap(String tableName, Map whereColumns) {
        return Db.invoker().selectOneByQuery(null, tableName, new QueryWrapper().where(whereColumns).limit(1L));
    }

    public static Row selectOneByCondition(String schema, String tableName, QueryCondition condition) {
        return Db.invoker().selectOneByQuery(schema, tableName, new QueryWrapper().where(condition).limit(1L));
    }

    public static Row selectOneByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().selectOneByQuery(null, tableName, new QueryWrapper().where(condition).limit(1L));
    }

    public static Row selectOneByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectOneByQuery(schema, tableName, queryWrapper);
    }

    public static Row selectOneByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectOneByQuery(null, tableName, queryWrapper);
    }

    public static Row selectOneByQuery(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.isEmpty()) {
            throw FlexExceptions.wrap("table must not be null or empty in Db.selectOneByQuery", new Object[0]);
        }
        return Db.invoker().selectOneByQuery(null, null, queryWrapper);
    }

    public static List<Row> selectListBySql(String sql, Object ... args) {
        return Db.invoker().selectListBySql(sql, args);
    }

    public static List<Row> selectListByMap(String schema, String tableName, Map<String, Object> whereColumns) {
        return Db.invoker().selectListByQuery(schema, tableName, new QueryWrapper().where(whereColumns));
    }

    public static List<Row> selectListByMap(String tableName, Map<String, Object> whereColumns) {
        return Db.invoker().selectListByQuery(null, tableName, new QueryWrapper().where(whereColumns));
    }

    public static List<Row> selectListByMap(String schema, String tableName, Map<String, Object> whereColumns, Long count) {
        return Db.invoker().selectListByQuery(schema, tableName, new QueryWrapper().where(whereColumns).limit(count));
    }

    public static List<Row> selectListByMap(String tableName, Map<String, Object> whereColumns, Long count) {
        return Db.invoker().selectListByQuery(null, tableName, new QueryWrapper().where(whereColumns).limit(count));
    }

    public static List<Row> selectListByCondition(String schema, String tableName, QueryCondition condition) {
        return Db.invoker().selectListByQuery(schema, tableName, new QueryWrapper().where(condition));
    }

    public static List<Row> selectListByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().selectListByQuery(null, tableName, new QueryWrapper().where(condition));
    }

    public static List<Row> selectListByCondition(String schema, String tableName, QueryCondition condition, Long count) {
        return Db.invoker().selectListByQuery(schema, tableName, new QueryWrapper().where(condition).limit(count));
    }

    public static List<Row> selectListByCondition(String tableName, QueryCondition condition, Long count) {
        return Db.invoker().selectListByQuery(null, tableName, new QueryWrapper().where(condition).limit(count));
    }

    public static List<Row> selectListByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectListByQuery(schema, tableName, queryWrapper);
    }

    public static List<Row> selectListByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectListByQuery(null, tableName, queryWrapper);
    }

    public static List<Row> selectListByQuery(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.isEmpty()) {
            throw FlexExceptions.wrap("table must not be null or empty in Db.selectListByQuery", new Object[0]);
        }
        return Db.invoker().selectListByQuery(null, null, queryWrapper);
    }

    public static List<Row> selectAll(String schema, String tableName) {
        return Db.invoker().selectAll(schema, tableName);
    }

    public static List<Row> selectAll(String tableName) {
        return Db.invoker().selectAll(null, tableName);
    }

    public static Object selectObject(String sql, Object ... args) {
        return Db.invoker().selectObject(sql, args);
    }

    public static Object selectObject(String schema, String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectObjectByQuery(schema, tableName, queryWrapper);
    }

    public static Object selectObject(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectObjectByQuery(null, tableName, queryWrapper);
    }

    public static Object selectObject(QueryWrapper queryWrapper) {
        return Db.invoker().selectObjectByQuery(null, null, queryWrapper);
    }

    public static List<Object> selectObjectList(String sql, Object ... args) {
        return Db.invoker().selectObjectList(sql, args);
    }

    public static List<Object> selectObjectList(String schema, String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectObjectListByQuery(schema, tableName, queryWrapper);
    }

    public static List<Object> selectObjectList(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectObjectListByQuery(null, tableName, queryWrapper);
    }

    public static List<Object> selectObjectList(QueryWrapper queryWrapper) {
        return Db.invoker().selectObjectListByQuery(null, null, queryWrapper);
    }

    public static long selectCount(String sql, Object ... args) {
        return Db.invoker().selectCount(sql, args);
    }

    public static long selectCountByCondition(String schema, String tableName, QueryCondition condition) {
        return Db.invoker().selectCountByQuery(schema, tableName, new QueryWrapper().where(condition));
    }

    public static long selectCountByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().selectCountByQuery(null, tableName, new QueryWrapper().where(condition));
    }

    public static long selectCountByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectCountByQuery(schema, tableName, queryWrapper);
    }

    public static long selectCountByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectCountByQuery(null, tableName, queryWrapper);
    }

    public static long selectCountByQuery(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.isEmpty()) {
            throw FlexExceptions.wrap("Query tables must not be null or empty in Db.selectCountByQuery", new Object[0]);
        }
        return Db.invoker().selectCountByQuery(null, null, queryWrapper);
    }

    public static Page<Row> paginate(String schema, String tableName, Number pageNumber, Number pageSize, QueryCondition condition) {
        return Db.invoker().paginate(schema, tableName, new Page<Row>(pageNumber, pageSize), QueryWrapper.create().where(condition));
    }

    public static Page<Row> paginate(String tableName, Number pageNumber, Number pageSize, QueryCondition condition) {
        return Db.invoker().paginate(null, tableName, new Page<Row>(pageNumber, pageSize), QueryWrapper.create().where(condition));
    }

    public static Page<Row> paginate(String schema, String tableName, Number pageNumber, Number pageSize, Number totalRow, QueryCondition condition) {
        return Db.invoker().paginate(schema, tableName, new Page<Row>(pageNumber, pageSize, totalRow), QueryWrapper.create().where(condition));
    }

    public static Page<Row> paginate(String tableName, Number pageNumber, Number pageSize, Number totalRow, QueryCondition condition) {
        return Db.invoker().paginate(null, tableName, new Page<Row>(pageNumber, pageSize, totalRow), QueryWrapper.create().where(condition));
    }

    public static Page<Row> paginate(String schema, String tableName, Number pageNumber, Number pageSize, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(schema, tableName, new Page<Row>(pageNumber, pageSize), queryWrapper);
    }

    public static Page<Row> paginate(String tableName, Number pageNumber, Number pageSize, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(null, tableName, new Page<Row>(pageNumber, pageSize), queryWrapper);
    }

    public static Page<Row> paginate(String schema, String tableName, Number pageNumber, Number pageSize, Number totalRow, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(schema, tableName, new Page<Row>(pageNumber, pageSize, totalRow), queryWrapper);
    }

    public static Page<Row> paginate(String tableName, Number pageNumber, Number pageSize, Number totalRow, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(null, tableName, new Page<Row>(pageNumber, pageSize, totalRow), queryWrapper);
    }

    public static Page<Row> paginate(String schema, String tableName, Page<Row> page, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(schema, tableName, page, queryWrapper);
    }

    public static Page<Row> paginate(String tableName, Page<Row> page, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(null, tableName, page, queryWrapper);
    }

    public static boolean tx(Supplier<Boolean> supplier) {
        return Db.tx(supplier, Propagation.REQUIRED);
    }

    public static boolean tx(Supplier<Boolean> supplier, Propagation propagation) {
        Boolean result = TransactionalManager.exec(supplier, propagation, false);
        return result != null && result != false;
    }

    public static <T> T txWithResult(Supplier<T> supplier) {
        return Db.txWithResult(supplier, Propagation.REQUIRED);
    }

    public static <T> T txWithResult(Supplier<T> supplier, Propagation propagation) {
        return TransactionalManager.exec(supplier, propagation, true);
    }
}

