/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.project.MavenProject;

public class Report {
    private final long timestamp;
    private final MavenProject project;
    private final String format;
    private final Action action;
    private final boolean skipped;
    private final Map<String, Result> results = new ConcurrentHashMap<String, Result>();
    private final Path basePath;

    public Report(String format, Action action, MavenProject project, Clock clock, boolean skip) {
        this.format = format;
        this.action = action;
        this.project = project;
        this.skipped = skip;
        this.basePath = project.getBasedir().toPath().toAbsolutePath();
        this.timestamp = clock.millis();
    }

    void add(File file, Result result) {
        if (!this.skipped) {
            this.results.put(this.basePath.relativize(file.getAbsoluteFile().toPath()).toString(), result);
        }
    }

    public void exportTo(File reportLocation) {
        if (!this.skipped && reportLocation != null) {
            reportLocation.getParentFile().mkdirs();
            String format = this.format;
            if (format == null) {
                int p = reportLocation.getName().lastIndexOf(46);
                String string = format = p >= 0 ? reportLocation.getName().substring(p + 1) : null;
                if (format == null) {
                    throw new IllegalStateException("Report format ('xml' or 'json') needs to be specified in the plugin configuration because it cannot be determined from the report extension");
                }
            }
            switch (format = format.toLowerCase(Locale.ROOT)) {
                case "xml": {
                    XMLTag files3 = XMLDoc.newDocument((boolean)true).addRoot("licensePluginReport").addAttribute("timestamp", Long.toString(this.timestamp)).addAttribute("goal", this.action.name()).addTag("module").addAttribute("groupId", this.project == null ? "unknown" : this.project.getArtifact().getGroupId()).addAttribute("artifactId", this.project == null ? "unknown" : this.project.getArtifact().getArtifactId()).addAttribute("version", this.project == null ? "unknown" : this.project.getArtifact().getVersion()).gotoRoot().addTag("files");
                    this.results.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> files3.addTag("file").addAttribute("path", (String)e.getKey()).addAttribute("result", ((Result)((Object)((Object)e.getValue()))).name()).gotoParent());
                    try {
                        Files.write(reportLocation.toPath(), files3.gotoRoot().toBytes("UTF-8"), new OpenOption[0]);
                        break;
                    }
                    catch (IOException e2) {
                        throw new UncheckedIOException(e2);
                    }
                }
                case "json": {
                    JsonObject module = new JsonObject();
                    module.add("groupId", (JsonElement)new JsonPrimitive(this.project == null ? "unknown" : this.project.getArtifact().getGroupId()));
                    module.add("artifactId", (JsonElement)new JsonPrimitive(this.project == null ? "unknown" : this.project.getArtifact().getArtifactId()));
                    module.add("version", (JsonElement)new JsonPrimitive(this.project == null ? "unknown" : this.project.getArtifact().getVersion()));
                    JsonObject root = new JsonObject();
                    root.add("timestamp", (JsonElement)new JsonPrimitive(Long.toString(this.timestamp)));
                    root.add("goal", (JsonElement)new JsonPrimitive(this.action.name()));
                    root.add("module", (JsonElement)module);
                    root.add("files", (JsonElement)this.results.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
                        JsonObject file = new JsonObject();
                        file.add("path", (JsonElement)new JsonPrimitive((String)e.getKey()));
                        file.add("result", (JsonElement)new JsonPrimitive(((Result)((Object)((Object)e.getValue()))).name()));
                        return file;
                    }).reduce(new JsonArray(), (files, file) -> {
                        files.add((JsonElement)file);
                        return files;
                    }, (files1, files2) -> {
                        files1.addAll(files2);
                        return files1;
                    }));
                    try {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        Files.write(reportLocation.toPath(), gson.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        break;
                    }
                    catch (IOException e3) {
                        throw new UncheckedIOException(e3);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Invalid report format: '" + format + "'");
                }
            }
        }
    }

    static enum Result {
        PRESENT,
        MISSING,
        NOOP,
        ADDED,
        REPLACED,
        REMOVED,
        UNKNOWN;

    }

    static enum Action {
        CHECK,
        FORMAT,
        REMOVE;

    }
}

