/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.util;

import com.mycila.maven.plugin.license.Default;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.MatchPatterns;
import org.apache.maven.shared.utils.io.ScanConductor;

public final class Selection {
    private final File basedir;
    private final String[] included;
    private final String[] excluded;
    private final Log log;
    private final String[] userExcluded;
    private DirectoryScanner scanner;

    public Selection(File basedir, String[] included, String[] excluded, boolean useDefaultExcludes, Log log) {
        this.basedir = basedir;
        this.log = log;
        String[] overrides = Selection.buildOverrideInclusions(useDefaultExcludes, included);
        this.included = Selection.buildInclusions(included, overrides);
        this.userExcluded = excluded;
        this.excluded = Selection.buildExclusions(useDefaultExcludes, excluded, overrides);
    }

    public String[] getSelectedFiles() {
        this.scanIfneeded();
        return this.scanner.getIncludedFiles();
    }

    DirectoryScanner getScanner() {
        return this.scanner;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String[] getIncluded() {
        return this.included;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    private void scanIfneeded() {
        if (this.scanner == null) {
            boolean debugEnabled = this.log.isDebugEnabled();
            String[] folderExcludes = this.findFolderExcludes();
            final MatchPatterns excludePatterns = MatchPatterns.from((String[])folderExcludes);
            if (debugEnabled) {
                this.log.debug((CharSequence)("Starting to visit " + this.basedir + ", excluding directories: " + Arrays.asList(folderExcludes)));
            }
            this.scanner = new DirectoryScanner();
            this.scanner.setScanConductor(new ScanConductor(){

                public ScanConductor.ScanAction visitDirectory(String name, File directory) {
                    if (excludePatterns.matches(name, true)) {
                        return ScanConductor.ScanAction.NO_RECURSE;
                    }
                    return ScanConductor.ScanAction.CONTINUE;
                }

                public ScanConductor.ScanAction visitFile(String name, File file) {
                    return ScanConductor.ScanAction.CONTINUE;
                }
            });
            this.scanner.setBasedir(this.basedir);
            this.scanner.setIncludes(this.included);
            this.scanner.setExcludes(this.excluded);
            this.scanner.scan();
        }
    }

    private String[] findFolderExcludes() {
        ArrayList<String> excludes = new ArrayList<String>(this.excluded.length / 2);
        for (String exclude : this.userExcluded != null ? this.userExcluded : this.excluded) {
            if (!this.isFolderExclusion(exclude)) continue;
            excludes.add(exclude);
        }
        Collections.reverse(excludes);
        return excludes.toArray(new String[0]);
    }

    private boolean isFolderExclusion(String exclude) {
        return exclude.endsWith(File.separator + "**");
    }

    private static String[] buildExclusions(boolean useDefaultExcludes, String[] excludes, String[] overrides) {
        ArrayList<String> exclusions = new ArrayList<String>();
        if (useDefaultExcludes) {
            exclusions.addAll(Arrays.asList(Default.EXCLUDES));
        }
        for (String override : overrides) {
            exclusions.remove(override);
        }
        if (excludes != null && excludes.length > 0) {
            exclusions.addAll(Arrays.asList(excludes));
        }
        return exclusions.toArray(new String[exclusions.size()]);
    }

    private static String[] buildInclusions(String[] includes, String[] overrides) {
        ArrayList<String> inclusions = new ArrayList<String>(Arrays.asList(includes != null && includes.length > 0 ? includes : Default.INCLUDE));
        inclusions.removeAll(Arrays.asList(overrides));
        if (inclusions.isEmpty()) {
            inclusions.addAll(Arrays.asList(Default.INCLUDE));
        }
        return inclusions.toArray(new String[inclusions.size()]);
    }

    private static String[] buildOverrideInclusions(boolean useDefaultExcludes, String[] includes) {
        if (!useDefaultExcludes || includes == null || includes.length == 0) {
            return new String[0];
        }
        ArrayList<String> overrides = new ArrayList<String>(Arrays.asList(Default.EXCLUDES));
        overrides.retainAll(Arrays.asList(includes));
        return overrides.toArray(new String[0]);
    }
}

