/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.ConvertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public final class ClusterHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private RedisConnectionFactory connectionFactory;

    ClusterHandler(Integer dbIndex) {
        this(HandlerManager.createRedisTemplate(dbIndex));
    }

    ClusterHandler(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.connectionFactory = this.redisTemplate.getRequiredConnectionFactory();
    }

    public ClusterInfo info() {
        return this.connectionFactory.getClusterConnection().clusterGetClusterInfo();
    }

    public Iterable<RedisClusterNode> nodes() {
        return this.connectionFactory.getClusterConnection().clusterGetNodes();
    }

    public Collection<RedisClusterNode> slaves(String masterId) {
        return this.connectionFactory.getClusterConnection().clusterGetSlaves(RedisClusterNode.newRedisClusterNode().withId(masterId).build());
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> masterSlaves() {
        return this.connectionFactory.getClusterConnection().clusterGetMasterSlaveMap();
    }

    public RedisClusterNode nodeForKey(String key) {
        return this.connectionFactory.getClusterConnection().clusterGetNodeForKey(ConvertUtil.toBytes(this.redisTemplate.getKeySerializer(), key));
    }

    public RedisClusterNode nodeForSlot(int slotIndex) {
        return this.connectionFactory.getClusterConnection().clusterGetNodeForSlot(slotIndex);
    }

    public void meet(RedisClusterNode clusterNode) {
        this.connectionFactory.getClusterConnection().clusterMeet(clusterNode);
    }

    public void meet(String ip, String port) {
        this.connectionFactory.getClusterConnection().clusterMeet(RedisClusterNode.newRedisClusterNode().listeningAt(ip, Integer.valueOf(port).intValue()).build());
    }

    public void forget(RedisClusterNode clusterNode) {
        this.connectionFactory.getClusterConnection().clusterForget(clusterNode);
    }

    public void forget(String nodeId) {
        this.connectionFactory.getClusterConnection().clusterForget(RedisClusterNode.newRedisClusterNode().withId(nodeId).build());
    }

    public void replicate(RedisClusterNode master, RedisClusterNode replica) {
        this.connectionFactory.getClusterConnection().clusterReplicate(master, replica);
    }

    public void addSlot(RedisClusterNode clusterNode, int ... slotIndex) {
        this.connectionFactory.getClusterConnection().clusterAddSlots(clusterNode, slotIndex);
    }

    public void addSlotInRange(RedisClusterNode clusterNode, int beginSlotIndex, int endSlotIndex) {
        this.connectionFactory.getClusterConnection().clusterAddSlots(clusterNode, new RedisClusterNode.SlotRange(Integer.valueOf(beginSlotIndex), Integer.valueOf(endSlotIndex)));
    }

    public void removeSlot(RedisClusterNode clusterNode, int ... slotIndex) {
        this.connectionFactory.getClusterConnection().clusterDeleteSlots(clusterNode, slotIndex);
    }

    public void removeSlotInRange(RedisClusterNode clusterNode, int beginSlotIndex, int endSlotIndex) {
        this.connectionFactory.getClusterConnection().clusterDeleteSlotsInRange(clusterNode, new RedisClusterNode.SlotRange(Integer.valueOf(beginSlotIndex), Integer.valueOf(endSlotIndex)));
    }

    public void setSlot(RedisClusterNode node, int slotIndex, RedisClusterCommands.AddSlots mode) {
        this.connectionFactory.getClusterConnection().clusterSetSlot(node, slotIndex, mode);
    }

    public Integer keySlot(String key) {
        return this.connectionFactory.getClusterConnection().clusterGetSlotForKey(ConvertUtil.toBytes(this.redisTemplate.getKeySerializer(), key));
    }

    public Long countKeyInSlot(int slotIndex) {
        return this.connectionFactory.getClusterConnection().clusterCountKeysInSlot(slotIndex);
    }

    public List<String> keysInSlot(int slotIndex, Integer count) {
        List byteList = this.connectionFactory.getClusterConnection().clusterGetKeysInSlot(slotIndex, count);
        if (byteList != null && byteList.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>(byteList.size());
            for (byte[] bytes : byteList) {
                keys.add(ConvertUtil.toStr(this.redisTemplate.getKeySerializer(), bytes));
            }
            return keys;
        }
        return new ArrayList<String>(0);
    }
}

