/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.ConvertUtil;
import java.util.List;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public final class CustomCommandHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;

    CustomCommandHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
    }

    public Object executeCommandAsObj(String command, List<String> keys, Object ... args) {
        Object result = this.redisTemplate.getRequiredConnectionFactory().getConnection().execute(command, ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), this.redisTemplate.getValueSerializer(), keys, args));
        return result instanceof byte[] ? this.redisTemplate.getValueSerializer().deserialize((byte[])result) : result;
    }

    public Object executeCommand(String command, List<String> keys, Object ... args) {
        Object result = this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().execute(command, ConvertUtil.toByteArray(this.stringRedisTemplate.getKeySerializer(), this.stringRedisTemplate.getValueSerializer(), keys, args));
        return result instanceof byte[] ? this.stringRedisTemplate.getValueSerializer().deserialize((byte[])result) : result;
    }

    public <T> T deserializeAsObj(byte[] bytes) {
        return (T)this.redisTemplate.getValueSerializer().deserialize(bytes);
    }

    public <T> T deserializeAsObj(Class<T> type, byte[] bytes) {
        Object value = this.redisTemplate.getValueSerializer().deserialize(bytes);
        return (T)(value instanceof JSON ? JSONObject.toJavaObject((JSON)((JSON)value), type) : value);
    }

    public <T> T deserialize(byte[] bytes) {
        return (T)this.stringRedisTemplate.getValueSerializer().deserialize(bytes);
    }
}

