/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.naah69.core.handler.CustomCommandHandler;
import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.RedisUtil;
import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.serializer.RedisSerializer;

public final class DBHandler
implements RedisHandler {
    private static final Logger log = LoggerFactory.getLogger(DBHandler.class);
    private static final Clock CLOCK = Clock.systemDefaultZone();
    private RedisTemplate<String, Object> redisTemplate;
    private int dbIndex;

    DBHandler(Integer dbIndex) {
        this.dbIndex = dbIndex;
        this.redisTemplate = HandlerManager.createRedisTemplate(dbIndex);
    }

    public int getDBIndex() {
        return this.dbIndex;
    }

    public Properties getDBInfo() {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().serverCommands().info();
    }

    public Properties getDBInfo(DBOption dbOption) {
        RedisServerCommands serverCommands = this.redisTemplate.getRequiredConnectionFactory().getConnection().serverCommands();
        if (dbOption != null) {
            return serverCommands.info(dbOption.option);
        }
        return serverCommands.info(DBOption.DEFAULT.option);
    }

    public void clearDB() {
        try {
            this.redisTemplate.getRequiredConnectionFactory().getConnection().serverCommands().flushDb();
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage());
        }
    }

    public void clearDBAll() {
        try {
            this.redisTemplate.getRequiredConnectionFactory().getConnection().serverCommands().flushAll();
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage());
        }
    }

    public void setConfig(String param, String value) {
        this.redisTemplate.getRequiredConnectionFactory().getConnection().setConfig(param, value);
    }

    public Properties getConfig(String param) {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().getConfig(param);
    }

    public void resetConfigStats() {
        this.redisTemplate.getRequiredConnectionFactory().getConnection().resetConfigStats();
    }

    public void setClientName(String name) {
        this.redisTemplate.getRequiredConnectionFactory().getConnection().setClientName(RedisSerializer.string().serialize((Object)name));
    }

    public String getClientName() {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().getClientName();
    }

    public List<RedisClientInfo> getClientList() {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().getClientList();
    }

    public void killClient(String ip, int port) {
        this.redisTemplate.killClient(ip, port);
    }

    public String getRole() {
        CustomCommandHandler commandHandler = RedisUtil.getCustomCommandHandler(this.dbIndex);
        List list = (List)commandHandler.executeCommand("ROLE", null, new Object[0]);
        return (String)commandHandler.deserialize((byte[])list.get(0));
    }

    public void slaveOf(String ip, int port) {
        this.redisTemplate.slaveOf(ip, port);
    }

    public void slaveOfNoOne() {
        this.redisTemplate.slaveOfNoOne();
    }

    public void beginTransaction() {
        this.redisTemplate.multi();
    }

    public List commit() {
        return this.redisTemplate.exec();
    }

    public void cancelTransaction() {
        this.redisTemplate.discard();
    }

    public void watch(String ... keys) {
        this.redisTemplate.watch(Arrays.asList(keys));
    }

    public void unwatch() {
        this.redisTemplate.unwatch();
    }

    public void bgReWriteAof() {
        this.redisTemplate.getRequiredConnectionFactory().getConnection().bgReWriteAof();
    }

    public void bgSave() {
        this.redisTemplate.getRequiredConnectionFactory().getConnection().bgSave();
    }

    public void save() {
        this.redisTemplate.getRequiredConnectionFactory().getConnection().save();
    }

    public Long lastSave() {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().lastSave();
    }

    public Long ping() {
        RedisConnection connection = this.redisTemplate.getRequiredConnectionFactory().getConnection();
        long begin = CLOCK.millis();
        connection.ping();
        long end = CLOCK.millis();
        return end - begin;
    }

    public Long time() {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().serverCommands().time();
    }

    public String echo(String message) {
        RedisSerializer serializer = RedisSerializer.string();
        return (String)serializer.deserialize(this.redisTemplate.getRequiredConnectionFactory().getConnection().echo(serializer.serialize((Object)message)));
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public static enum DBOption {
        SERVER("server"),
        CLIENTS("clients"),
        MEMORY("memory"),
        PERSISTENCE("persistence"),
        STATS("stats"),
        REPLICATION("replication"),
        CPU("cpu"),
        COMMANDSTATS("commandstats"),
        CLUSTER("cluster"),
        KEYSPACE("keyspace"),
        ALL("all"),
        DEFAULT("default");

        private String option;

        private DBOption(String option) {
            this.option = option;
        }
    }
}

