/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.ConvertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public final class GeoHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private GeoOperations<String, Object> geoOperations;
    private GeoOperations<String, String> stringGeoOperations;

    GeoHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.geoOperations = this.redisTemplate.opsForGeo();
        this.stringGeoOperations = this.stringRedisTemplate.opsForGeo();
    }

    public Long addAsObj(String key, Point point, Object value) {
        return this.geoOperations.add((Object)key, point, value);
    }

    public Long add(String key, Point point, String value) {
        return this.stringGeoOperations.add((Object)key, point, (Object)value);
    }

    public Long addAsObj(String key, Map<Object, Point> params) {
        return this.geoOperations.add((Object)key, params);
    }

    public Long add(String key, Map<String, Point> params) {
        return this.stringGeoOperations.add((Object)key, params);
    }

    public List<Point> positionAsObj(String key, Object ... values) {
        return this.geoOperations.position((Object)key, values);
    }

    public List<Point> position(String key, String ... values) {
        return this.stringGeoOperations.position((Object)key, (Object[])values);
    }

    public List<String> hashAsObj(String key, Object ... values) {
        if (values == null || values.length == 0) {
            return new ArrayList<String>();
        }
        return this.geoOperations.hash((Object)key, values);
    }

    public List<String> hash(String key, String ... values) {
        if (values == null || values.length == 0) {
            return new ArrayList<String>();
        }
        return this.stringGeoOperations.hash((Object)key, (Object[])values);
    }

    public Distance distanceAsObj(String key, Object member1, Object member2) {
        return this.geoOperations.distance((Object)key, member1, member2);
    }

    public Distance distance(String key, String member1, String member2) {
        return this.stringGeoOperations.distance((Object)key, (Object)member1, (Object)member2);
    }

    public Distance distanceAsObj(String key, Object member1, Object member2, Metric metric) {
        return this.geoOperations.distance((Object)key, member1, member2, metric);
    }

    public Distance distance(String key, String member1, String member2, Metric metric) {
        return this.stringGeoOperations.distance((Object)key, (Object)member1, (Object)member2, metric);
    }

    public Map<Object, Point> radiusByMemberAsObj(String key, Object value, Distance distance) {
        GeoResults results = this.geoOperations.radius((Object)key, value, distance);
        return ConvertUtil.toMap(results);
    }

    public Map<String, Point> radiusByMember(String key, String value, Distance distance) {
        GeoResults results = this.stringGeoOperations.radius((Object)key, (Object)value, distance);
        return ConvertUtil.toMap(results);
    }

    public Map<Object, Point> radiusByMemberAsObj(String key, Object value, Double radius) {
        GeoResults results = this.geoOperations.radius((Object)key, value, radius.doubleValue());
        return ConvertUtil.toMap(results);
    }

    public Map<String, Point> radiusByMember(String key, String value, Double radius) {
        GeoResults results = this.stringGeoOperations.radius((Object)key, (Object)value, radius.doubleValue());
        return ConvertUtil.toMap(results);
    }

    public Map<Object, Point> radiusByMemberAsObj(String key, Object value, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        GeoResults results = this.geoOperations.radius((Object)key, value, distance, args);
        return ConvertUtil.toMap(results);
    }

    public Map<String, Point> radiusByMember(String key, String value, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        GeoResults results = this.stringGeoOperations.radius((Object)key, (Object)value, distance, args);
        return ConvertUtil.toMap(results);
    }

    public Map<Object, Point> radiusAsObj(String key, Circle within) {
        GeoResults results = this.geoOperations.radius((Object)key, within);
        return ConvertUtil.toMap(results);
    }

    public Map<String, Point> radius(String key, Circle within) {
        GeoResults results = this.stringGeoOperations.radius((Object)key, within);
        return ConvertUtil.toMap(results);
    }

    public Map<Object, Point> radiusAsObj(String key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        GeoResults results = this.geoOperations.radius((Object)key, within, args);
        return ConvertUtil.toMap(results);
    }

    public Map<String, Point> radius(String key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        GeoResults results = this.stringGeoOperations.radius((Object)key, within, args);
        return ConvertUtil.toMap(results);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> radiusByMemberWithResultAsObj(String key, Object value, Distance distance) {
        return this.geoOperations.radius((Object)key, value, distance);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> radiusByMemberWithResult(String key, String value, Distance distance) {
        return this.stringGeoOperations.radius((Object)key, (Object)value, distance);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> radiusByMemberAsObjWithResult(String key, Object value, Double radius) {
        return this.geoOperations.radius((Object)key, value, radius.doubleValue());
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> radiusByMemberWithResult(String key, String value, Double radius) {
        return this.stringGeoOperations.radius((Object)key, (Object)value, radius.doubleValue());
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> radiusByMemberAsObjWithResult(String key, Object value, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.geoOperations.radius((Object)key, value, distance, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> radiusByMemberWithResult(String key, String value, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.stringGeoOperations.radius((Object)key, (Object)value, distance, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> radiusAsObjWithResult(String key, Circle within) {
        return this.geoOperations.radius((Object)key, within);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> radiusWithResult(String key, Circle within) {
        return this.stringGeoOperations.radius((Object)key, within);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> radiusAsObjWithResult(String key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.geoOperations.radius((Object)key, within, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> radiusWithResult(String key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.stringGeoOperations.radius((Object)key, within, args);
    }

    public Long removeAsObj(String key, String ... members) {
        return this.geoOperations.remove((Object)key, (Object[])members);
    }

    public Long remove(String key, String ... members) {
        return this.stringGeoOperations.remove((Object)key, (Object[])members);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

