/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.ConvertUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public final class ZsetHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private ZSetOperations<String, Object> zSetOperations;
    private ZSetOperations<String, String> stringZSetOperations;

    ZsetHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.zSetOperations = this.redisTemplate.opsForZSet();
        this.stringZSetOperations = this.stringRedisTemplate.opsForZSet();
    }

    public Boolean addAsObj(String key, Object value, double score) {
        return this.zSetOperations.add((Object)key, value, score);
    }

    public Boolean add(String key, String value, double score) {
        return this.stringZSetOperations.add((Object)key, (Object)value, score);
    }

    public Long addAsObj(String key, Map<Double, Object> map) {
        return this.zSetOperations.add((Object)key, ConvertUtil.toTypedTupleSet(map));
    }

    public Long add(String key, Map<Double, String> map) {
        return this.stringZSetOperations.add((Object)key, ConvertUtil.toTypedTupleSet(map));
    }

    public Long addAsObj(String key, Object ... values) {
        return this.addAsObj(key, ConvertUtil.toMap(values));
    }

    public Long add(String key, String ... values) {
        return this.add(key, ConvertUtil.toMap(values));
    }

    public Long sizeAsObj(String key) {
        return this.zSetOperations.zCard((Object)key);
    }

    public Long size(String key) {
        return this.stringZSetOperations.zCard((Object)key);
    }

    public Long countAsObj(String key, Double min, Double max) {
        return this.zSetOperations.count((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long count(String key, Double min, Double max) {
        return this.stringZSetOperations.count((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Set ascRangeAsObj(String key, Long startIndex, Long endIndex) {
        return this.zSetOperations.range((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set<String> ascRange(String key, Long startIndex, Long endIndex) {
        return this.stringZSetOperations.range((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set descRangeAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return this.ascRangeAsObj(key, -endSortIndex.longValue() - 1L, startSortIndex - 1L);
    }

    public Set<String> descRange(String key, Long startSortIndex, Long endSortIndex) {
        return this.ascRange(key, -endSortIndex.longValue() - 1L, -startSortIndex.longValue() - 1L);
    }

    public Set ascRangeByLexAsObj(String key, Long startSortIndex, boolean isContainsStart, Long endSortIndex, boolean isContainsEnd) {
        return this.zSetOperations.rangeByLex((Object)key, this.getRange(startSortIndex, isContainsStart, endSortIndex, isContainsEnd));
    }

    public Set<String> ascRangeByLex(String key, Long startSortIndex, boolean isContainsStart, Long endSortIndex, boolean isContainsEnd) {
        return this.stringZSetOperations.rangeByLex((Object)key, this.getRange(startSortIndex, isContainsStart, endSortIndex, isContainsEnd));
    }

    public Set ascRangeByLexAsObj(String key, Long startSortIndex, boolean isContainsStart, Long endSortIndex, boolean isContainsEnd, Integer count, Integer offset) {
        return this.zSetOperations.rangeByLex((Object)key, this.getRange(startSortIndex, isContainsStart, endSortIndex, isContainsEnd), RedisZSetCommands.Limit.limit().count(count.intValue()).offset(offset.intValue()));
    }

    public Set<String> ascRangeByLex(String key, Long startSortIndex, boolean isContainsStart, Long endSortIndex, boolean isContainsEnd, Integer count, Integer offset) {
        return this.stringZSetOperations.rangeByLex((Object)key, this.getRange(startSortIndex, isContainsStart, endSortIndex, isContainsEnd), RedisZSetCommands.Limit.limit().count(count.intValue()).offset(offset.intValue()));
    }

    public Set rangeByScoreAsObj(String key, Double min, Double max, Long count, Long offset) {
        return this.zSetOperations.rangeByScore((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue());
    }

    public Set<String> rangeByScore(String key, Double min, Double max, Long count, Long offset) {
        return this.stringZSetOperations.rangeByScore((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue());
    }

    public Map<Double, Object> rangeByScoreAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return ConvertUtil.toMap(this.zSetOperations.rangeWithScores((Object)key, startSortIndex.longValue(), endSortIndex.longValue()));
    }

    public Map<Double, String> rangeByScore(String key, Long startSortIndex, Long endSortIndex) {
        return ConvertUtil.toMap(this.stringZSetOperations.rangeWithScores((Object)key, startSortIndex.longValue(), endSortIndex.longValue()));
    }

    public Map<Double, Object> rangeByScoreWithScoresAsObj(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.zSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, String> rangeByScoreWithScores(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.stringZSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, Object> rangeByScoreWithScoresAsObj(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.zSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Map<Double, String> rangeByScoreWithScores(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.stringZSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Set getAllAsObj(String key) {
        return this.ascRangeAsObj(key, 0L, -1L);
    }

    public Set<String> getAll(String key) {
        return this.ascRange(key, 0L, -1L);
    }

    public Map<Double, Object> getAllByScoreAsObj(String key) {
        return this.rangeByScoreAsObj(key, 0L, -1L);
    }

    public Map<Double, String> getAllByScore(String key) {
        return this.rangeByScore(key, 0L, -1L);
    }

    public Long sortIndexAsObj(String key, Object value) {
        return this.zSetOperations.rank((Object)key, value);
    }

    public Long sortIndex(String key, String value) {
        return this.stringZSetOperations.rank((Object)key, (Object)value);
    }

    public Double scoreAsObj(String key, Object value) {
        return this.zSetOperations.score((Object)key, value);
    }

    public Double score(String key, String value) {
        return this.stringZSetOperations.score((Object)key, (Object)value);
    }

    public Double incrementScoreAsObj(String key, Object value, Double score) {
        return this.zSetOperations.incrementScore((Object)key, value, score.doubleValue());
    }

    public Double incrementScore(String key, String value, Double score) {
        return this.stringZSetOperations.incrementScore((Object)key, (Object)value, score.doubleValue());
    }

    public Long removeAsObj(String key, Object ... values) {
        return this.zSetOperations.remove((Object)key, values);
    }

    public Long remove(String key, String ... values) {
        return this.stringZSetOperations.remove((Object)key, (Object[])values);
    }

    public Long ascRemoveRangeAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return this.zSetOperations.removeRange((Object)key, startSortIndex.longValue(), endSortIndex.longValue());
    }

    public Long ascRemoveRange(String key, Long startSortIndex, Long endSortIndex) {
        return this.stringZSetOperations.removeRange((Object)key, startSortIndex.longValue(), endSortIndex.longValue());
    }

    public Long descRemoveRangeAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return this.ascRemoveRangeAsObj(key, -endSortIndex.longValue() - 1L, -startSortIndex.longValue() - 1L);
    }

    public Long descRemoveRange(String key, Long startSortIndex, Long endSortIndex) {
        return this.ascRemoveRange(key, -endSortIndex.longValue() - 1L, -startSortIndex.longValue() - 1L);
    }

    public Long removeRangeByScoreAsObj(String key, Double min, Double max) {
        return this.zSetOperations.removeRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long removeRangeByScore(String key, Double min, Double max) {
        return this.stringZSetOperations.removeRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.zSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long intersectAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringZSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, String ... otherKys) {
        return this.zSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Long intersectAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.stringZSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.zSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long intersectAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, String ... otherKys) {
        return this.stringZSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Map<Double, Object> intersectByScoreAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStoreAsObj(key, tempKey, otherKys);
        Map<Double, Object> map = this.getAllByScoreAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return map;
    }

    public Map<Double, String> intersectByScore(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStore(key, tempKey, otherKys);
        Map<Double, String> map = this.getAllByScore(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return map;
    }

    public Set intersectAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStoreAsObj(key, tempKey, otherKys);
        Set set = this.getAllAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return set;
    }

    public Set<String> intersect(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStore(key, tempKey, otherKys);
        Set<String> set = this.getAll(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return set;
    }

    public Long unionAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.zSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long unionAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringZSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long unionAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, String ... otherKys) {
        return this.zSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Long unionAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.stringZSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long unionAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.zSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long unionAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, String ... otherKys) {
        return this.stringZSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Map<Double, Object> unionByScoreAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStoreAsObj(key, tempKey, otherKys);
        Map<Double, Object> map = this.getAllByScoreAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return map;
    }

    public Map<Double, String> unionByScore(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStore(key, tempKey, otherKys);
        Map<Double, String> map = this.getAllByScore(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return map;
    }

    public Set unionAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStore(key, tempKey, otherKys);
        Set set = this.getAllAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return set;
    }

    public Set<String> union(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStore(key, tempKey, otherKys);
        Set<String> set = this.getAll(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return set;
    }

    public Long reverseSortIndexAsObj(String key, Object value) {
        return this.zSetOperations.reverseRank((Object)key, value);
    }

    public Long reverseSortIndex(String key, String value) {
        return this.stringZSetOperations.reverseRank((Object)key, (Object)value);
    }

    public Set reverseRangeAsObj(String key, Long startIndex, Long endIndex) {
        return this.zSetOperations.reverseRange((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set<String> reverseRange(String key, Long startIndex, Long endIndex) {
        return this.stringZSetOperations.reverseRange((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set reverseRangeByScoreAsObj(String key, Double min, Double max) {
        return this.zSetOperations.reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Set<String> reverseRangeByScore(String key, Double min, Double max) {
        return this.stringZSetOperations.reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Map<Double, Object> reverseRangeByScoreAsObj(String key, Long startIndex, Long endIndex) {
        return ConvertUtil.toMap(this.zSetOperations.reverseRangeWithScores((Object)key, startIndex.longValue(), endIndex.longValue()));
    }

    public Map<Double, String> reverseRangeByScore(String key, Long startIndex, Long endIndex) {
        return ConvertUtil.toMap(this.stringZSetOperations.reverseRangeWithScores((Object)key, startIndex.longValue(), endIndex.longValue()));
    }

    public Map<Double, Object> reverseRangeByScoreWithScoresAsObj(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.zSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, String> reverseRangeByScoreWithScores(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.stringZSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, Object> reverseRangeByScoreWithScoresAsObj(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.zSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Map<Double, String> reverseRangeByScoreWithScores(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.stringZSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Cursor<ZSetOperations.TypedTuple<Object>> scanAsObj(String key, Long count, String pattern) {
        return this.zSetOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public Cursor<ZSetOperations.TypedTuple<String>> scan(String key, Long count, String pattern) {
        return this.stringZSetOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    private RedisZSetCommands.Range getRange(Long startSortIndex, boolean isContainsStart, Long endSortIndex, boolean isContainsEnd) {
        RedisZSetCommands.Range range = RedisZSetCommands.Range.range();
        if (isContainsStart) {
            range.gte((Object)startSortIndex);
        } else {
            range.gt((Object)startSortIndex);
        }
        if (isContainsEnd) {
            range.lte((Object)endSortIndex);
        } else {
            range.lt((Object)endSortIndex);
        }
        return range;
    }
}

