/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

public class ConvertUtil {
    public static byte[][] toByteArray(RedisSerializer serializer, String ... keys) {
        byte[][] bytes = new byte[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            bytes[i] = ConvertUtil.toBytes(serializer, keys[i]);
        }
        return bytes;
    }

    public static <K> byte[][] toByteArray(RedisSerializer keySerializer, RedisSerializer argsSerializer, List<K> keys, Object[] args) {
        Assert.notNull((Object)keySerializer, (String)"keySerializer must not be null");
        Assert.notNull((Object)argsSerializer, (String)"argsSerializer must not be null");
        int keySize = keys != null ? keys.size() : 0;
        byte[][] keysAndArgs = new byte[args.length + keySize][];
        int i = 0;
        if (keys != null) {
            for (Object key : keys) {
                if (key instanceof byte[]) {
                    keysAndArgs[i++] = (byte[])key;
                    continue;
                }
                keysAndArgs[i++] = keySerializer.serialize(key);
            }
        }
        for (Object arg : args) {
            keysAndArgs[i++] = arg instanceof byte[] ? (byte[])arg : argsSerializer.serialize(arg);
        }
        return keysAndArgs;
    }

    public static <T> Set<ZSetOperations.TypedTuple<T>> toTypedTupleSet(Map<Double, T> map) {
        if (map == null) {
            return null;
        }
        HashSet<ZSetOperations.TypedTuple<T>> set = new HashSet<ZSetOperations.TypedTuple<T>>(map.size());
        for (Map.Entry<Double, T> entry : map.entrySet()) {
            set.add((ZSetOperations.TypedTuple<T>)new DefaultTypedTuple(entry.getValue(), entry.getKey()));
        }
        return set;
    }

    public static <T> Map<T, Point> toMap(GeoResults<RedisGeoCommands.GeoLocation<T>> results) {
        HashMap<Object, Point> map;
        if (results != null) {
            map = new HashMap(results.getContent().size());
            for (GeoResult result : results) {
                map.put(((RedisGeoCommands.GeoLocation)result.getContent()).getName(), ((RedisGeoCommands.GeoLocation)result.getContent()).getPoint());
            }
        } else {
            map = new HashMap<Object, Point>(0);
        }
        return map;
    }

    public static <T> Map<Double, T> toMap(Set<ZSetOperations.TypedTuple<T>> set) {
        if (set == null) {
            return null;
        }
        LinkedHashMap<Double, Object> map = new LinkedHashMap<Double, Object>(set.size());
        for (ZSetOperations.TypedTuple<T> typedTuple : set) {
            map.put(typedTuple.getScore(), typedTuple.getValue());
        }
        return map;
    }

    public static <T> Map<Double, T> toMap(T ... values) {
        if (values == null) {
            return null;
        }
        HashMap<Double, T> map = new HashMap<Double, T>(values.length);
        for (int i = 0; i < values.length; ++i) {
            map.put(Double.valueOf(i), values[i]);
        }
        return map;
    }

    public static byte[] toBytes(RedisSerializer serializer, Object value) {
        Assert.notNull((Object)serializer, (String)"serializer must not be null");
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return serializer.serialize(value);
    }

    public static String toStr(RedisSerializer serializer, byte[] bytes) {
        Assert.notNull((Object)serializer, (String)"serializer must not be null");
        Object o = serializer.deserialize(bytes);
        return o == null ? null : o.toString();
    }
}

