/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DecimalType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class BigDecimalSerializer
extends AbstractSerializer<BigDecimal> {
    private static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();

    public static BigDecimalSerializer get() {
        return INSTANCE;
    }

    @Override
    public BigDecimal fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return (BigDecimal)DecimalType.instance.compose(byteBuffer.duplicate());
    }

    @Override
    public ByteBuffer toByteBuffer(BigDecimal obj) {
        return DecimalType.instance.decompose((Object)obj);
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.DECIMALTYPE;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return DecimalType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return DecimalType.instance.getString(byteBuffer.duplicate());
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        throw new RuntimeException("Not supported");
    }
}

