/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.SpecificCompositeSerializer;
import com.netflix.astyanax.serializers.SpecificReversedSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UnknownComparatorException;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ReversedType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ShadedTypeParser;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SerializerPackageImpl
implements SerializerPackage {
    private static final Serializer<?> DEFAULT_SERIALIZER = BytesArraySerializer.get();
    public static final SerializerPackage DEFAULT_SERIALIZER_PACKAGE = new SerializerPackageImpl();
    private Serializer<?> keySerializer;
    private Serializer<?> columnSerializer;
    private Serializer<?> defaultValueSerializer;
    private final Map<ByteBuffer, Serializer<?>> valueSerializers;

    public SerializerPackageImpl() {
        this.keySerializer = DEFAULT_SERIALIZER;
        this.columnSerializer = DEFAULT_SERIALIZER;
        this.defaultValueSerializer = DEFAULT_SERIALIZER;
        this.valueSerializers = new HashMap();
    }

    public SerializerPackageImpl(ColumnFamilyDefinition cfDef, boolean ignoreErrors) throws UnknownComparatorException {
        block12: {
            block11: {
                block10: {
                    this.keySerializer = DEFAULT_SERIALIZER;
                    this.columnSerializer = DEFAULT_SERIALIZER;
                    this.defaultValueSerializer = DEFAULT_SERIALIZER;
                    this.valueSerializers = new HashMap();
                    try {
                        this.setKeyType(cfDef.getKeyValidationClass());
                    }
                    catch (UnknownComparatorException e) {
                        if (ignoreErrors) break block10;
                        throw e;
                    }
                }
                try {
                    this.setColumnType(cfDef.getComparatorType());
                }
                catch (UnknownComparatorException e) {
                    if (ignoreErrors) break block11;
                    throw e;
                }
            }
            try {
                this.setDefaultValueType(cfDef.getDefaultValidationClass());
            }
            catch (UnknownComparatorException e) {
                if (ignoreErrors) break block12;
                throw e;
            }
        }
        List<ColumnDefinition> colsDefs = cfDef.getColumnDefinitionList();
        if (colsDefs != null) {
            for (ColumnDefinition colDef : colsDefs) {
                try {
                    this.setValueType(colDef.getRawName(), colDef.getValidationClass());
                }
                catch (UnknownComparatorException e) {
                    if (ignoreErrors) continue;
                    throw e;
                }
            }
        }
    }

    public SerializerPackageImpl setKeyType(String keyType) throws UnknownComparatorException {
        String comparatorType = StringUtils.substringBefore((String)keyType, (String)"(");
        ComparatorType type = ComparatorType.getByClassName(comparatorType);
        if (type == null) {
            throw new UnknownComparatorException(keyType);
        }
        if (type == ComparatorType.COMPOSITETYPE) {
            try {
                this.keySerializer = new SpecificCompositeSerializer((CompositeType)ShadedTypeParser.parse(keyType));
                return this;
            }
            catch (Exception exception) {
                throw new UnknownComparatorException(keyType);
            }
        }
        if (type == ComparatorType.DYNAMICCOMPOSITETYPE) {
            throw new UnknownComparatorException(keyType);
        }
        if (type == ComparatorType.REVERSEDTYPE) {
            try {
                this.keySerializer = new SpecificReversedSerializer((ReversedType)ShadedTypeParser.parse(keyType));
                return this;
            }
            catch (Exception exception) {
                throw new UnknownComparatorException(keyType);
            }
        }
        this.keySerializer = type.getSerializer();
        return this;
    }

    public SerializerPackageImpl setKeySerializer(Serializer<?> serializer) {
        this.keySerializer = serializer;
        return this;
    }

    @Deprecated
    public SerializerPackageImpl setColumnType(String columnType) throws UnknownComparatorException {
        return this.setColumnNameType(columnType);
    }

    public SerializerPackageImpl setColumnNameType(String columnType) throws UnknownComparatorException {
        String comparatorType = StringUtils.substringBefore((String)(columnType = ComparatorType.getShadedClassName(columnType)), (String)"(");
        ComparatorType type = ComparatorType.getByClassName(comparatorType);
        if (type == null) {
            throw new UnknownComparatorException(columnType);
        }
        if (type == ComparatorType.COMPOSITETYPE) {
            try {
                this.columnSerializer = new SpecificCompositeSerializer((CompositeType)ShadedTypeParser.parse(columnType));
                return this;
            }
            catch (Exception exception) {
                throw new UnknownComparatorException(columnType);
            }
        }
        if (type == ComparatorType.DYNAMICCOMPOSITETYPE) {
            throw new UnknownComparatorException(columnType);
        }
        if (type == ComparatorType.REVERSEDTYPE) {
            try {
                this.columnSerializer = new SpecificReversedSerializer((ReversedType)ShadedTypeParser.parse(columnType));
                return this;
            }
            catch (Exception exception) {
                throw new UnknownComparatorException(columnType);
            }
        }
        this.columnSerializer = type.getSerializer();
        return this;
    }

    public SerializerPackageImpl setColumnNameSerializer(Serializer<?> serializer) {
        this.columnSerializer = serializer;
        return this;
    }

    public SerializerPackageImpl setDefaultValueType(String valueType) throws UnknownComparatorException {
        ComparatorType type = ComparatorType.getByClassName(valueType);
        if (type == null) {
            throw new UnknownComparatorException(valueType);
        }
        this.defaultValueSerializer = type.getSerializer();
        return this;
    }

    public SerializerPackageImpl setDefaultValueSerializer(Serializer<?> serializer) {
        this.defaultValueSerializer = serializer;
        return this;
    }

    public SerializerPackageImpl setValueType(String columnName, String type) throws UnknownComparatorException {
        this.setValueType(StringSerializer.get().toByteBuffer(columnName), type);
        return this;
    }

    public SerializerPackageImpl setValueType(ByteBuffer columnName, String valueType) throws UnknownComparatorException {
        ComparatorType type = ComparatorType.getByClassName(valueType);
        if (type == null) {
            throw new UnknownComparatorException(valueType);
        }
        this.valueSerializers.put(columnName, type.getSerializer());
        return this;
    }

    public SerializerPackageImpl setValueSerializer(String columnName, Serializer<?> serializer) {
        this.valueSerializers.put(StringSerializer.get().toByteBuffer(columnName), serializer);
        return this;
    }

    public SerializerPackageImpl setValueSerializer(ByteBuffer columnName, Serializer<?> serializer) {
        this.valueSerializers.put(columnName, serializer);
        return this;
    }

    @Override
    public Serializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    @Deprecated
    public Serializer<?> getColumnSerializer() {
        return this.getColumnNameSerializer();
    }

    @Override
    public Serializer<?> getColumnNameSerializer() {
        return this.columnSerializer;
    }

    @Override
    @Deprecated
    public Serializer<?> getValueSerializer(ByteBuffer columnName) {
        return this.getColumnSerializer(columnName);
    }

    @Override
    public Serializer<?> getColumnSerializer(ByteBuffer columnName) {
        if (this.valueSerializers == null) {
            return this.defaultValueSerializer;
        }
        Serializer<?> ser = this.valueSerializers.get(columnName);
        if (ser == null) {
            return this.defaultValueSerializer;
        }
        return ser;
    }

    @Override
    public Serializer<?> getColumnSerializer(String columnName) {
        return this.getValueSerializer(StringSerializer.get().toByteBuffer(columnName));
    }

    @Override
    @Deprecated
    public Serializer<?> getValueSerializer(String columnName) {
        return this.getColumnSerializer(columnName);
    }

    @Override
    public Set<ByteBuffer> getColumnNames() {
        HashSet<ByteBuffer> set = new HashSet<ByteBuffer>();
        if (this.valueSerializers != null) {
            for (Map.Entry<ByteBuffer, Serializer<?>> entry : this.valueSerializers.entrySet()) {
                set.add(entry.getKey().duplicate());
            }
        }
        return set;
    }

    @Override
    @Deprecated
    public Serializer<?> getValueSerializer() {
        return this.getDefaultValueSerializer();
    }

    @Override
    public Serializer<?> getDefaultValueSerializer() {
        return this.defaultValueSerializer;
    }

    @Override
    public String keyAsString(ByteBuffer key) {
        return this.keySerializer.getString(key);
    }

    @Override
    public String columnAsString(ByteBuffer column) {
        return this.columnSerializer.getString(column);
    }

    @Override
    public String valueAsString(ByteBuffer column, ByteBuffer value) {
        Serializer<?> serializer = this.valueSerializers.get(column);
        if (serializer == null) {
            return this.defaultValueSerializer.getString(value);
        }
        return serializer.getString(value);
    }

    @Override
    public ByteBuffer keyAsByteBuffer(String key) {
        return this.keySerializer.fromString(key);
    }

    @Override
    public ByteBuffer columnAsByteBuffer(String column) {
        return this.columnSerializer.fromString(column);
    }

    @Override
    public ByteBuffer valueAsByteBuffer(ByteBuffer column, String value) {
        Serializer<?> serializer = this.valueSerializers.get(column);
        if (serializer == null) {
            return this.defaultValueSerializer.fromString(value);
        }
        return serializer.fromString(value);
    }

    @Override
    public ByteBuffer valueAsByteBuffer(String column, String value) {
        return this.valueAsByteBuffer(this.columnSerializer.fromString(column), value);
    }
}

