/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUploadInterceptor
implements Interceptor {
    private static final long serialVersionUID = 3475785630497636730L;
    protected static final Log log = LogFactory.getLog((Class)FileUploadInterceptor.class);
    private static final String DEFAULT_DELIMITER = ",";
    private static final String DEFAULT_MESSAGE = "no.message.found";
    protected Long maximumSize;
    protected String allowedTypes;
    protected Set allowedTypesSet = Collections.EMPTY_SET;

    public void setAllowedTypes(String allowedTypes) {
        this.allowedTypes = allowedTypes;
        this.allowedTypesSet = this.getDelimitedValues(allowedTypes);
    }

    public void setMaximumSize(Long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        MultiPartRequestWrapper multiWrapper;
        ActionContext ac = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ac.get((Object)"com.opensymphony.xwork.dispatcher.HttpServletRequest");
        if (!(request instanceof MultiPartRequestWrapper)) {
            if (log.isDebugEnabled()) {
                ActionProxy proxy = invocation.getProxy();
                log.debug((Object)this.getTextMessage("webwork.messages.bypass.request", new Object[]{proxy.getNamespace(), proxy.getActionName()}, ActionContext.getContext().getLocale()));
            }
            return invocation.invoke();
        }
        Object action = invocation.getAction();
        ValidationAware validation = null;
        if (action instanceof ValidationAware) {
            validation = (ValidationAware)action;
        }
        if ((multiWrapper = (MultiPartRequestWrapper)request).hasErrors()) {
            Iterator errorIter = multiWrapper.getErrors().iterator();
            while (errorIter.hasNext()) {
                String error = (String)errorIter.next();
                if (validation != null) {
                    validation.addActionError(error);
                }
                log.error((Object)error);
            }
        }
        Map parameters = ac.getParameters();
        Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            String inputName = (String)fileParameterNames.nextElement();
            Object[] contentType = multiWrapper.getContentTypes(inputName);
            if (this.isNonEmpty(contentType)) {
                Object[] fileName = multiWrapper.getFileNames(inputName);
                if (this.isNonEmpty(fileName)) {
                    File[] files = multiWrapper.getFiles(inputName);
                    if (files == null) continue;
                    for (int index = 0; index < files.length; ++index) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)this.getTextMessage("webwork.messages.current.file", new Object[]{inputName, contentType[index], fileName[index], files[index]}, ActionContext.getContext().getLocale()));
                        }
                        if (!this.acceptFile(files[index], (String)contentType[index], inputName, validation, ac.getLocale())) continue;
                        parameters.put(inputName, files);
                        parameters.put(inputName + "ContentType", contentType);
                        parameters.put(inputName + "FileName", fileName);
                    }
                    continue;
                }
                log.error((Object)this.getTextMessage("webwork.messages.invalid.file", new Object[]{inputName}, ActionContext.getContext().getLocale()));
                continue;
            }
            log.error((Object)this.getTextMessage("webwork.messages.invalid.content.type", new Object[]{inputName}, ActionContext.getContext().getLocale()));
        }
        String result = invocation.invoke();
        fileParameterNames = multiWrapper.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            String inputValue = (String)fileParameterNames.nextElement();
            File[] file = multiWrapper.getFiles(inputValue);
            for (int index = 0; index < file.length; ++index) {
                File currentFile = file[index];
                log.info((Object)this.getTextMessage("webwork.messages.removing.file", new Object[]{inputValue, currentFile}, ActionContext.getContext().getLocale()));
                if (currentFile == null || !currentFile.isFile()) continue;
                currentFile.delete();
            }
        }
        return result;
    }

    protected boolean acceptFile(File file, String contentType, String inputName, ValidationAware validation, Locale locale) {
        boolean fileIsAcceptable = false;
        if (file == null) {
            String errMsg = this.getTextMessage("webwork.messages.error.uploading", new Object[]{inputName}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            log.error((Object)errMsg);
        } else if (this.maximumSize != null && this.maximumSize < file.length()) {
            String errMsg = this.getTextMessage("webwork.messages.error.file.too.large", new Object[]{inputName, file.getName(), "" + file.length()}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            log.error((Object)errMsg);
        } else if (!this.allowedTypesSet.isEmpty() && !this.containsItem(this.allowedTypesSet, contentType)) {
            String errMsg = this.getTextMessage("webwork.messages.error.content.type.not.allowed", new Object[]{inputName, file.getName(), contentType}, locale);
            if (validation != null) {
                validation.addFieldError(inputName, errMsg);
            }
            log.error((Object)errMsg);
        } else {
            fileIsAcceptable = true;
        }
        return fileIsAcceptable;
    }

    protected boolean containsItem(Collection itemCollection, String key) {
        return itemCollection.contains(key.toLowerCase());
    }

    protected Set getDelimitedValues(String delimitedString) {
        HashSet<String> delimitedValues = new HashSet<String>();
        if (delimitedString != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(delimitedString, DEFAULT_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String nextToken = stringTokenizer.nextToken().toLowerCase().trim();
                if (nextToken.length() <= 0) continue;
                delimitedValues.add(nextToken);
            }
        }
        return delimitedValues;
    }

    protected boolean isNonEmpty(Object[] objArray) {
        boolean result = false;
        for (int index = 0; index < objArray.length && !result; ++index) {
            if (objArray[index] == null) continue;
            result = true;
        }
        return result;
    }

    protected String getTextMessage(String messageKey, Object[] args, Locale locale) {
        if (args == null || args.length == 0) {
            return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)locale);
        }
        return LocalizedTextUtil.findText(this.getClass(), (String)messageKey, (Locale)locale, (String)DEFAULT_MESSAGE, (Object[])args);
    }
}

