/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitegraph.model;

import com.opensymphony.webwork.sitegraph.model.IndentWriter;
import com.opensymphony.webwork.sitegraph.model.Render;
import com.opensymphony.webwork.sitegraph.model.SiteGraphNode;
import java.io.IOException;

public class Link
implements Render,
Comparable {
    public static final int TYPE_FORM = 0;
    public static final int TYPE_ACTION = 1;
    public static final int TYPE_HREF = 2;
    public static final int TYPE_RESULT = 3;
    public static final int TYPE_REDIRECT = 4;
    private SiteGraphNode from;
    private SiteGraphNode to;
    private int type;
    private String label;

    public Link(SiteGraphNode from, SiteGraphNode to, int type, String label) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.label = label;
    }

    public void render(IndentWriter writer) throws IOException {
        writer.write(this.from.getFullName() + " -> " + this.to.getFullName() + " [label=\"" + this.getRealLabel() + "\"" + this.getColor() + "];");
    }

    private String getRealLabel() {
        switch (this.type) {
            case 1: {
                return "action" + this.label;
            }
            case 0: {
                return "form" + this.label;
            }
            case 2: {
                return "href" + this.label;
            }
            case 4: {
                return "redirect: " + this.label;
            }
            case 3: {
                return this.label;
            }
        }
        return "";
    }

    private String getColor() {
        if (this.type == 3 || this.type == 1) {
            return ",color=\"darkseagreen2\"";
        }
        return "";
    }

    public int compareTo(Object o) {
        Link other = (Link)o;
        int result = this.from.compareTo(other.from);
        if (result != 0) {
            return result;
        }
        result = this.to.compareTo(other.to);
        if (result != 0) {
            return result;
        }
        result = this.label.compareTo(other.label);
        if (result != 0) {
            return result;
        }
        return new Integer(this.type).compareTo(new Integer(other.type));
    }
}

