/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader;

import com.opensymphony.webwork.util.classloader.ReloadingClassLoader;
import com.opensymphony.webwork.util.classloader.compilers.JavaCompiler;
import com.opensymphony.webwork.util.classloader.compilers.eclipse.EclipseJavaCompiler;
import com.opensymphony.webwork.util.classloader.listeners.CompilingListener;
import com.opensymphony.webwork.util.classloader.monitor.FilesystemAlterationMonitor;
import com.opensymphony.webwork.util.classloader.stores.MemoryResourceStore;
import com.opensymphony.webwork.util.classloader.stores.TransactionalResourceStore;
import com.uwyn.rife.continuations.ClassByteAware;
import java.io.File;

public class CompilingClassLoader
extends ReloadingClassLoader
implements ClassByteAware {
    private final TransactionalResourceStore transactionalStore;
    private final JavaCompiler compiler;

    public CompilingClassLoader(ClassLoader pParent, File pRepository) {
        this(pParent, pRepository, new TransactionalResourceStore(new MemoryResourceStore()){

            public void onStart() {
            }

            public void onStop() {
            }
        });
    }

    public CompilingClassLoader(ClassLoader pParent, File pRepository, TransactionalResourceStore pStore) {
        this(pParent, pRepository, pStore, new EclipseJavaCompiler());
    }

    public CompilingClassLoader(ClassLoader pParent, File pRepository, TransactionalResourceStore pStore, JavaCompiler pCompiler) {
        super(pParent, pRepository, pStore);
        this.transactionalStore = pStore;
        this.compiler = pCompiler;
    }

    public byte[] getClassBytes(String classname) throws ClassNotFoundException {
        return this.transactionalStore.read(classname);
    }

    public void start() {
        this.fam = new FilesystemAlterationMonitor();
        this.listener = new CompilingListener(this.reader, this.compiler, this.transactionalStore){

            public void reload() {
                super.reload();
                CompilingClassLoader.this.reload();
            }
        };
        this.fam.addListener(this.listener, this.repository);
        this.thread = new Thread(this.fam);
        this.fam.doRun();
        this.thread.start();
    }
}

