/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.iterator;

import com.opensymphony.webwork.util.IteratorGenerator;
import com.opensymphony.webwork.views.jsp.WebWorkBodyTagSupport;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IteratorGeneratorTag
extends WebWorkBodyTagSupport {
    private static final long serialVersionUID = 2968037295463973936L;
    public static final String DEFAULT_SEPARATOR = ",";
    private static final Log _log = LogFactory.getLog((Class)IteratorGeneratorTag.class);
    String countAttr;
    String separatorAttr;
    String valueAttr;
    String converterAttr;
    IteratorGenerator iteratorGenerator = null;

    public void setCount(String count) {
        this.countAttr = count;
    }

    public void setSeparator(String separator) {
        this.separatorAttr = separator;
    }

    public void setVal(String val) {
        this.valueAttr = val;
    }

    public void setConverter(String aConverter) {
        this.converterAttr = aConverter;
    }

    public void setId(String string) {
        super.setId(string);
    }

    public int doStartTag() throws JspException {
        Object value = this.findValue(this.valueAttr);
        String separator = DEFAULT_SEPARATOR;
        if (this.separatorAttr != null && this.separatorAttr.length() > 0) {
            separator = this.findString(this.separatorAttr);
        }
        int count = 0;
        if (this.countAttr != null && this.countAttr.length() > 0) {
            Object countObj = this.findValue(this.countAttr);
            if (countObj instanceof Integer) {
                count = (Integer)countObj;
            } else if (countObj instanceof Float) {
                count = ((Float)countObj).intValue();
            } else if (countObj instanceof Long) {
                count = ((Long)countObj).intValue();
            } else if (countObj instanceof Double) {
                count = ((Long)countObj).intValue();
            } else if (countObj instanceof String) {
                try {
                    count = Integer.parseInt((String)countObj);
                }
                catch (NumberFormatException e) {
                    _log.warn((Object)("unable to convert count attribute [" + countObj + "] to number, ignore count attribute"), (Throwable)e);
                }
            }
        }
        IteratorGenerator.Converter converter = null;
        if (this.converterAttr != null && this.converterAttr.length() > 0) {
            converter = (IteratorGenerator.Converter)this.findValue(this.converterAttr);
        }
        this.iteratorGenerator = new IteratorGenerator();
        this.iteratorGenerator.setValues(value);
        this.iteratorGenerator.setCount(count);
        this.iteratorGenerator.setSeparator(separator);
        this.iteratorGenerator.setConverter(converter);
        this.iteratorGenerator.execute();
        this.getStack().push((Object)this.iteratorGenerator);
        if (this.getId() != null && this.getId().length() > 0) {
            this.pageContext.setAttribute(this.getId(), (Object)this.iteratorGenerator);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        this.getStack().pop();
        this.iteratorGenerator = null;
        return 6;
    }
}

