/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.util.XMLUtils;
import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.views.xslt.AbstractAdapterElement;
import com.opensymphony.webwork.views.xslt.AdapterFactory;
import com.opensymphony.webwork.views.xslt.AdapterNode;
import com.opensymphony.webwork.views.xslt.SimpleTextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StringAdapter
extends AbstractAdapterElement {
    private Log log = LogFactory.getLog(this.getClass());
    boolean parseStringAsXML = false;

    public StringAdapter() {
    }

    public StringAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, String value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    protected String getStringValue() {
        return this.getPropertyValue().toString();
    }

    protected List buildChildAdapters() {
        Node node;
        if (this.getParseStringAsXML()) {
            this.log.debug((Object)("parsing string as xml: " + this.getStringValue()));
            try {
                node = XMLUtils.parse((String)this.getStringValue());
            }
            catch (ParserConfigurationException e) {
                throw new WebWorkException(e);
            }
            catch (IOException e) {
                throw new WebWorkException(e);
            }
            catch (SAXException e) {
                throw new WebWorkException(e);
            }
            node = this.getAdapterFactory().proxyNode(this, node);
        } else {
            this.log.debug((Object)("using string as is: " + this.getStringValue()));
            node = new SimpleTextNode(this.getAdapterFactory(), this, "text", this.getStringValue());
        }
        ArrayList<Document> children = new ArrayList<Document>();
        children.add((Document)node);
        return children;
    }

    public boolean getParseStringAsXML() {
        return this.parseStringAsXML;
    }

    public void setParseStringAsXML(boolean parseStringAsXML) {
        this.parseStringAsXML = parseStringAsXML;
    }
}

