/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.palantir.javaformat.java.Main;

final class UsageException
extends Exception {
    private static final Joiner NEWLINE_JOINER = Joiner.on((String)System.lineSeparator());
    private static final String[] DOCS_LINK = new String[]{"https://github.com/palantir/palantir-java-format"};
    private static final String[] USAGE = new String[]{"", "Usage: palantir-java-format [options] file(s)", "", "Options:", "  -i, -r, -replace, --replace", "    Send formatted output back to files, not stdout.", "  -", "    Format stdin -> stdout", "  --assume-filename, -assume-filename", "    File name to use for diagnostics when formatting standard input (default is <stdin>).", "  --aosp, -aosp, -a", "    Use AOSP style instead of Google Style (4-space indentation).", "  --fix-imports-only", "    Fix import order and remove any unused imports, but do no other formatting.", "  --skip-sorting-imports", "    Do not fix the import order. Unused imports will still be removed.", "  --skip-removing-unused-imports", "    Do not remove unused imports. Imports will still be sorted.", " . --skip-reflowing-long-strings", "    Do not reflow string literals that exceed the column limit.", "  --dry-run, -n", "    Prints the paths of the files whose contents would change if the formatter were run normally.", "  --set-exit-if-changed", "    Return exit code 1 if there are any formatting changes.", "  --lines, -lines, --line, -line", "    Line range(s) to format, like 5:10 (1-based; default is all).", "  --offset, -offset", "    Character offset to format (0-based; default is all).", "  --length, -length", "    Character length to format.", "  --help, -help, -h", "    Print this usage statement.", "  --version, -version, -v", "    Print the version.", "  @<filename>", "    Read options and filenames from file.", ""};
    private static final String[] ADDITIONAL_USAGE = new String[]{"If -i is given with -, the result is sent to stdout.", "The --lines, --offset, and --length flags may be given more than once.", "The --offset and --length flags must be given an equal number of times.", "If --lines, --offset, or --length are given, only one file (or -) may be given."};

    UsageException() {
        super(UsageException.buildMessage(null));
    }

    UsageException(String message) {
        super(UsageException.buildMessage((String)Preconditions.checkNotNull((Object)message)));
    }

    private static String buildMessage(String message) {
        StringBuilder builder = new StringBuilder();
        if (message != null) {
            builder.append(message).append('\n');
        }
        UsageException.appendLines(builder, USAGE);
        UsageException.appendLines(builder, ADDITIONAL_USAGE);
        UsageException.appendLines(builder, new String[]{""});
        UsageException.appendLine(builder, Main.versionString());
        UsageException.appendLines(builder, DOCS_LINK);
        return builder.toString();
    }

    private static void appendLine(StringBuilder builder, String line) {
        builder.append(line).append(System.lineSeparator());
    }

    private static void appendLines(StringBuilder builder, String[] lines) {
        NEWLINE_JOINER.appendTo(builder, (Object[])lines).append(System.lineSeparator());
    }
}

