/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.paas;

import com.a1bpm.model.ExtA1Attribute;
import com.a1bpm.model.ExtA1GlobalForm;
import com.a1bpm.model.ExtA1UserProperty;
import com.a1bpm.model.ExtA1UserRule;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pangu.paas.BpmnJsonConverterUtil;
import com.pangu.paas.ParseResult;
import com.pangu.paas.StencilConstants;
import com.pangu.paas.model.BaseElement;
import com.pangu.paas.model.FlowPermission;
import com.pangu.paas.model.FormField;
import com.pangu.paas.model.LeafNodeRelationship;
import com.pangu.paas.model.Process;
import com.pangu.paas.model.StartEvent;
import com.pangu.paas.model.WorkFlowDef;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLExtendConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.ExtA1Button;
import org.flowable.bpmn.model.ExtA1Properties;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.UserTask;

public class BpmnJsonConverter
implements StencilConstants {
    protected static ObjectMapper objectMapper = new ObjectMapper();
    public static Map<String, String> routeMap = new HashMap<String, String>();

    public static void main(String[] args) {
        try {
            InputStream route2 = BpmnJsonConverter.class.getClassLoader().getResourceAsStream("route1.json");
            ObjectNode editorJsonNode = (ObjectNode)objectMapper.readTree(route2);
            String tableId = BpmnJsonConverterUtil.getElementId((JsonNode)editorJsonNode);
            String workFlowVersionId = BpmnJsonConverterUtil.getPropertyValueAsString("workFlowVersionId", (JsonNode)editorJsonNode);
            Integer directorMaxLevel = BpmnJsonConverterUtil.getPropertyValueAsInteger("directorMaxLevel", (JsonNode)editorJsonNode);
            WorkFlowDef workFlowDef = BpmnJsonConverterUtil.getWorkFlowDef(editorJsonNode);
            List<FlowPermission> flowPermission = BpmnJsonConverterUtil.getFlowPermission(editorJsonNode);
            ParseResult readNode = BpmnJsonConverter.readNode((JsonNode)editorJsonNode, "aa", "askforleave", "a");
            System.out.println(readNode.getXml());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ParseResult conver(String json, String key, String formKey, String groupId) {
        ObjectNode editorJsonNode = null;
        ParseResult parseResult = null;
        try {
            editorJsonNode = (ObjectNode)objectMapper.readTree(json);
            String tableId = BpmnJsonConverterUtil.getElementId((JsonNode)editorJsonNode);
            String workFlowVersionId = BpmnJsonConverterUtil.getPropertyValueAsString("workFlowVersionId", (JsonNode)editorJsonNode);
            Integer directorMaxLevel = BpmnJsonConverterUtil.getPropertyValueAsInteger("directorMaxLevel", (JsonNode)editorJsonNode);
            WorkFlowDef workFlowDef = BpmnJsonConverterUtil.getWorkFlowDef(editorJsonNode);
            List<FlowPermission> flowPermission = BpmnJsonConverterUtil.getFlowPermission(editorJsonNode);
            parseResult = BpmnJsonConverter.readNode((JsonNode)editorJsonNode, key, formKey, groupId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parseResult;
    }

    private static ParseResult readNode(JsonNode objectNode, String key, String formKey, String groupId) throws UnsupportedEncodingException {
        routeMap.clear();
        if (objectNode.get("nodeConfig") != null) {
            BpmnModel bpmnModel = new BpmnModel();
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                ExtA1GlobalForm extA1GlobalForm = new ExtA1GlobalForm(UUID.randomUUID().toString(), formKey, formKey, "frame", "frame");
                bpmnModel.addExtA1GlobalForm(Collections.singletonList(extA1GlobalForm));
            }
            JsonNode nodeConfig = objectNode.get("nodeConfig");
            String pkId = BpmnJsonConverterUtil.getPropertyValueAsString("pkId", nodeConfig);
            StartEvent startEvent = new StartEvent(pkId);
            ArrayList<BaseElement> baseElementList = new ArrayList<BaseElement>();
            BaseElement parent = null;
            ArrayList<LeafNodeRelationship> leafNodeRelationshipList = new ArrayList<LeafNodeRelationship>();
            ArrayList<BaseElement> leafList = new ArrayList<BaseElement>();
            HashMap<String, String> sequence = new HashMap<String, String>();
            ArrayList<FormField> formFields = new ArrayList<FormField>();
            BaseElement baseElementStartEvent = BpmnJsonConverter.readNodeCommonInfo(formFields, nodeConfig, parent, baseElementList, leafNodeRelationshipList, leafList, bpmnModel, sequence);
            BpmnJsonConverter.getMultipleLeaf(baseElementStartEvent, leafNodeRelationshipList, leafList);
            org.flowable.bpmn.model.Process process = new org.flowable.bpmn.model.Process();
            ArrayList<SequenceFlow> sequenceFlowList = new ArrayList<SequenceFlow>();
            BpmnJsonConverter.generateSequenceFlow(baseElementList, sequenceFlowList, process, sequence);
            BpmnJsonConverter.generateNode(baseElementList, sequenceFlowList, process, bpmnModel, formFields);
            BpmnJsonConverter.generateNodeLeafNodeRelationshipList(leafNodeRelationshipList, sequenceFlowList, process);
            process.setId(key);
            if (StringUtils.isNotEmpty((CharSequence)groupId)) {
                bpmnModel.setTargetNamespace(groupId);
            }
            bpmnModel.addProcess(process);
            BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
            bpmnLayout.execute();
            ParseResult parseResult = new ParseResult();
            BpmnXMLExtendConverter bpmnXMLConverter = new BpmnXMLExtendConverter();
            byte[] bytes = bpmnXMLConverter.convertToXML(bpmnModel);
            String xml = new String(bytes, "UTF-8");
            parseResult.setXml(xml);
            parseResult.setFormFields(formFields);
            return parseResult;
        }
        return null;
    }

    private static void getMultipleLeaf(BaseElement baseElement, List<LeafNodeRelationship> leafNodeRelationshipList, List<BaseElement> leafList) {
        List conditionNodes = baseElement.getConditionNodes();
    }

    public static BaseElement parentEnd(BaseElement from) {
        BaseElement parent = from.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getType() != 4 && parent.getChildNode() != null) {
            return BpmnJsonConverter.parentEnd(parent);
        }
        return parent;
    }

    private static void generateNodeLeafNodeRelationshipList(List<LeafNodeRelationship> leafNodeRelationshipList, List<SequenceFlow> sequenceFlowList, org.flowable.bpmn.model.Process process) {
        if (leafNodeRelationshipList.size() > 0) {
            leafNodeRelationshipList.forEach(leafNodeRelationship -> {
                BaseElement from = leafNodeRelationship.getFrom();
                BaseElement to = leafNodeRelationship.getTo();
                String condition = leafNodeRelationship.getCondition();
                BaseElement childNode = from.getChildNode();
                String endId = "sid-" + UUID.randomUUID().toString().replaceAll("-", "");
                String sequenceFlowId = "sid-" + UUID.randomUUID().toString().replaceAll("-", "");
                if (childNode == null) {
                    BaseElement parentEnd = BpmnJsonConverter.parentEnd(from);
                    if (parentEnd == null) {
                        boolean isEnd = BpmnJsonConverter.isEnd(process, from);
                        if (from.getConditionNodes().size() == 0 && !isEnd) {
                            SequenceFlow sequenceFlow = new SequenceFlow();
                            sequenceFlow.setId(sequenceFlowId);
                            sequenceFlow.setSourceRef(from.getId());
                            sequenceFlow.setTargetRef(endId);
                            if (StringUtils.isNotEmpty((CharSequence)condition)) {
                                sequenceFlow.setConditionExpression(condition);
                            }
                            FlowNode flowNode = (FlowNode)process.getFlowElement(from.getId());
                            flowNode.getOutgoingFlows().add(sequenceFlow);
                            EndEvent endEvent = new EndEvent();
                            endEvent.setId(endId);
                            endEvent.getIncomingFlows().add(sequenceFlow);
                            process.addFlowElement((FlowElement)endEvent);
                            process.addFlowElement((FlowElement)sequenceFlow);
                        }
                    } else {
                        if (from.getConditionNodes().size() == 0) {
                            // empty if block
                        }
                        BaseElement parentEndChildNode = parentEnd.getChildNode();
                        BaseElement parent = from.getParent();
                        boolean flagBack = false;
                        if (parentEndChildNode == null) {
                            parent = BpmnJsonConverter.parentEnd(from);
                        } else if (parent.getId().equals(parentEndChildNode.getId())) {
                            parentEnd = from;
                            flagBack = true;
                            BpmnJsonConverter.end(process, from, endId, sequenceFlowId);
                        } else {
                            FlowNode flowNode;
                            SequenceFlow sequenceFlow;
                            if (parentEnd == null) {
                                sequenceFlow = new SequenceFlow();
                                sequenceFlow.setId(sequenceFlowId);
                                sequenceFlow.setSourceRef(from.getId());
                                sequenceFlow.setTargetRef(endId);
                                flowNode = (FlowNode)process.getFlowElement(from.getId());
                                flowNode.getOutgoingFlows().add(sequenceFlow);
                                EndEvent endEvent = new EndEvent();
                                endEvent.setId(endId);
                                endEvent.getIncomingFlows().add(sequenceFlow);
                                process.addFlowElement((FlowElement)sequenceFlow);
                                process.addFlowElement((FlowElement)endEvent);
                            }
                            if (to.getType() != 3 && parentEnd != null) {
                                sequenceFlow = new SequenceFlow();
                                sequenceFlow.setId(sequenceFlowId);
                                sequenceFlow.setSourceRef(to.getId());
                                sequenceFlow.setTargetRef(parentEnd.getChildNode().getId());
                                flowNode = (FlowNode)process.getFlowElement(to.getId());
                                flowNode.getOutgoingFlows().add(sequenceFlow);
                                process.addFlowElement((FlowElement)sequenceFlow);
                            }
                        }
                    }
                } else if (to.getType() == 3) {
                    SequenceFlow sequenceFlow = new SequenceFlow();
                    sequenceFlow.setId(sequenceFlowId);
                    sequenceFlow.setSourceRef(from.getId());
                    sequenceFlow.setTargetRef(childNode.getId());
                    process.addFlowElement((FlowElement)sequenceFlow);
                    FlowNode flowNode = (FlowNode)process.getFlowElement(from.getId());
                    flowNode.getOutgoingFlows().add(sequenceFlow);
                } else {
                    FlowNode flowNode;
                    if (to.getType() == 4) {
                        List conditionNodes = to.getConditionNodes();
                        String id = to.getId();
                        flowNode = (FlowNode)process.getFlowElement(id);
                        List outgoingFlows = flowNode.getOutgoingFlows();
                        if (outgoingFlows.size() != conditionNodes.size()) {
                            // empty if block
                        }
                    }
                    boolean isRight = BpmnJsonConverter.isRight(to, childNode);
                    SequenceFlow sequenceFlow = new SequenceFlow();
                    sequenceFlow.setId(sequenceFlowId);
                    sequenceFlow.setSourceRef(to.getId());
                    sequenceFlow.setTargetRef(childNode.getId());
                    flowNode = (FlowNode)process.getFlowElement(to.getId());
                    flowNode.getOutgoingFlows().add(sequenceFlow);
                    process.addFlowElement((FlowElement)sequenceFlow);
                    if (isRight) {
                        // empty if block
                    }
                }
            });
        }
    }

    private static boolean isEnd(org.flowable.bpmn.model.Process process, BaseElement from) {
        List outgoingFlows;
        boolean isEnd = false;
        FlowNode existFlowNode = (FlowNode)process.getFlowElement(from.getId());
        if (existFlowNode != null && (outgoingFlows = existFlowNode.getOutgoingFlows()).size() > 0) {
            for (SequenceFlow outgoing : outgoingFlows) {
                String targetRef = outgoing.getTargetRef();
                FlowElement targetFlowElement = process.getFlowElement(targetRef, true);
                if (!(targetFlowElement instanceof EndEvent)) continue;
                isEnd = true;
                break;
            }
        }
        return isEnd;
    }

    private static void end(org.flowable.bpmn.model.Process process, BaseElement from, String endId, String sequenceFlowId) {
        boolean isEnd = BpmnJsonConverter.isEnd(process, from);
        if (!isEnd) {
            SequenceFlow sequenceFlow = new SequenceFlow();
            sequenceFlow.setId(sequenceFlowId);
            sequenceFlow.setSourceRef(from.getId());
            sequenceFlow.setTargetRef(endId);
            FlowNode flowNode = (FlowNode)process.getFlowElement(from.getId());
            flowNode.getOutgoingFlows().add(sequenceFlow);
            EndEvent endEvent = new EndEvent();
            endEvent.setId(endId);
            endEvent.getIncomingFlows().add(sequenceFlow);
            process.addFlowElement((FlowElement)sequenceFlow);
            process.addFlowElement((FlowElement)endEvent);
        }
    }

    private static boolean isRight(BaseElement to, BaseElement childNode) {
        boolean isRight = false;
        if (to.getType() == 4) {
            List conditionNodes = to.getConditionNodes();
            ArrayList all = new ArrayList();
            conditionNodes.forEach(conditionNode -> {
                BaseElement childNode1 = conditionNode.getChildNode();
                BpmnJsonConverter.serachChildNode(childNode1, all);
            });
            List collect = conditionNodes.stream().map(BaseElement::getId).collect(Collectors.toList());
            if (collect.contains(childNode.getId())) {
                isRight = true;
            }
        }
        return isRight;
    }

    public static void serachChildNode(BaseElement baseElement, List<BaseElement> conditionNodes) {
        if (baseElement != null) {
            conditionNodes.add(baseElement);
            BaseElement childNode = baseElement.getChildNode();
            BpmnJsonConverter.serachChildNode(childNode, conditionNodes);
        }
    }

    private static void generateNode(List<BaseElement> baseElementList, List<SequenceFlow> sequenceFlowList, org.flowable.bpmn.model.Process process, BpmnModel bpmnModel, List<FormField> formFields) {
        baseElementList.forEach(el -> {
            Integer type = el.getType();
            String id = el.getId();
            Map sourceRefMap = sequenceFlowList.stream().collect(Collectors.groupingBy(SequenceFlow::getSourceRef, Collectors.toList()));
            Map targetRefMap = sequenceFlowList.stream().collect(Collectors.groupingBy(SequenceFlow::getTargetRef, Collectors.toList()));
            List sourceRefSequenceFlow = sourceRefMap.get(id);
            List targetRefSequenceFlow = targetRefMap.get(id);
            String nodeName = el.getNodeName();
            org.flowable.bpmn.model.StartEvent flowNode = null;
            switch (type) {
                case 0: {
                    flowNode = new org.flowable.bpmn.model.StartEvent();
                    break;
                }
                case 1: {
                    flowNode = new UserTask();
                    break;
                }
                case 2: {
                    flowNode = new ServiceTask();
                    ServiceTask serviceTask = (ServiceTask)flowNode;
                    serviceTask.setImplementationType("delegateExpression");
                    serviceTask.setImplementation("#{customServiceTaskV4}");
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    flowNode = new ExclusiveGateway();
                    break;
                }
            }
            if (flowNode != null) {
                ExtA1Button extA1Button1 = new ExtA1Button();
                flowNode.setId(id);
                flowNode.setName(nodeName);
                if (targetRefSequenceFlow != null) {
                    flowNode.getIncomingFlows().addAll(targetRefSequenceFlow);
                }
                if (sourceRefSequenceFlow != null) {
                    flowNode.getOutgoingFlows().addAll(sourceRefSequenceFlow);
                }
                process.addFlowElement((FlowElement)flowNode);
            }
        });
    }

    private static void generateSequenceFlow(List<BaseElement> baseElementList, List<SequenceFlow> sequenceFlowList, org.flowable.bpmn.model.Process process, Map<String, String> sequence) {
        List<BaseElement> notGateway = baseElementList.stream().filter(baseElement -> baseElement.getType() != 4 && baseElement.getType() != 3).collect(Collectors.toList());
        notGateway.forEach(el -> {
            String id = el.getId();
            String nodeName = el.getNodeName();
            if (el.getChildNode() != null) {
                BaseElement childNode = el.getChildNode();
                SequenceFlow sequenceFlow = new SequenceFlow();
                sequenceFlow.setId(id + "_" + childNode.getId());
                sequenceFlow.setName(nodeName);
                sequenceFlow.setSourceRef(id);
                sequenceFlow.setTargetRef(childNode.getId());
                process.addFlowElement((FlowElement)sequenceFlow);
                sequenceFlowList.add(sequenceFlow);
            }
        });
        List<BaseElement> gateway = baseElementList.stream().filter(baseElement -> baseElement.getType() == 4).collect(Collectors.toList());
        if (gateway.size() > 0) {
            gateway.forEach(gateway3 -> {
                String sourceRef = gateway3.getId();
                List conditionNodes = gateway3.getConditionNodes();
                conditionNodes.forEach(child -> {
                    String id = child.getId();
                    if (child.getChildNode() != null) {
                        SequenceFlow sequenceFlow = new SequenceFlow();
                        sequenceFlow.setSourceRef(sourceRef);
                        BaseElement childNode = child.getChildNode();
                        String targetRef = childNode.getId();
                        sequenceFlow.setTargetRef(targetRef);
                        sequenceFlow.setId(sourceRef + "_" + targetRef);
                        if (sequence != null && sequence.size() > 0) {
                            if (sequence.get(targetRef) != null) {
                                String conditionExpression = BpmnJsonConverter.getCondition((String)sequence.get(targetRef));
                                sequenceFlow.setConditionExpression(conditionExpression);
                                if (StringUtils.isNotEmpty((CharSequence)child.getNodeName())) {
                                    sequenceFlow.setName(child.getNodeName());
                                }
                            } else {
                                String conditionExpression;
                                if (routeMap.get(targetRef) != null) {
                                    conditionExpression = BpmnJsonConverter.getCondition(routeMap.get(targetRef));
                                    sequenceFlow.setConditionExpression(conditionExpression);
                                }
                                if (childNode.getParent().getType() == 3 && StringUtils.isNotEmpty((CharSequence)childNode.getChildNode().getCondition())) {
                                    conditionExpression = BpmnJsonConverter.getCondition(childNode.getChildNode().getCondition());
                                    sequenceFlow.setConditionExpression(conditionExpression);
                                }
                            }
                        }
                        process.addFlowElement((FlowElement)sequenceFlow);
                        sequenceFlowList.add(sequenceFlow);
                    }
                });
            });
        }
    }

    private static String getCondition(String condition) {
        String conditionExpression = condition;
        if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
            conditionExpression = conditionExpression.replace("${ or", "${ ");
        }
        return conditionExpression;
    }

    private static BaseElement readNodeCommonInfo(List<FormField> formFields, JsonNode nodeConfig, BaseElement parent, List<BaseElement> baseElementList, List<LeafNodeRelationship> leafNodeRelationshipList, List<BaseElement> leafList, BpmnModel bpmnModel, Map<String, String> sequence) {
        Integer type = BpmnJsonConverterUtil.getPropertyValueAsInteger("type", nodeConfig);
        BaseElement baseElement = new BaseElement();
        BpmnJsonConverter.parseCommon(nodeConfig, baseElement, type);
        String nodeId = baseElement.getId();
        baseElement.setParent(parent);
        String nodeName = BpmnJsonConverterUtil.getPropertyValueAsString("nodeName", nodeConfig);
        String operate_type = BpmnJsonConverterUtil.getPropertyValueAsString("operateType", nodeConfig);
        JsonNode formFieldsJsonNode = nodeConfig.get("formFields");
        try {
            ArrayNode formFieldsArrayNode;
            if (formFields != null && (formFieldsArrayNode = (ArrayNode)formFieldsJsonNode) != null && formFieldsArrayNode.isArray()) {
                for (JsonNode jsonNode : formFieldsArrayNode) {
                    String description = jsonNode.get("description").asText();
                    String key = "";
                    if (jsonNode.get("key") != null) {
                        key = jsonNode.get("key").asText();
                    }
                    if (jsonNode.get("key") != null) {
                        key = jsonNode.get("fieldName").asText();
                    }
                    String typeStr = "";
                    if (jsonNode.get("type") != null) {
                        typeStr = jsonNode.get("type").asText();
                    }
                    String model = "";
                    if (jsonNode.get("model") != null) {
                        model = jsonNode.get("model").asText();
                    }
                    boolean read = jsonNode.get("read").asBoolean();
                    boolean write = jsonNode.get("write").asBoolean();
                    boolean hidden = jsonNode.get("hidden").asBoolean();
                    FormField formField = new FormField(nodeId, description, key, typeStr, model, read, write, hidden);
                    formFields.add(formField);
                }
            }
        }
        catch (Exception formFieldsArrayNode) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty((CharSequence)operate_type)) {
            ExtA1UserProperty extA1UserProperty = new ExtA1UserProperty();
            extA1UserProperty.setNodeId(nodeId);
            extA1UserProperty.setWindow(operate_type);
            bpmnModel.addExtA1UserProperty(extA1UserProperty);
        }
        ExtA1Properties extA1Properties = new ExtA1Properties();
        extA1Properties.setDescription(operate_type);
        bpmnModel.addExtA1Properties(extA1Properties);
        parent = baseElement;
        baseElementList.add(baseElement);
        if (nodeConfig.get("childNode") != null && !(nodeConfig.get("childNode") instanceof NullNode)) {
            JsonNode childNode = nodeConfig.get("childNode");
            BaseElement childNodeBaseElement = BpmnJsonConverter.readNodeCommonInfo(formFields, childNode, parent, baseElementList, leafNodeRelationshipList, leafList, bpmnModel, sequence);
            baseElement.setChildNode(childNodeBaseElement);
        }
        if (type != null) {
            List<ExtA1Attribute> flowExtNullUserRule = BpmnJsonConverterUtil.getFlowExtNullUserRule(nodeConfig, nodeId);
            if (flowExtNullUserRule.size() > 0) {
                flowExtNullUserRule.forEach(ft -> bpmnModel.addExtA1Attribute(ft));
            }
            switch (type) {
                case 0: {
                    break;
                }
                case 2: {
                    List<ExtA1UserRule> extA1UserServiceRulesList = BpmnJsonConverterUtil.getFlowExtServiceUserRule(nodeConfig, nodeId);
                    if (extA1UserServiceRulesList.size() <= 0) break;
                    extA1UserServiceRulesList.forEach(ft -> bpmnModel.addExtA1UserRule(ft));
                    break;
                }
                case 1: {
                    List<ExtA1UserRule> extA1UserRulesList;
                    List<ExtA1Button> flowExtButton = BpmnJsonConverterUtil.getFlowExtButton(nodeConfig, nodeId);
                    if (flowExtButton.size() > 0) {
                        flowExtButton.forEach(ft -> bpmnModel.addExtA1Buttons(ft));
                    }
                    if ((extA1UserRulesList = BpmnJsonConverterUtil.getFlowExtUserRule(nodeConfig, nodeId)).size() <= 0) break;
                    extA1UserRulesList.forEach(ft -> bpmnModel.addExtA1UserRule(ft));
                    break;
                }
                case 4: {
                    ArrayNode conditionNodes;
                    if (nodeConfig.get("conditionNodes") == null || !(conditionNodes = (ArrayNode)nodeConfig.get("conditionNodes")).isArray()) break;
                    for (JsonNode jsonNode : conditionNodes) {
                        int jsonNodeType = jsonNode.get("type").asInt();
                        if (jsonNodeType == 3 && jsonNode.get("childNode") != null && !(jsonNode.get("childNode") instanceof NullNode)) {
                            JsonNode childNode = jsonNode.get("childNode");
                            routeMap.put(childNode.get("id").asText(), BpmnJsonConverterUtil.converConditionList(jsonNode));
                        }
                        BaseElement baseElementconditionNodes = BpmnJsonConverter.readNodeCommonInfo(formFields, jsonNode, parent, baseElementList, leafNodeRelationshipList, leafList, bpmnModel, sequence);
                        baseElement.getConditionNodes().add(baseElementconditionNodes);
                        String converConditionList = BpmnJsonConverterUtil.converConditionList(jsonNode);
                        BaseElement leaf = BpmnJsonConverter.getLeaf(baseElementconditionNodes);
                        LeafNodeRelationship leafNodeRelationship = new LeafNodeRelationship();
                        leafNodeRelationship.setFrom(baseElement);
                        leafNodeRelationship.setTo(leaf);
                        sequence.put(leaf.getId(), converConditionList);
                        leaf.setCondition(converConditionList);
                        leafNodeRelationship.setCondition(converConditionList);
                        leafNodeRelationshipList.add(leafNodeRelationship);
                        if (leaf.getChildNode() == null && leaf.getConditionNodes().size() == 0 && leaf.getParent() != null && leaf.getParent().getChildNode() != null && leaf.getParent().getType() == 3 && leaf.getParent().getChildNode().getId() != null && leaf.getId().equals(leaf.getParent().getChildNode().getId())) {
                            leafList.add(leaf);
                        }
                        if (baseElement.getType() == 4 && leaf.getType() == 4) continue;
                    }
                    break;
                }
            }
        }
        return baseElement;
    }

    private static BaseElement getLeaf(BaseElement baseElement) {
        if (baseElement.getChildNode() != null) {
            return BpmnJsonConverter.getLeaf(baseElement.getChildNode());
        }
        return baseElement;
    }

    private static void childNode(JsonNode nodeConfig, BaseElement baseElement, List<BaseElement> baseElementList, List<BaseElement> containerElementList, boolean container) {
        if (baseElement.getType() != null) {
            if (!container) {
                baseElementList.add(baseElement);
            } else {
                containerElementList.add(baseElement);
            }
        }
        if (nodeConfig.get("childNode") != null) {
            JsonNode childNode = nodeConfig.get("childNode");
            BaseElement readNodeCommon = BpmnJsonConverter.readNodeCommon(childNode, null, baseElementList, null);
            baseElement.setChildNode(readNodeCommon);
            if (childNode.get("childNode") != null && !(childNode.get("childNode") instanceof NullNode)) {
                BaseElement childNodeBaseElement = new BaseElement();
                BpmnJsonConverter.childNode(childNode, childNodeBaseElement, baseElementList, containerElementList, container);
            }
        }
    }

    private static BaseElement readNodeCommon(JsonNode nodeConfig, BaseElement baseElement, List<BaseElement> baseElementList, List<BaseElement> containerElementList) {
        ArrayNode nodeUserListNode;
        if (baseElement == null) {
            baseElement = new BaseElement();
        }
        Integer type = BpmnJsonConverterUtil.getPropertyValueAsInteger("type", nodeConfig);
        String nodeName = BpmnJsonConverterUtil.getPropertyValueAsString("nodeName", nodeConfig);
        BpmnJsonConverter.parseCommon(nodeConfig, baseElement, type);
        if (type != null) {
            switch (type) {
                case 1: {
                    BpmnJsonConverter.childNode(nodeConfig, baseElement, baseElementList, containerElementList, false);
                    break;
                }
                case 4: {
                    ArrayNode conditionNodes;
                    String routeNodeName = BpmnJsonConverterUtil.getPropertyValueAsString("nodeName", nodeConfig);
                    Integer routeType = BpmnJsonConverterUtil.getPropertyValueAsInteger("type", nodeConfig);
                    BaseElement routeChildNode = new BaseElement();
                    routeChildNode.setNodeName(routeNodeName);
                    baseElementList.add(routeChildNode);
                    containerElementList = new ArrayList<BaseElement>();
                    if (nodeConfig.get("conditionNodes") != null && (conditionNodes = (ArrayNode)nodeConfig.get("conditionNodes")).isArray()) {
                        for (JsonNode jsonNode : conditionNodes) {
                            BaseElement jsonChildNode = BpmnJsonConverter.readNodeCommon(jsonNode, null, baseElementList, containerElementList);
                            BpmnJsonConverter.childNode(jsonNode, jsonChildNode, baseElementList, containerElementList, true);
                        }
                    }
                    routeChildNode.setConditionNodes(containerElementList);
                    BpmnJsonConverter.childNode(nodeConfig, routeChildNode, baseElementList, containerElementList, false);
                    break;
                }
            }
        }
        if (nodeConfig.get("nodeUserList") != null && (nodeUserListNode = (ArrayNode)nodeConfig.get("nodeUserList")).isArray()) {
            for (JsonNode jsonNode : nodeUserListNode) {
                if (jsonNode.get("name") == null) continue;
                int nodeUserType = jsonNode.get("type").asInt();
                String targetId = jsonNode.get("targetId").asText();
                String string = jsonNode.get("name").asText();
            }
        }
        return baseElement;
    }

    private static void parseCommon(JsonNode nodeConfig, BaseElement baseElement, Integer type) {
        String nodeName = BpmnJsonConverterUtil.getPropertyValueAsString("nodeName", nodeConfig);
        String id = BpmnJsonConverterUtil.getPropertyValueAsString("id", nodeConfig);
        String priorityLevel = BpmnJsonConverterUtil.getPropertyValueAsString("priorityLevel", nodeConfig);
        String settype = BpmnJsonConverterUtil.getPropertyValueAsString("settype", nodeConfig);
        String selectMode = BpmnJsonConverterUtil.getPropertyValueAsString("selectMode", nodeConfig);
        String selectRange = BpmnJsonConverterUtil.getPropertyValueAsString("selectRange", nodeConfig);
        String examineRoleId = BpmnJsonConverterUtil.getPropertyValueAsString("examineRoleId", nodeConfig);
        String directorLevel = BpmnJsonConverterUtil.getPropertyValueAsString("directorLevel", nodeConfig);
        String replaceByUp = BpmnJsonConverterUtil.getPropertyValueAsString("replaceByUp", nodeConfig);
        String examineMode = BpmnJsonConverterUtil.getPropertyValueAsString("examineMode", nodeConfig);
        String noHanderAction = BpmnJsonConverterUtil.getPropertyValueAsString("noHanderAction", nodeConfig);
        String examineEndType = BpmnJsonConverterUtil.getPropertyValueAsString("examineEndType", nodeConfig);
        String examineEndRoleId = BpmnJsonConverterUtil.getPropertyValueAsString("examineEndRoleId", nodeConfig);
        String examineEndDirectorLevel = BpmnJsonConverterUtil.getPropertyValueAsString("examineEndDirectorLevel", nodeConfig);
        String ccSelfSelectFlag = BpmnJsonConverterUtil.getPropertyValueAsString("ccSelfSelectFlag", nodeConfig);
        boolean error = BpmnJsonConverterUtil.getPropertyValueAsBoolean("error", nodeConfig);
        baseElement.setNodeName(nodeName);
        baseElement.setType(type);
        baseElement.setPriorityLevel(priorityLevel);
        baseElement.setSettype(settype);
        baseElement.setSelectMode(selectMode);
        baseElement.setSelectRange(selectRange);
        baseElement.setExamineRoleId(examineRoleId);
        baseElement.setDirectorLevel(directorLevel);
        baseElement.setReplaceByUp(replaceByUp);
        baseElement.setExamineMode(examineMode);
        baseElement.setNoHanderAction(noHanderAction);
        baseElement.setExamineEndType(examineEndType);
        baseElement.setExamineEndRoleId(examineEndRoleId);
        baseElement.setExamineEndDirectorLevel(examineEndDirectorLevel);
        baseElement.setCcSelfSelectFlag(ccSelfSelectFlag);
        baseElement.setId(id);
        baseElement.setError(error);
    }

    public Process convertToBpmnModel(JsonNode modelNode) {
        return null;
    }
}

