/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.paas;

import com.a1bpm.model.ExtA1Attribute;
import com.a1bpm.model.ExtA1UserRule;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pangu.paas.model.FlowPermission;
import com.pangu.paas.model.UserInfo;
import com.pangu.paas.model.WorkFlowDef;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ExtA1Button;

public class BpmnJsonConverterUtil {
    public static String getElementId(JsonNode objectNode) {
        String elementId = null;
        elementId = objectNode.get("tableId").asText();
        return elementId;
    }

    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = BpmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static Boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        Boolean propertyValue = false;
        JsonNode propertyNode = BpmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asBoolean();
        }
        return propertyValue;
    }

    public static Integer getPropertyValueAsInteger(String name, JsonNode objectNode) {
        Integer propertyValue = null;
        JsonNode propertyNode = BpmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asInt();
        }
        return propertyValue;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        Object propertyNode = null;
        JsonNode propertiesNode = objectNode.get(name);
        return propertiesNode;
    }

    public static WorkFlowDef getWorkFlowDef(ObjectNode objectNode) {
        JsonNode jsonNode = objectNode.get("workFlowDef");
        WorkFlowDef workFlowDef = null;
        if (jsonNode != null && jsonNode.get("name") != null) {
            String name = jsonNode.get("name").asText();
            int publicFlag = jsonNode.get("publicFlag").asInt();
            int sortNo = jsonNode.get("sortNo").asInt();
            int duplicateRemovelFlag = jsonNode.get("duplicateRemovelFlag").asInt();
            String optionTip = jsonNode.get("optionTip").asText();
            int optionNotNull = jsonNode.get("optionNotNull").asInt();
            int status = jsonNode.get("status").asInt();
            workFlowDef = new WorkFlowDef(name, optionTip, publicFlag, sortNo, duplicateRemovelFlag, optionNotNull, status);
        }
        return workFlowDef;
    }

    public static List<FlowPermission> getFlowPermission(ObjectNode objectNode) {
        ArrayNode arrNode = (ArrayNode)objectNode.get("flowPermission");
        ArrayList<FlowPermission> result = new ArrayList<FlowPermission>();
        if (arrNode.isArray()) {
            for (JsonNode jsonNode : arrNode) {
                if (jsonNode.get("name") == null) continue;
                int type = jsonNode.get("type").asInt();
                String targetId = jsonNode.get("targetId").asText();
                String name = jsonNode.get("name").asText();
                FlowPermission flowPermission = null;
                flowPermission = new FlowPermission(type, targetId, name);
                result.add(flowPermission);
            }
        }
        return result;
    }

    public static List<UserInfo> getFlowUserHandler(JsonNode objectNode) {
        ArrayList<UserInfo> result = new ArrayList<UserInfo>();
        ArrayNode arrNode = (ArrayNode)objectNode.get("nodeUserList");
        if (arrNode.isArray()) {
            for (JsonNode jsonNode : arrNode) {
                if (jsonNode.get("name") == null) continue;
                int type = jsonNode.get("type").asInt();
                String targetId = jsonNode.get("targetId").asText();
                String name = jsonNode.get("name").asText();
                String code = jsonNode.get("code").asText();
                UserInfo userInfo = new UserInfo(Integer.valueOf(type), targetId, name, code);
                result.add(userInfo);
            }
        }
        return result;
    }

    public static List<ExtA1Button> getFlowExtButton(JsonNode objectNode, String nodeId) {
        ArrayList<ExtA1Button> result = new ArrayList<ExtA1Button>();
        ArrayNode arrNode = (ArrayNode)objectNode.get("btnList");
        if (arrNode.isArray()) {
            for (JsonNode jsonNode : arrNode) {
                boolean enable;
                if (jsonNode.get("alias") == null || jsonNode.get("enable") == null || !(enable = jsonNode.get("enable").asBoolean(true))) continue;
                String alias = jsonNode.get("alias").asText();
                if (jsonNode.get("btnAlias") != null) {
                    String string = jsonNode.get("btnAlias").asText();
                }
                String btnName = jsonNode.get("btnName").asText();
                String cssName = jsonNode.get("cssName").asText();
                ExtA1Button extA1Button = new ExtA1Button(UUID.randomUUID().toString(), alias, btnName, nodeId, cssName);
                result.add(extA1Button);
            }
        }
        return result;
    }

    public static List<ExtA1UserRule> getFlowExtUserRule(JsonNode objectNode, String nodeId) {
        ArrayList<ExtA1UserRule> extA1UserRulesList = new ArrayList<ExtA1UserRule>();
        ArrayNode arrNode = (ArrayNode)objectNode.get("nodeUserList");
        if (arrNode.isArray()) {
            block22: for (JsonNode jsonNode : arrNode) {
                String ruleType;
                if (jsonNode.get("ruleType") == null) continue;
                switch (ruleType = jsonNode.get("ruleType").asText()) {
                    case "1": {
                        JsonNode role = jsonNode.get("role");
                        if (!role.isArray()) break;
                        for (JsonNode jsonNode_role : role) {
                            String jsonNode_role_code = jsonNode_role.asText();
                            ExtA1UserRule extA1UserRule = new ExtA1UserRule();
                            extA1UserRule.setId(UUID.randomUUID().toString());
                            extA1UserRule.setNodeId(nodeId);
                            extA1UserRule.setPluginType("role");
                            extA1UserRule.setLogicCal("or");
                            extA1UserRule.setSpecId(jsonNode_role_code);
                            extA1UserRulesList.add(extA1UserRule);
                        }
                        continue block22;
                    }
                    case "2": {
                        ArrayNode arrNodeUser = (ArrayNode)jsonNode.get("users");
                        if (arrNodeUser.size() > 0) {
                            BpmnJsonConverterUtil.getUser(nodeId, extA1UserRulesList, jsonNode);
                            break;
                        }
                        ExtA1UserRule depExtA1UserRule = new ExtA1UserRule();
                        depExtA1UserRule.setId(UUID.randomUUID().toString());
                        depExtA1UserRule.setNodeId(nodeId);
                        depExtA1UserRule.setPluginType("depId");
                        depExtA1UserRule.setRuleId("depId");
                        depExtA1UserRule.setSpecId("depId");
                        depExtA1UserRule.setLogicCal("or");
                        depExtA1UserRule.setPluginVal("depId");
                        extA1UserRulesList.add(depExtA1UserRule);
                        break;
                    }
                    case "5": {
                        ExtA1UserRule startA1UserRule = new ExtA1UserRule();
                        startA1UserRule.setId(UUID.randomUUID().toString());
                        startA1UserRule.setNodeId(nodeId);
                        startA1UserRule.setPluginType("start");
                        startA1UserRule.setRuleId("start");
                        startA1UserRule.setSpecId("start");
                        startA1UserRule.setLogicCal("or");
                        startA1UserRule.setPluginVal("start");
                        extA1UserRulesList.add(startA1UserRule);
                        break;
                    }
                    case "6": {
                        ExtA1UserRule first = new ExtA1UserRule();
                        first.setId(UUID.randomUUID().toString());
                        first.setNodeId(nodeId);
                        first.setPluginType("first");
                        first.setRuleId("");
                        first.setSpecId("");
                        first.setLogicCal("");
                        first.setPluginVal("");
                        extA1UserRulesList.add(first);
                        break;
                    }
                    case "7": {
                        ExtA1UserRule second = new ExtA1UserRule();
                        second.setId(UUID.randomUUID().toString());
                        second.setNodeId(nodeId);
                        second.setPluginType("second");
                        second.setRuleId("");
                        second.setSpecId("");
                        second.setLogicCal("");
                        second.setPluginVal("");
                        extA1UserRulesList.add(second);
                        break;
                    }
                    case "8": {
                        ExtA1UserRule xw = new ExtA1UserRule();
                        xw.setId(UUID.randomUUID().toString());
                        xw.setNodeId(nodeId);
                        xw.setPluginType("xw");
                        xw.setRuleId("");
                        xw.setSpecId("");
                        xw.setLogicCal("");
                        xw.setPluginVal("");
                        extA1UserRulesList.add(xw);
                        break;
                    }
                    case "9": {
                        ExtA1UserRule pt = new ExtA1UserRule();
                        pt.setId(UUID.randomUUID().toString());
                        pt.setNodeId(nodeId);
                        pt.setPluginType("xw");
                        pt.setRuleId("");
                        pt.setSpecId("");
                        pt.setLogicCal("");
                        pt.setPluginVal("");
                        extA1UserRulesList.add(pt);
                        break;
                    }
                    case "4": {
                        BpmnJsonConverterUtil.getUser(nodeId, extA1UserRulesList, jsonNode);
                        break;
                    }
                    case "3": {
                        ArrayNode arrNodeRole = (ArrayNode)jsonNode.get("role");
                        if (!arrNodeRole.isArray()) break;
                        for (JsonNode jsonNode_role : arrNodeRole) {
                            String jsonNode_role_code = jsonNode_role.asText();
                            ExtA1UserRule extA1UserRule = new ExtA1UserRule();
                            extA1UserRule.setId(UUID.randomUUID().toString());
                            extA1UserRule.setNodeId(nodeId);
                            extA1UserRule.setPluginType("role");
                            extA1UserRule.setLogicCal("or");
                            extA1UserRule.setSpecId(jsonNode_role_code);
                            extA1UserRulesList.add(extA1UserRule);
                        }
                        continue block22;
                    }
                }
            }
        }
        return extA1UserRulesList;
    }

    private static void getUser(String nodeId, List<ExtA1UserRule> extA1UserRulesList, JsonNode jsonNode) {
        ArrayNode arrNodeUser = (ArrayNode)jsonNode.get("users");
        if (arrNodeUser.isArray()) {
            for (JsonNode jsonNode_user : arrNodeUser) {
                String fullname = jsonNode_user.get("fullname").asText();
                String userNo = jsonNode_user.get("userNo").asText();
                ExtA1UserRule extA1UserRule = new ExtA1UserRule();
                extA1UserRule.setId(UUID.randomUUID().toString());
                extA1UserRule.setNodeId(nodeId);
                extA1UserRule.setPluginType("users");
                extA1UserRule.setRuleId("spec");
                extA1UserRule.setSpecId(userNo);
                extA1UserRule.setLogicCal("or");
                extA1UserRule.setPluginVal(fullname);
                extA1UserRulesList.add(extA1UserRule);
            }
        }
    }

    public static List<ExtA1UserRule> getFlowExtServiceUserRule(JsonNode objectNode, String nodeId) {
        ArrayList<ExtA1UserRule> extA1UserRulesList = new ArrayList<ExtA1UserRule>();
        ArrayNode arrNode = (ArrayNode)objectNode.get("nodeUserList");
        if (arrNode.isArray()) {
            for (JsonNode jsonNode : arrNode) {
                String ruleType;
                if (jsonNode.get("type") == null) continue;
                switch (ruleType = jsonNode.get("type").asText()) {
                    case "1": {
                        String userNo = jsonNode.get("targetId").asText();
                        String fullname = jsonNode.get("name").asText();
                        ExtA1UserRule extA1UserRule = new ExtA1UserRule();
                        extA1UserRule.setId(UUID.randomUUID().toString());
                        extA1UserRule.setNodeId(nodeId);
                        extA1UserRule.setPluginType("users");
                        extA1UserRule.setRuleId("spec");
                        extA1UserRule.setSpecId(userNo);
                        extA1UserRule.setLogicCal("or");
                        extA1UserRule.setPluginVal(fullname);
                        extA1UserRulesList.add(extA1UserRule);
                        break;
                    }
                }
            }
        }
        return extA1UserRulesList;
    }

    public static List<ExtA1Attribute> getFlowExtNullUserRule(JsonNode nodeConfig, String nodeId) {
        String operateNullUser;
        ArrayList<ExtA1Attribute> result = new ArrayList<ExtA1Attribute>();
        if (nodeConfig.get("operateNullUser") != null && StringUtils.isNotEmpty((CharSequence)(operateNullUser = nodeConfig.get("operateNullUser").asText()))) {
            ExtA1Attribute extA1Attribute = new ExtA1Attribute();
            extA1Attribute.setId(UUID.randomUUID().toString());
            extA1Attribute.setNodeId(nodeId);
            extA1Attribute.setFlag(operateNullUser);
            extA1Attribute.setName("pangu");
            if (operateNullUser.equals("1") || operateNullUser.equals("3")) {
                extA1Attribute.setVal(operateNullUser);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                ArrayNode arrNodeRole = (ArrayNode)nodeConfig.get("nullNodeUserList");
                if (arrNodeRole.isArray()) {
                    for (JsonNode jsonNode_user : arrNodeRole) {
                        String userNo = jsonNode_user.get("userNo").asText();
                        list.add(userNo);
                    }
                }
                if (list.size() > 0) {
                    String userId = list.stream().map(String::valueOf).collect(Collectors.joining(","));
                    extA1Attribute.setVal(userId);
                }
            }
            result.add(extA1Attribute);
        }
        return result;
    }

    public static String converConditionList(JsonNode jsonNode) {
        ArrayNode arrayNode;
        StringBuilder sb = new StringBuilder();
        sb.append("${ ");
        if (jsonNode.get("conditionList") != null && (arrayNode = (ArrayNode)jsonNode.get("conditionList")).isArray()) {
            for (JsonNode jsonNode_user : arrayNode) {
                if (!jsonNode_user.isArray()) continue;
                for (JsonNode jsonNode_user_condition : jsonNode_user) {
                    String operateCode = jsonNode_user_condition.get("operateCode").asText();
                    String optType = jsonNode_user_condition.get("optType").asText();
                    String condition = jsonNode_user_condition.get("condition").asText();
                    String value = jsonNode_user_condition.get("value").asText();
                    sb.append(operateCode);
                    sb.append(" ");
                    sb.append(condition);
                    sb.append(optType);
                    if (condition.startsWith("input_") || condition.startsWith("textarea") || condition.startsWith("radio") || condition.startsWith("select") || condition.startsWith("checkbox") || condition.startsWith("date") || condition.startsWith("table") || condition.startsWith("table")) {
                        sb.append("'");
                        sb.append(value);
                        sb.append("'");
                    } else {
                        sb.append(value);
                    }
                    sb.append(" ");
                }
            }
        }
        sb.append(" } ");
        return sb.toString();
    }
}

