/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.pangubpm.common.annotation.SysLog;
import com.pangubpm.common.config.PanguProperties;
import com.pangubpm.common.utils.Query;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.modules.form.entity.FormBusObject;
import com.pangubpm.modules.form.service.FormBusObjectService;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/form/bus/businessObject/"})
public class BusinessObjectController
extends AbstractController {
    @Autowired
    private FormBusObjectService formBusObjectService;
    @Autowired
    private PanguProperties panguProperties;

    @RequestMapping(value={"/condition/{formKey}"})
    @SysLog(value="\u83b7\u53d6\u8868\u5355\u6761\u4ef6")
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6761\u4ef6", tags={"BPM"}, notes="\u83b7\u53d6\u8868\u5355\u6761\u4ef6", httpMethod="POST")
    public Result listCondition(@PathVariable(value="formKey") String formKey) {
        Result r = Result.ok();
        ArrayList result = new ArrayList();
        return this.formBusObjectService.getBoStructByFormKey(formKey);
    }

    @GetMapping(value={"/list"})
    public String list() throws Exception {
        return "modules/form/businessObjectList";
    }

    @GetMapping(value={"edit"})
    public String businessTableEdit() throws UnsupportedEncodingException {
        return "modules/form/businessObjEdit";
    }

    @GetMapping(value={"getStruct"})
    public String getStruct() throws UnsupportedEncodingException {
        return "modules/form/businessObjStruct";
    }

    @GetMapping(value={"/businessTableList"})
    public String businessTableList() {
        return "modules/form/businessTableQuery";
    }

    @GetMapping(value={"/businessTableMuliList"})
    public String businessTableMuliList() {
        return "modules/form/businessTableMultiQuery";
    }

    @PostMapping(value={"/save"})
    @SysLog(value="\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61")
    @ResponseBody
    public Result save(HttpServletRequest request, @RequestBody FormBusObject businessObject) {
        String userId = this.getUserId(request);
        return this.formBusObjectService.saveOrUpdateObj(businessObject, userId);
    }

    @GetMapping(value={"/delete/{id}"})
    @SysLog(value="\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61")
    @ResponseBody
    public Result delete(@PathVariable(required=false, name="id") String id) {
        if (Boolean.valueOf(this.panguProperties.getDelete()).booleanValue()) {
            return this.formBusObjectService.delete(id);
        }
        return Result.error((String)"\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
    }

    @RequestMapping(value={"getStruct/{id}"})
    @SysLog(value="\u83b7\u53d6\u8868\u5355\u7ed3\u6784")
    @ResponseBody
    public Result getBoStruct(@PathVariable(required=true, name="id") String id) {
        return this.formBusObjectService.getBoStruct(id);
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    @GetMapping(value={"get/{id}"}, produces={"application/json; charset=utf-8"})
    @SysLog(value="\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61")
    @ResponseBody
    public Result get(@PathVariable String id, Model model) {
        FormBusObject formBusObject = this.formBusObjectService.getById(id);
        return Result.ok().put("data", (Object)formBusObject);
    }

    @RequestMapping(value={"/listJson"})
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u5bf9\u8c61")
    @ResponseBody
    public Result listJson(@ApiIgnore @RequestParam Map<String, Object> allRequestParams) {
        IPage page = new Query().getPage(allRequestParams);
        Result r = this.formBusObjectService.listAll((IPage<FormBusObject>)page, allRequestParams);
        return r;
    }

    @GetMapping(value={"/objJson/{formKey}"})
    @ResponseBody
    public Result listJson(@PathVariable String formKey) throws UnsupportedEncodingException {
        Result r = this.formBusObjectService.getBusObjectByFormKey(formKey);
        return r;
    }
}

