/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pangu.form.api.FormDeployment;
import com.pangu.form.api.FormInstance;
import com.pangu.form.api.FormInstanceQuery;
import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.api.FormService;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangubpm.common.config.PanguProperties;
import com.pangubpm.common.entity.ProcessInstance;
import com.pangubpm.common.entity.Task;
import com.pangubpm.common.utils.DateUtils;
import com.pangubpm.common.utils.IoUtil;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.utils.SnowflakeIdWorkerUtils;
import com.pangubpm.common.utils.StringUtil;
import com.pangubpm.common.vo.ConditionVO;
import com.pangubpm.modules.form.client.BpmAdapterUtils;
import com.pangubpm.modules.form.constant.BusTableRelType;
import com.pangubpm.modules.form.dao.FormBusObjectDao;
import com.pangubpm.modules.form.dao.FormBusinessDao;
import com.pangubpm.modules.form.dao.FormBusinessModelColumnDao;
import com.pangubpm.modules.form.dao.FormDefinitionDao;
import com.pangubpm.modules.form.dto.FormGroupModelDto;
import com.pangubpm.modules.form.dto.FormModelDto;
import com.pangubpm.modules.form.entity.FormBusObject;
import com.pangubpm.modules.form.entity.FormBusinessEntity;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import com.pangubpm.modules.form.exception.BusinessException;
import com.pangubpm.modules.form.model.BusTableRel;
import com.pangubpm.modules.form.model.FormDefinition;
import com.pangubpm.modules.form.po.FieldPo;
import com.pangubpm.modules.form.po.FormAuthInfoPo;
import com.pangubpm.modules.form.po.FormFieldPo;
import com.pangubpm.modules.form.po.FormFieldRule;
import com.pangubpm.modules.form.po.FormObjectPo;
import com.pangubpm.modules.form.po.FormStructPo;
import com.pangubpm.modules.form.po.FormTableClumnPo;
import com.pangubpm.modules.form.po.FormTablePo;
import com.pangubpm.modules.form.service.FormBusObjectService;
import com.pangubpm.modules.form.service.FormDesignService;
import com.pangubpm.modules.form.utils.FillDataUtils;
import com.pangubpm.modules.form.utils.NodeTypeEnum;
import com.pangubpm.modules.form.vo.FormFieldOptions;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="formBusObjectService")
public class FormBusObjectServiceImpl
extends ServiceImpl<FormBusObjectDao, FormBusObject>
implements FormBusObjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormBusObjectServiceImpl.class);
    @Autowired
    private FormBusObjectDao formBusObjectDao;
    @Autowired
    private FormBusinessDao formBusinessDao;
    @Autowired
    private FormDesignService formDesignService;
    @Autowired
    private FormDefinitionDao formDefinitionDao;
    @Autowired
    private FormBusinessModelColumnDao formBusinessModelColumnDao;
    @Autowired
    private FormEngineConfiguration formEngineConfiguration;
    @Autowired
    private FormService formService;
    @Autowired
    private PanguProperties panguProperties;

    @Override
    public Result listAll(IPage<FormBusObject> page, Map<String, Object> allRequestParams) {
        IPage<FormBusObject> formBusObjects = this.formBusObjectDao.listAll(page, allRequestParams);
        List records = formBusObjects.getRecords();
        return Result.ok().put("count", (Object)formBusObjects.getTotal()).put("data", (Object)records);
    }

    @Override
    public Result saveOrUpdateObj(FormBusObject businessObject, String userId) {
        if (!StringUtils.isNotEmpty((CharSequence)businessObject.getId())) {
            String objKey = businessObject.getObjKey();
            List<FormBusObject> existList = this.formBusObjectDao.existObjKey(objKey);
            if (existList.size() > 0) {
                return Result.error((String)"\u522b\u540d\u4e0d\u5141\u8bb8\u91cd\u590d");
            }
            businessObject.setId(SnowflakeIdWorkerUtils.getNextId());
            businessObject.setCreateTime(DateUtils.getCurrentDate());
            businessObject.setUpdateTime(DateUtils.getCurrentDate());
            businessObject.setCreateBy(userId);
            this.formBusObjectDao.insertSelective(businessObject);
        } else {
            businessObject.setUpdateTime(DateUtils.getCurrentDate());
            businessObject.setUpdateBy(userId);
            this.formBusObjectDao.updateByPrimaryKeySelective(businessObject);
        }
        return Result.ok().put("data", (Object)businessObject);
    }

    @Override
    public FormBusObject getById(String id) {
        return this.formBusObjectDao.selectByPrimaryKey(id);
    }

    @Override
    public Result getBoStruct(String id) {
        FormBusObject formBusObject = this.formBusObjectDao.selectByPrimaryKey(id);
        this.fill(formBusObject);
        JSONObject boStruct = this.getBoStruct(formBusObject.getRelation());
        return Result.ok().put("data", (Object)boStruct);
    }

    @Override
    public Result getBoStructByFormKey(String formKey) {
        FormDefinition formDefinition = this.formDesignService.getByMainKey(formKey);
        String formBusinessId = formDefinition.getFormBusinessId();
        FormBusObject formBusObject = this.formBusObjectDao.selectByPrimaryKey(formBusinessId);
        String tableName = this.fill(formBusObject);
        List<Object> boStruct = new ArrayList();
        String mainTableName = "";
        if (formBusObject != null) {
            this.fill(formBusObject);
            boStruct = this.getBoFormTypeStruct(formBusObject.getRelation());
        }
        return Result.ok().put("data", boStruct).put("typeTitle", (Object)tableName);
    }

    @Override
    public Result getBoTypeStruct(String id) {
        Result r = Result.ok();
        FormDefinition formDefinition = (FormDefinition)this.formDesignService.getById((Serializable)((Object)id));
        if (formDefinition != null) {
            String formBusinessId = formDefinition.getFormBusinessId();
            if (StringUtils.isNotEmpty((CharSequence)formBusinessId)) {
                FormBusObject formBusObject = this.formBusObjectDao.selectByPrimaryKey(formBusinessId);
                JSONArray jSONArray1 = new JSONArray();
                if (formBusObject != null) {
                    this.fill(formBusObject);
                    jSONArray1 = this.getBoTypeStruct(formBusObject.getRelation());
                }
                r.put("data", (Object)jSONArray1);
            } else {
                r = Result.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
            }
        } else {
            r = Result.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        return r;
    }

    @Override
    public Result delete(String id) {
        this.formBusObjectDao.updateDeletedById(id);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public FormBusObject getByMainKey(String formValue) {
        return this.formBusObjectDao.getByMainKey(formValue);
    }

    @Override
    public Result getTemplateHtml(String id, String userCode) {
        Result r = Result.ok();
        String deploymentId = BpmAdapterUtils.getDeploymentId(id);
        if (StringUtils.isEmpty((CharSequence)deploymentId)) {
            LOGGER.warn("\u627e\u4e0d\u5230\u90e8\u7f72Id");
            return r;
        }
        FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
        FormDeployment formDeployment = (FormDeployment)formRepositoryService.createDeploymentQuery().parentDeploymentId(deploymentId).singleResult();
        if (formDeployment == null) {
            throw new BusinessException("\u8868\u5355\u5f15\u64ce\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String childenDeploymentId = formDeployment.getId();
        com.pangu.form.api.FormDefinition formDefinition = (com.pangu.form.api.FormDefinition)formRepositoryService.createFormDefinitionQuery().deploymentId(childenDeploymentId).singleResult();
        String resourceName = formDefinition.getResourceName();
        InputStream resourceAsStream = formRepositoryService.getResourceAsStream(childenDeploymentId, resourceName);
        byte[] bytes = org.flowable.common.engine.impl.util.IoUtil.readInputStream((InputStream)resourceAsStream, (String)childenDeploymentId);
        String formTemplate = "";
        try {
            formTemplate = new String(bytes, "UTF-8");
            r.put("data", (Object)formTemplate);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage());
        }
        try {
            String listJson = this.build(formDefinition.getDeploymentId(), new String(bytes, "UTF-8"), userCode, formTemplate, NodeTypeEnum.START, null);
            if (listJson != null) {
                r.put("data", (Object)listJson);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage());
            r = Result.error((String)e.getMessage());
        }
        return r;
    }

    @Override
    public Result getTemplateJson(String id) {
        FormDefinition formDefinition = (FormDefinition)this.formDesignService.getById((Serializable)((Object)id));
        byte[] pageFormJson = formDefinition.getPageFormJson();
        String pageFormJsonStr = new String(pageFormJson, StandardCharsets.UTF_8);
        return Result.ok().put("data", (Object)pageFormJsonStr);
    }

    private JSONArray getBoTypeStruct(BusTableRel rel) {
        FormBusinessEntity table = rel.getTable();
        JSONArray jsonArray = new JSONArray();
        if (rel.getTable() != null) {
            rel.getTable().getColumns().forEach(column -> {
                FormFieldOptions formFieldOptions = new FormFieldOptions();
                formFieldOptions.setLabel(column.getDescription());
                formFieldOptions.setValue(column.getColumnKey());
                jsonArray.add((Object)formFieldOptions);
            });
            rel.getChildren().forEach(r -> {
                if (BusTableRelType.ONE_TO_ONE.equalsWithKey(r.getType())) {
                    jsonArray.addAll((Collection)this.getBoTypeStruct((BusTableRel)r));
                } else {
                    jsonArray.addAll((Collection)this.getBoTypeStruct((BusTableRel)r));
                }
            });
        }
        return jsonArray;
    }

    private List<ConditionVO> getBoFormTypeStruct(BusTableRel rel) {
        JSONObject jsonObject = new JSONObject();
        ArrayList<ConditionVO> jsonArray = new ArrayList<ConditionVO>();
        FormBusinessEntity table = rel.getTable();
        rel.getTable().getColumns().forEach(column -> {
            ConditionVO conditionVO = new ConditionVO();
            conditionVO.setKey(column.getColumnKey());
            conditionVO.setValue(column.getDescription());
            jsonArray.add(conditionVO);
        });
        rel.getChildren().forEach(r -> {
            if (BusTableRelType.ONE_TO_ONE.equalsWithKey(r.getType())) {
                jsonArray.addAll(this.getBoFormTypeStruct((BusTableRel)r));
            }
        });
        return jsonArray;
    }

    private String fill(FormBusObject formBusObject) {
        String tableName = "";
        if (formBusObject == null) {
            return tableName;
        }
        for (BusTableRel rel : formBusObject.getRelation().list()) {
            List<FormBusinessEntity> formBusinessEntityList;
            String tableKey = rel.getTableKey();
            if (!StringUtils.isNotEmpty((CharSequence)tableKey) || (formBusinessEntityList = this.formBusinessDao.getFilledByKey(tableKey)).size() <= 0) continue;
            FormBusinessEntity formBusinessEntity = formBusinessEntityList.get(0);
            this.fill(formBusinessEntity);
            rel.setTable(formBusinessEntity);
            rel.setBusObj(formBusObject);
            tableName = formBusinessEntity.getTableName();
        }
        return tableName;
    }

    private void fill(FormBusinessEntity businessTable) {
        if (businessTable == null) {
            throw new BusinessException("\u8868\u4e3a\u7a7a");
        }
        List<FormBusinessModelColumnEntity> columns = this.formBusinessModelColumnDao.getByTableId(businessTable.getId());
        for (FormBusinessModelColumnEntity column : columns) {
            column.setBusinessTable(businessTable);
        }
        businessTable.setColumns(columns);
    }

    private JSONObject getBoStruct(BusTableRel rel) {
        JSONObject json = new JSONObject();
        rel.getTable().getColumns().forEach(column -> json.put(column.getColumnKey(), column.initDefaultValue() == null ? "" : column.initDefaultValue()));
        rel.getChildren().forEach(r -> {
            if (BusTableRelType.ONE_TO_ONE.equalsWithKey(r.getType())) {
                json.put(r.getTableKey(), (Object)this.getBoStruct((BusTableRel)r));
            } else {
                JSONObject jo = this.getBoStruct((BusTableRel)r);
                JSONArray ja = new JSONArray();
                ja.add((Object)jo);
                json.put(r.getTableKey() + "List", (Object)ja);
            }
        });
        return json;
    }

    @Override
    public Result getBusObjectByFormKey(String formKey) {
        FormDefinition definitionDaoByMainKey = this.formDefinitionDao.getByMainKey(formKey);
        String formBusinessId = definitionDaoByMainKey.getFormBusinessId();
        FormBusObject obj = this.formBusObjectDao.getById(formBusinessId);
        ArrayList<FormObjectPo> list2 = new ArrayList<FormObjectPo>();
        if (obj != null) {
            JSONObject jsonObject = JSON.parseObject((String)obj.getRelationJson());
            FormObjectPo formObjectPo = new FormObjectPo();
            formObjectPo.setDescription(jsonObject.get((Object)"tableComment").toString());
            if ("main".equals(jsonObject.get((Object)"type").toString())) {
                formObjectPo.setMain(true);
            } else {
                formObjectPo.setMain(false);
            }
            String tableKey = jsonObject.get((Object)"tableKey").toString();
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("TABLE_NAME", tableKey);
            List formBusinessEntityList = this.formBusinessDao.selectByMap(map2);
            if (formBusinessEntityList.size() > 0) {
                FormBusinessEntity formBusinessEntity = (FormBusinessEntity)formBusinessEntityList.get(0);
                formObjectPo.setTableName(formBusinessEntity.getTableName());
                formObjectPo.setFields(new ArrayList());
                List<FormBusinessModelColumnEntity> columnEntities = this.formBusinessModelColumnDao.selectByTableId(formBusinessEntity.getId());
                for (FormBusinessModelColumnEntity formBusinessEntity1 : columnEntities) {
                    FieldPo fieldPo = new FieldPo();
                    fieldPo.setDescription(formBusinessEntity1.getDescription());
                    fieldPo.setFieldName(formBusinessEntity1.getColumnKey());
                    fieldPo.setRead("true");
                    fieldPo.setWrite("true");
                    fieldPo.setRequired("false");
                    fieldPo.setHidden("false");
                    formObjectPo.getFields().add(fieldPo);
                }
            }
            list2.add(formObjectPo);
            this.build(list2, jsonObject.get((Object)"children").toString());
        }
        return Result.ok().put("data", list2);
    }

    private com.pangu.form.api.FormDefinition getFormDefId(String defId) {
        String deploymentId = BpmAdapterUtils.getDeploymentId(defId);
        FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
        FormDeployment formDeployment = (FormDeployment)formRepositoryService.createDeploymentQuery().parentDeploymentId(deploymentId).singleResult();
        String formDeploymentId = formDeployment.getId();
        com.pangu.form.api.FormDefinition formDefinition = (com.pangu.form.api.FormDefinition)formRepositoryService.createFormDefinitionQuery().deploymentId(formDeploymentId).singleResult();
        return formDefinition;
    }

    @Override
    public Result getUserTaskTemplateHtml(String taskId, String processInstanceId, String userCode) {
        Result r = Result.ok();
        String processDefinitionId = "";
        String taskKey = "";
        FormInstance formInstance = (FormInstance)this.formService.createFormInstanceQuery().taskId(taskId).singleResult();
        if (formInstance == null) {
            String superExecutionId;
            ProcessInstance processInstance;
            List list;
            String childProcessInstanceId = "";
            Task result = BpmAdapterUtils.getTaskInfo(taskId);
            if (result != null) {
                taskKey = result.getTaskDefinitionKey();
                childProcessInstanceId = result.getProcessInstanceId();
            }
            if ((list = ((FormInstanceQuery)this.formService.createFormInstanceQuery().processInstanceId(childProcessInstanceId).orderBySubmittedDate().desc()).list()) != null && list.size() > 0) {
                formInstance = (FormInstance)list.get(0);
            } else if (result != null && (processInstance = BpmAdapterUtils.getProcessInstance(childProcessInstanceId)) != null && StringUtil.isNotEmpty((String)(superExecutionId = processInstance.getSuperExecutionId())) && (list = ((FormInstanceQuery)this.formService.createFormInstanceQuery().processInstanceId(processInstance.getRootProcessInstanceId()).orderBySubmittedDate().desc()).list()) != null) {
                formInstance = (FormInstance)list.get(0);
            }
        }
        if (formInstance != null) {
            processInstanceId = formInstance.getProcessInstanceId();
            processDefinitionId = formInstance.getProcessDefinitionId();
        }
        FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
        if (formInstance == null) {
            List list;
            Task task;
            if (!StringUtils.isNotEmpty((CharSequence)processInstanceId) && (task = BpmAdapterUtils.getTaskInfo(taskId)) != null) {
                taskKey = task.getTaskDefinitionKey();
                processInstanceId = task.getProcessInstanceId();
                processDefinitionId = task.getProcessDefinitionId();
            }
            if ((list = ((FormInstanceQuery)this.formService.createFormInstanceQuery().processInstanceId(processInstanceId).orderBySubmittedDate().desc()).list()).size() > 0) {
                formInstance = (FormInstance)list.get(0);
            }
        }
        if (this.panguProperties.getUserPhysicalTable().booleanValue()) {
            com.pangu.form.api.FormDefinition formDefId;
            ProcessInstance processInstance = BpmAdapterUtils.getProcessInstance(processInstanceId);
            if (processInstance == null) {
                throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
            String formKey = BpmAdapterUtils.getFormKey(processDefinitionId);
            if (StringUtil.isNotEmpty((String)formKey) && (formDefId = this.getFormDefId(processDefinitionId)) == null) {
                throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8868");
            }
        } else if (formInstance != null) {
            String formValue = formRepositoryService.getDeploymentResourceById(formInstance.getFormValuesId());
            r.put("editData", (Object)formValue);
        }
        if (formInstance != null) {
            String formDefinitionId = formInstance.getFormDefinitionId();
            com.pangu.form.api.FormDefinition formDefinition = (com.pangu.form.api.FormDefinition)formRepositoryService.createFormDefinitionQuery().formId(formDefinitionId).singleResult();
            String deploymentId = formDefinition.getDeploymentId();
            InputStream inputStream = formRepositoryService.getResourceAsStream(deploymentId, formDefinition.getResourceName());
            byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)formDefinition.getResourceName());
            String formTempleteStr = null;
            try {
                formTempleteStr = new String(bytes, "UTF-8");
                r.put("data", (Object)formTempleteStr);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            try {
                String listJson = this.build(formDefinition.getDeploymentId(), new String(bytes, "UTF-8"), userCode, formTempleteStr, NodeTypeEnum.USERTASK, taskKey);
                if (listJson != null) {
                    r.put("data", (Object)listJson);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                r = Result.error((String)e.getMessage());
            }
        } else if (StringUtils.isNotEmpty((CharSequence)processDefinitionId)) {
            r = this.getTemplateHtml(processDefinitionId, userCode);
        }
        return r;
    }

    @Override
    public Result queryListCount() {
        List<FormModelDto> formModelDtoList = this.formBusObjectDao.queryModelListCount();
        Map<Integer, FormModelDto> monthToCount = formModelDtoList.stream().collect(Collectors.toMap(FormModelDto::getMonth, FormModelDto2 -> FormModelDto2));
        ArrayList<FormModelDto> result = new ArrayList<FormModelDto>();
        FillDataUtils.fillData(monthToCount, result);
        return Result.ok().put("formModelCount", result);
    }

    @Override
    public Result getGroupBusCount() {
        List<FormGroupModelDto> formModelDtoList = this.formBusObjectDao.getGroupBusCount();
        return Result.ok().put("formBusGroupCount", formModelDtoList);
    }

    @Override
    public Result getFormInstanceCount() {
        List<FormModelDto> formModelDtoList = this.formBusObjectDao.getFormInstanceCount();
        Map<Integer, FormModelDto> monthToCount = formModelDtoList.stream().collect(Collectors.toMap(FormModelDto::getMonth, FormModelDto2 -> FormModelDto2));
        ArrayList<FormModelDto> result = new ArrayList<FormModelDto>();
        FillDataUtils.fillData(monthToCount, result);
        return Result.ok().put("formInstanceCount", result);
    }

    public List<FormObjectPo> build(List<FormObjectPo> list, String str) {
        JSONArray arr = JSON.parseArray((String)str);
        for (int i = 0; i < arr.size(); ++i) {
            JSONArray arr1;
            JSONObject obj = JSON.parseObject((String)arr.get(i).toString());
            FormObjectPo formObjectPo = new FormObjectPo();
            formObjectPo.setDescription(obj.get((Object)"tableComment").toString());
            if ("main".equals(obj.get((Object)"type").toString())) {
                formObjectPo.setMain(true);
            } else {
                formObjectPo.setMain(false);
            }
            String tableKey = obj.get((Object)"tableKey").toString();
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("TABLE_NAME", tableKey);
            List formBusinessEntityList = this.formBusinessDao.selectByMap(map2);
            if (formBusinessEntityList.size() > 0) {
                FormBusinessEntity formBusinessEntity = (FormBusinessEntity)formBusinessEntityList.get(0);
                formObjectPo.setTableName(formBusinessEntity.getTableName());
                formObjectPo.setFields(new ArrayList());
                List<FormBusinessModelColumnEntity> columnEntities = this.formBusinessModelColumnDao.selectByTableId(formBusinessEntity.getId());
                for (FormBusinessModelColumnEntity formBusinessEntity1 : columnEntities) {
                    FieldPo fieldPo = new FieldPo();
                    fieldPo.setDescription(formBusinessEntity1.getDescription());
                    fieldPo.setFieldName(formBusinessEntity1.getColumnKey());
                    fieldPo.setRead("true");
                    fieldPo.setWrite("true");
                    fieldPo.setRequired("false");
                    formObjectPo.getFields().add(fieldPo);
                }
            }
            list.add(formObjectPo);
            if (!obj.containsKey((Object)"children") || (arr1 = JSONArray.parseArray((String)obj.get((Object)"children").toString())).size() <= 0) continue;
            this.build(list, obj.get((Object)"children").toString());
        }
        return list;
    }

    public String build(String deploymentId, String listJson, String userCode, String formTemplate, NodeTypeEnum start, String taskKey) {
        block27: {
            try {
                FormDefinition formDefinition = this.formDefinitionDao.selectByDeploymentId(deploymentId);
                if (formDefinition == null) {
                    return null;
                }
                String authJson = new String(formDefinition.getFormHtml());
                String formBusinessId = formDefinition.getFormBusinessId();
                FormBusObject formBusObject = this.formBusObjectDao.selectByPrimaryKey(formBusinessId);
                if (!StringUtils.isNotEmpty((CharSequence)authJson)) break block27;
                List authInfoPos = JSON.parseArray((String)authJson, FormAuthInfoPo.class);
                authInfoPos = start == NodeTypeEnum.START ? authInfoPos.stream().filter(o -> o.getNodeId().startsWith("StartEvent")).collect(Collectors.toList()) : (StringUtil.isNotEmpty((String)taskKey) ? authInfoPos.stream().filter(o -> o.getNodeId().equals(taskKey)).collect(Collectors.toList()) : authInfoPos.stream().filter(o -> o.getNodeId().startsWith("UserTask")).collect(Collectors.toList()));
                if (authInfoPos.size() > 0) {
                    JSONObject jsonObject = JSON.parseObject((String)formBusObject.getRelationJson());
                    String mainTableKey = jsonObject.get((Object)"tableKey").toString();
                    FormStructPo formStructPo = (FormStructPo)JSON.parseObject((String)listJson, FormStructPo.class);
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    for (FormAuthInfoPo formAuthInfoPo : authInfoPos) {
                        for (FormTablePo formTablePo : formAuthInfoPo.getDataList()) {
                            for (FormTableClumnPo formTableClumnPo : formTablePo.getFields()) {
                                map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_required", true);
                                map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_hidden", true);
                                map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_read", false);
                                map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_write", false);
                                if (!formTableClumnPo.isRequired()) {
                                    map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_required", false);
                                }
                                if (!formTableClumnPo.isHidden()) {
                                    map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_hidden", false);
                                }
                                if (formTableClumnPo.isRead()) {
                                    map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_read", true);
                                }
                                if (!formTableClumnPo.isWrite()) continue;
                                map.put(formTablePo.getTableName() + "_" + formTableClumnPo.getFieldName() + "_write", true);
                            }
                        }
                    }
                    if (map.size() > 0) {
                        for (FormFieldPo formFieldPo : formStructPo.getList()) {
                            Boolean _hidden;
                            if (formFieldPo.getType().equals("table")) {
                                for (FormFieldPo formFieldPo1 : formFieldPo.getTableColumns()) {
                                    Boolean modelBoolean = (Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_required");
                                    formFieldPo1.getOptions().setRequired(modelBoolean.booleanValue());
                                    formFieldPo1.getOptions().setShow((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_hidden") == false);
                                    if (((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_read")).booleanValue()) {
                                        if (((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_write")).booleanValue()) {
                                            formFieldPo1.getOptions().setDisabled(false);
                                            continue;
                                        }
                                        formFieldPo1.getOptions().setDisabled(true);
                                        continue;
                                    }
                                    formFieldPo1.getOptions().setDisabled(true);
                                }
                                continue;
                            }
                            if (formFieldPo.getType().equals("block")) {
                                for (FormFieldPo formFieldPo1 : formFieldPo.getTableColumns()) {
                                    formFieldPo1.getOptions().setRequired(((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_required")).booleanValue());
                                    formFieldPo1.getOptions().setShow((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_hidden") == false);
                                    if (((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_read")).booleanValue()) {
                                        if (((Boolean)map.get(formFieldPo.getModel() + "_" + formFieldPo1.getModel() + "_write")).booleanValue()) {
                                            formFieldPo1.getOptions().setDisabled(false);
                                            continue;
                                        }
                                        formFieldPo1.getOptions().setDisabled(true);
                                        continue;
                                    }
                                    formFieldPo1.getOptions().setDisabled(true);
                                }
                                continue;
                            }
                            Boolean isRequired = (Boolean)map.get(mainTableKey + "_" + formFieldPo.getModel() + "_required");
                            if (isRequired != null) {
                                formFieldPo.getOptions().setRequired(isRequired.booleanValue());
                                if (isRequired.booleanValue()) {
                                    FormFieldRule requiredFormFieldRule = new FormFieldRule();
                                    requiredFormFieldRule.setCustomerType(FormFieldRule.NO_NULL);
                                    requiredFormFieldRule.setMsg("\u5fc5\u586b");
                                    requiredFormFieldRule.setTrigger(FormFieldRule.BLUR);
                                    formFieldPo.getRules().add(requiredFormFieldRule);
                                }
                            }
                            if ((_hidden = (Boolean)map.get(mainTableKey + "_" + formFieldPo.getModel() + "_hidden")) == null) {
                                _hidden = (Boolean)map.get(mainTableKey + "_" + formFieldPo.getKey() + "_hidden");
                            }
                            if (_hidden == null) continue;
                            Boolean _read = (Boolean)map.get(mainTableKey + "_" + formFieldPo.getModel() + "_read");
                            if (_read != null) {
                                Boolean _write = (Boolean)map.get(mainTableKey + "_" + formFieldPo.getModel() + "_write");
                                if (_write.booleanValue()) {
                                    formFieldPo.getOptions().setDisabled(false);
                                } else {
                                    formFieldPo.getOptions().setDisabled(true);
                                }
                            } else {
                                formFieldPo.getOptions().setDisabled(true);
                            }
                            formFieldPo.getOptions().setShow(_hidden != true);
                        }
                    }
                    return JSON.toJSON((Object)formStructPo).toString();
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public FormBusObject getBymodelViewCode(String modelViewCode) {
        return this.formBusObjectDao.getBymodelViewCode(modelViewCode);
    }
}

