<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE hibernate-mapping PUBLIC "-//Hibernate/Hibernate Mapping DTD 3.0//EN" "http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd">
<hibernate-mapping>
	<class name="${entity.tableName}" table="${entity.tableName}" optimistic-lock="version">
		<#if entity.columns?exists>
			<id name="id_" type="java.lang.String" length="64" unsaved-value="null">
				<generator class="uuid" />
			</id>
			<#list entity.columns as attr>
				<#if attr.columnKey == "id">
					<#if entity.jformPkType?if_exists?html=='UUID'>
						<id name="id" type="java.lang.String" length="${attr.attrLength}" unsaved-value="null">
							<generator class="uuid" />
						</id>
					</#if>

				<#else>
					<property name="${attr.columnKey}"
							<#switch attr.javaType?lower_case>
							<#case "string">
								type="java.lang.String"
								<#break>
							<#case "text">
							<#-- update--begin--author:scott Date:20180227 for:针对oracle情况下text类型采用clob转换 -->
								<#if dataType=='ORACLE'>
									type="clob"
								<#else>
									type="text"
								</#if>
							<#-- update--end--author:scott Date:20180227 for:针对oracle情况下text类型采用clob转换 -->
								<#break>
							<#case "int">
								type="java.lang.Integer"
								<#break>
							<#case "double">
							  type="double">
						<#break>
						<#case "tinyint">
							type="TINYINT(1)">
							<#break>
						<#case "date">
							type="java.util.Date"
							<#break>
						<#case "bigdecimal" >
							type="java.math.BigDecimal"
							<#break>
						<#case "blob">
							<#if dataType=='MYSQL'>
								type="blob"
							<#elseif dataType=='ORACLE'>
								type="blob"
							<#elseif dataType=='POSTGRESQL'>
								type="binary"
							<#elseif dataType=='SQLSERVER'>
								type="image"
							</#if>
							<#break>
						</#switch> access="property">
						<column name="${attr.columnKey}" <#if dataType=='SQLSERVER' && attr.dbType?lower_case="string"> sql-type="nvarchar(${attr.dbLength})" </#if>
								<#if dataType=='SQLSERVER' && attr.dbType?lower_case="text"> sql-type="ntext" </#if>
								<#if attr.dataType=='double'||attr.dataType=='BigDecimal'>
									precision="${attr.attrLength}" scale="${attr.decimalLength}"<#else>length="${attr.attrLength}"</#if>
								<#if attr.defaultValue?exists&&attr.defaultValue!=''>default="${attr.attrLength}"</#if>
								not-null="<#if attr.dbIsNull == 1>false<#else>true</#if>"
								unique="false">
							<comment>${attr.description}</comment>
						</column>
					</property>
				</#if>
			</#list>
		</#if>
	</class>
</hibernate-mapping>