/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.util;

import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.persistence.deploy.DeploymentManager;
import com.pangu.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntity;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import com.pangubpm.form.model.SimpleFormModel;
import org.flowable.common.engine.api.FlowableException;

public class FormUtil {
    public static FormDefinitionEntity getFormDefinitionEntity(String formDefinitionId) {
        return FormUtil.getFormDefinitionEntity(formDefinitionId, false);
    }

    public static FormDefinitionEntity getFormDefinitionEntity(String formDefinitionId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)CommandContextUtil.getFormEngineConfiguration().getFormDefinitionCache().get(formDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getFormDefinitionEntity();
            }
            return null;
        }
        return CommandContextUtil.getFormEngineConfiguration().getDeploymentManager().findDeployedFormDefinitionById(formDefinitionId);
    }

    public static SimpleFormModel getFormDefinition(String formDefinitionId) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        DeploymentManager deploymentManager = formEngineConfiguration.getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(formDefinitionId);
        FormDefinitionCacheEntry cacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return null;
    }

    public static SimpleFormModel getFormDefinitionFromCache(String formId) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        FormDefinitionCacheEntry cacheEntry = (FormDefinitionCacheEntry)formEngineConfiguration.getFormDefinitionCache().get(formId);
        if (cacheEntry != null) {
            return null;
        }
        return null;
    }

    public static FormDefinitionEntity getFormDefinitionFromDatabase(String formDefinitionId) {
        FormDefinitionEntityManager formDefinitionEntityManager = CommandContextUtil.getFormEngineConfiguration().getFormDefinitionEntityManager();
        FormDefinitionEntity formDefinition = (FormDefinitionEntity)formDefinitionEntityManager.findById(formDefinitionId);
        if (formDefinition == null) {
            throw new FlowableException("No form definitionfound with id " + formDefinitionId);
        }
        return formDefinition;
    }
}

