/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl;

import com.pangu.form.api.FormManagementService;
import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.api.FormService;
import com.pangu.form.engine.FormEngine;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.FormEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEngineImpl
implements FormEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormEngineImpl.class);
    protected String name;
    protected FormManagementService managementService;
    protected FormRepositoryService repositoryService;
    protected FormService formService;
    protected FormEngineConfiguration engineConfiguration;

    public FormEngineImpl(FormEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.name = engineConfiguration.getEngineName();
        this.managementService = engineConfiguration.getFormManagementService();
        this.repositoryService = engineConfiguration.getFormRepositoryService();
        this.formService = engineConfiguration.getFormService();
        if (engineConfiguration.getSchemaManagementCmd() != null) {
            engineConfiguration.getCommandExecutor().execute(engineConfiguration.getSchemaCommandConfig(), engineConfiguration.getSchemaManagementCmd());
        }
        if (this.name == null) {
            LOGGER.info("default flowable FormEngine created");
        } else {
            LOGGER.info("FormEngine {} created", (Object)this.name);
        }
        FormEngines.registerFormEngine(this);
    }

    @Override
    public void close() {
        FormEngines.unregister(this);
        this.engineConfiguration.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FormManagementService getFormManagementService() {
        return this.managementService;
    }

    @Override
    public FormRepositoryService getFormRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public FormEngineConfiguration getFormEngineConfiguration() {
        return this.engineConfiguration;
    }
}

