/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.cmd;

import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntity;
import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeleteFormInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formInstanceId;

    public DeleteFormInstanceCmd(String formInstanceId) {
        this.formInstanceId = formInstanceId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.formInstanceId == null) {
            throw new FlowableIllegalArgumentException("formInstanceId is null");
        }
        FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
        FormInstanceEntity formInstance = (FormInstanceEntity)formInstanceEntityManager.findById(this.formInstanceId);
        if (formInstance == null) {
            throw new FlowableObjectNotFoundException("Form instance could not be found");
        }
        if (formInstance.getFormValuesId() != null) {
            CommandContextUtil.getResourceEntityManager(commandContext).delete(formInstance.getFormValuesId());
        }
        formInstanceEntityManager.delete(formInstance);
        return null;
    }
}

