/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.entity;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.pangubpm.common.utils.DateUtils;
import com.pangubpm.modules.form.constant.PanGuColumnType;
import com.pangubpm.modules.form.entity.FormBusinessEntity;
import com.pangubpm.modules.form.exception.BusinessException;
import com.pangubpm.modules.form.model.IBusColumnCtrl;
import com.pangubpm.modules.form.model.IBusinessTable;
import com.pangubpm.modules.form.model.IColumn;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FormBusinessModelColumnEntity
implements IColumn {
    private FormBusinessEntity businessTable;
    private String id;
    private String description;
    private String columnKey;
    private String name;
    private String javaType;
    private String tableId;
    private String defaultValue;
    private String format;
    private String dataType = PanGuColumnType.VARCHAR.toString();
    private int attrLength = 50;
    private int dbIsNull = 1;
    private int decimalLength = 0;
    private boolean required = false;
    private boolean primary = false;
    private boolean delete = false;
    private String createBy;
    private Date createTime;
    private String updateBy;
    private Date updateTime;
    private String tenantId;

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IBusColumnCtrl getCtrl() {
        return null;
    }

    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    @Override
    public String getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(String columnKey) {
        this.columnKey = columnKey == null ? null : columnKey.trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    @Override
    public String getTableId() {
        return this.tableId;
    }

    @Override
    public IBusinessTable getTable() {
        return null;
    }

    @Override
    public Object initValue() {
        Object value = this.value(this.defaultValue);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.name);
        jsonObject.put("description", (Object)this.description);
        jsonObject.put("dataType", (Object)this.dataType);
        jsonObject.put("value", value);
        return jsonObject;
    }

    @Override
    public Object initDefaultValue() {
        return this.value(this.defaultValue);
    }

    @Override
    public Object value(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        Object value = null;
        try {
            if (PanGuColumnType.VARCHAR.equalsWithKey(this.dataType) || PanGuColumnType.CLOB.equalsWithKey(this.dataType)) {
                value = str;
            } else if (PanGuColumnType.NUMBER.equalsWithKey(this.dataType)) {
                BigDecimal bigDecimal = new BigDecimal(str);
                value = bigDecimal.setScale(this.getDecimalLength(), RoundingMode.HALF_UP);
            } else if (PanGuColumnType.DATE.equalsWithKey(this.dataType)) {
                value = DateUtils.parse((String)str);
            }
        }
        catch (Exception e) {
            PanGuColumnType columnType = PanGuColumnType.getByKey(this.dataType);
            throw new BusinessException("\u5b57\u6bb5\u503c\u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6cd5\u628a\u5b57\u7b26\u4e32[" + str + "]\u8f6c\u5316\u6210" + columnType.getDesc() + "[" + columnType.getKey() + "]");
        }
        return value;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId == null ? null : tableId.trim();
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue == null ? null : defaultValue.trim();
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType == null ? null : dataType.trim();
    }

    @Override
    public int getAttrLength() {
        return this.attrLength;
    }

    public void setAttrLength(int attrLength) {
        this.attrLength = attrLength;
    }

    @Override
    public int getDecimalLength() {
        return this.decimalLength;
    }

    public void setDecimalLength(int decimalLength) {
        this.decimalLength = decimalLength;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy == null ? null : createBy.trim();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy == null ? null : updateBy.trim();
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public FormBusinessEntity getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(FormBusinessEntity businessTable) {
        this.businessTable = businessTable;
    }

    public void isPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public String getJavaType() {
        String javaType;
        String dataType = this.getDataType();
        PanGuColumnType columnType = PanGuColumnType.getByDbDataType(dataType);
        this.javaType = javaType = columnType.getJavaType();
        return javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String toString() {
        return "FormBusinessModelColumnEntity{businessTable=" + this.businessTable + ", id='" + this.id + '\'' + ", description='" + this.description + '\'' + ", columnKey='" + this.columnKey + '\'' + ", name='" + this.name + '\'' + ", javaType='" + this.javaType + '\'' + ", tableId='" + this.tableId + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", format='" + this.format + '\'' + ", dataType='" + this.dataType + '\'' + ", attrLength=" + this.attrLength + ", decimalLength=" + this.decimalLength + ", required=" + this.required + ", primary=" + this.primary + ", delete=" + this.delete + ", createBy='" + this.createBy + '\'' + ", createTime=" + this.createTime + ", updateBy='" + this.updateBy + '\'' + ", updateTime=" + this.updateTime + ", tenantId='" + this.tenantId + '\'' + '}';
    }

    public int getDbIsNull() {
        if (this.required) {
            this.dbIsNull = 0;
        }
        return this.dbIsNull;
    }

    public void setDbIsNull(int dbIsNull) {
        this.dbIsNull = dbIsNull;
    }
}

