/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;

public class BpmnModelUtils {
    public static void getPreNodeId(BpmnModel bpmnModel, String nodeId, List<String> existIds, List<String> finishedNodeIds) {
        FlowElement flowElement;
        if (existIds == null) {
            existIds = new ArrayList<String>();
        }
        if ((flowElement = bpmnModel.getMainProcess().getFlowElement(nodeId, true)) instanceof UserTask) {
            List incomingFlows;
            FlowNode flowNode = (FlowNode)flowElement;
            if (finishedNodeIds.contains(flowNode.getId())) {
                existIds.add(flowNode.getId());
            }
            if ((incomingFlows = flowNode.getIncomingFlows()) != null) {
                if (incomingFlows.size() == 0) {
                    SequenceFlow sequenceFlow = (SequenceFlow)incomingFlows.get(0);
                    String sourceRef = sequenceFlow.getSourceRef();
                    existIds.add(sourceRef);
                    BpmnModelUtils.getPreNodeId(bpmnModel, sourceRef, existIds, finishedNodeIds);
                } else {
                    String findSourceRef = "";
                    for (String history : finishedNodeIds) {
                        for (SequenceFlow sf : incomingFlows) {
                            String sourceRef = sf.getSourceRef();
                            FlowNode flowElementSourceRef = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sourceRef, true);
                            if (flowElementSourceRef instanceof UserTask) {
                                if (!sourceRef.equals(history)) continue;
                                if (finishedNodeIds.contains(flowElementSourceRef.getId())) {
                                    findSourceRef = flowElementSourceRef.getId();
                                    existIds.add(flowElementSourceRef.getId());
                                }
                                if (!StringUtils.isNotEmpty((CharSequence)findSourceRef)) continue;
                                break;
                            }
                            List incomingFlows1 = flowElementSourceRef.getIncomingFlows();
                            for (SequenceFlow sf1 : incomingFlows1) {
                                BpmnModelUtils.getPreNodeId(bpmnModel, sf1.getSourceRef(), existIds, finishedNodeIds);
                            }
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)findSourceRef)) continue;
                        break;
                    }
                    BpmnModelUtils.getPreNodeId(bpmnModel, findSourceRef, existIds, finishedNodeIds);
                }
            }
        }
    }

    public static String getPre(BpmnModel bpmnModel, String id) {
        String nodeId = "";
        FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(id, true);
        FlowNode flowNode = (FlowNode)flowElement;
        List incomingFlows = flowNode.getIncomingFlows();
        for (SequenceFlow sequenceFlow : incomingFlows) {
            String sourceRef = sequenceFlow.getSourceRef();
            FlowElement flowElement1 = bpmnModel.getMainProcess().getFlowElement(sourceRef, true);
            if (flowElement1 instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement1;
                nodeId = userTask.getId();
                continue;
            }
            FlowNode flowNode2 = (FlowNode)flowElement1;
            List incomingFlows1 = flowNode2.getIncomingFlows();
            if (incomingFlows1.size() == 0) {
                return "";
            }
            Iterator iterator = incomingFlows1.iterator();
            if (!iterator.hasNext()) continue;
            SequenceFlow sequenceFlow2 = (SequenceFlow)iterator.next();
            sourceRef = sequenceFlow2.getSourceRef();
            FlowElement flowElement3 = bpmnModel.getMainProcess().getFlowElement(sourceRef, true);
            if (flowElement3 instanceof UserTask) {
                nodeId = flowElement3.getId();
                continue;
            }
            return BpmnModelUtils.getPre(bpmnModel, sourceRef);
        }
        return nodeId;
    }

    public static FlowElement getStartFlowElement(BpmnModel bpmnMode) {
        Process mainProcess = BpmnModelUtils.getMainProcess(bpmnMode);
        FlowElement initialFlowElement = mainProcess.getInitialFlowElement();
        return initialFlowElement;
    }

    public static void getPreNodeInfo(BpmnModel bpmnModel, String taskDefinitionKey, List<NodeInfo> nodeInfoList) {
        Process mainProcess = BpmnModelUtils.getMainProcess(bpmnModel);
        BpmnModelUtils.getPreNodeInfo(mainProcess, nodeInfoList, mainProcess.getFlowElement(taskDefinitionKey, true));
    }

    public static void getStartNextNodeInfo(Process process, List<NodeInfo> nodeInfoList, FlowElement currentFlowElement) {
        if (currentFlowElement == null) {
            return;
        }
        if (currentFlowElement instanceof FlowNode) {
            FlowNode currentNode = (FlowNode)currentFlowElement;
            List outgoingFlows = currentNode.getOutgoingFlows();
            for (SequenceFlow sequenceFlow : outgoingFlows) {
                String targetRef = sequenceFlow.getTargetRef();
                FlowElement flowElement = process.getFlowElement(targetRef, true);
                if (flowElement != null && !(flowElement instanceof Gateway)) {
                    NodeInfo nodeInfo = new NodeInfo();
                    nodeInfo.setNodeId(targetRef);
                    nodeInfo.setNodeName(flowElement.getName());
                    if (nodeInfoList.contains(nodeInfo)) continue;
                    nodeInfoList.add(nodeInfo);
                    continue;
                }
                List outgoingFlows1 = currentNode.getOutgoingFlows();
                for (SequenceFlow sf : outgoingFlows1) {
                    FlowElement targetFlowElement = sf.getTargetFlowElement();
                    BpmnModelUtils.getStartNextNodeInfo(process, nodeInfoList, targetFlowElement);
                }
            }
        }
    }

    public static void getPreNodeInfo(Process process, List<NodeInfo> nodeInfoList, FlowElement currentFlowElement) {
        if (currentFlowElement == null) {
            return;
        }
        if (currentFlowElement instanceof FlowNode) {
            FlowNode currentNode = (FlowNode)currentFlowElement;
            List incomingFlows = currentNode.getIncomingFlows();
            for (SequenceFlow sequenceFlow : incomingFlows) {
                String sourceRef = sequenceFlow.getSourceRef();
                FlowElement flowElement = process.getFlowElement(sourceRef, true);
                if (flowElement != null && !(flowElement instanceof Gateway)) {
                    NodeInfo nodeInfo = new NodeInfo();
                    nodeInfo.setNodeId(sourceRef);
                    nodeInfo.setNodeName(flowElement.getName());
                    if (nodeInfoList.contains(nodeInfo)) continue;
                    nodeInfoList.add(nodeInfo);
                    continue;
                }
                List incomingFlows1 = currentNode.getIncomingFlows();
                for (SequenceFlow sf : incomingFlows1) {
                    FlowElement sourceFlowElement = sf.getSourceFlowElement();
                    BpmnModelUtils.getStartNextNodeInfo(process, nodeInfoList, sourceFlowElement);
                }
            }
        }
    }

    public static Process getMainProcess(BpmnModel bpmnMode) {
        return bpmnMode.getMainProcess();
    }

    public static class NodeInfo {
        private String nodeId;
        private String nodeName;

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String toString() {
            return "NodeInfo{nodeId='" + this.nodeId + '\'' + ", nodeName='" + this.nodeName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeInfo nodeInfo = (NodeInfo)o;
            return Objects.equals(this.nodeId, nodeInfo.nodeId) && Objects.equals(this.nodeName, nodeInfo.nodeName);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.nodeName);
        }
    }
}

