/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pangubpm.common.utils.StringUtils;
import com.pangubpm.common.xss.SQLFilter;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Query<T> {
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z0-9]");

    public IPage<T> getPage(Map<String, Object> params) {
        return this.getPage(params, null, false);
    }

    public IPage<T> getPage(Map<String, Object> params, String defaultOrderField, boolean isAsc) {
        long curPage = 1L;
        long limit = 10L;
        if (params.get("page") != null) {
            curPage = Long.parseLong(params.get("page").toString());
        }
        if (params.get("pageSize") != null) {
            limit = Long.parseLong(params.get("pageSize").toString());
        }
        Page page = new Page(curPage, limit);
        params.put("page", page);
        String orderField = SQLFilter.sqlInject((String)params.get("sidx"));
        String order = (String)params.get("order");
        if (StringUtils.isNotEmpty(orderField) && StringUtils.isNotEmpty(order)) {
            return page.addOrder(new OrderItem[]{"asc".equalsIgnoreCase(order) ? OrderItem.asc((String)orderField) : OrderItem.desc((String)orderField)});
        }
        if (StringUtils.isNotEmpty(defaultOrderField)) {
            return page.addOrder(new OrderItem[]{isAsc ? OrderItem.asc((String)defaultOrderField) : OrderItem.desc((String)defaultOrderField)});
        }
        return page;
    }

    public IPage<T> getPage(Class<T> clazz, long pageNumber, long pageSize, String orderField, String defaultOrderField, String order, boolean isAsc) {
        long curPage = pageNumber;
        long limit = pageSize;
        Page page = new Page(curPage, limit);
        if (StringUtils.isNotEmpty(orderField) && StringUtils.isNotEmpty(order)) {
            try {
                TableField objAnnotation;
                Field declaredField = clazz.getDeclaredField(orderField);
                if (declaredField != null && (objAnnotation = declaredField.getAnnotation(TableField.class)) != null && objAnnotation.exist()) {
                    orderField = SQLFilter.sqlInject(objAnnotation.value());
                    return page.addOrder(new OrderItem[]{"asc".equalsIgnoreCase(order) ? OrderItem.asc((String)orderField) : OrderItem.desc((String)orderField)});
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty(defaultOrderField)) {
            return page.addOrder(new OrderItem[]{isAsc ? OrderItem.asc((String)defaultOrderField) : OrderItem.desc((String)defaultOrderField)});
        }
        return page;
    }

    private String humpToLine(String str) {
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

